/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.gui.JesIcons;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.undo.JesUndoManager;
import de.uwemock.eur.gui.undo.SetReceiptDeletedEdit;
import de.uwemock.eur.gui.undo.SetReceiptNotDeletedEdit;
import de.uwemock.eur.receipt.AbstractReceipt;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class ActionDeleteReceipt
extends AbstractAction {
    private AbstractReceipt receipt;

    public ActionDeleteReceipt(AbstractReceipt r) {
        super(r.isDeleted() ? TextPool.getString("menuPopupUndeleteReceipt") : TextPool.getString("menuPopupDeleteReceipt"));
        this.putValue("SmallIcon", r.isDeleted() ? JesIcons.iconNotDeleted : JesIcons.iconDeleted);
        this.receipt = r;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.receipt.isDeleted()) {
            JesUndoManager.getInstance().addEdit(new SetReceiptNotDeletedEdit(this.receipt));
        } else {
            JesUndoManager.getInstance().addEdit(new SetReceiptDeletedEdit(this.receipt));
        }
        this.receipt.setDeleted(!this.receipt.isDeleted());
        this.receipt.notifyObservers();
    }
}

