/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.accounts.gui.AccountTableModel;
import de.uwemock.eur.gui.TextPool;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class ActionCorrectAccountList
extends AbstractAction {
    private Component parent;
    private AccountTableModel model;
    private AccountList accountList;
    private String[] accountTypes = new String[]{TextPool.getString("accountTypeSpending"), TextPool.getString("accountTypeIncome"), TextPool.getString("accountTypeSpendingTax"), TextPool.getString("accountTypeIncomeTax")};
    private int[] accountTypeValues = new int[]{1, 2, 5, 6};

    public ActionCorrectAccountList(Component parent, AccountList accountList, AccountTableModel model) {
        super(TextPool.getString("buttonCorrectAccountList"));
        this.parent = parent;
        this.model = model;
        this.accountList = accountList;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        int res = JOptionPane.showConfirmDialog(this.parent, TextPool.getString("msgAboutToCorrectAccountList"), TextPool.getString("titleCorrectAccountList"), 2);
        if (res == 0) {
            StringBuilder result = new StringBuilder(TextPool.getString("msgCorrectedAccountList"));
            block0: for (Account a : this.accountList) {
                if ((a.getAccountType() & 3) != 0) continue;
                if (a.getAccountNumber() < 500) {
                    a.setAccountType(a.getAccountType() | 1);
                } else {
                    a.setAccountType(a.getAccountType() | 2);
                }
                result.append(a.getAccountNumber());
                result.append(": ");
                int i = 0;
                while (i < this.accountTypeValues.length) {
                    if (a.getAccountType() == this.accountTypeValues[i]) {
                        result.append(this.accountTypes[i]);
                        result.append('\n');
                        continue block0;
                    }
                    ++i;
                }
            }
            JOptionPane.showMessageDialog(this.parent, result.toString(), TextPool.getString("titleCorrectAccountList"), 1);
            this.model.fireTableDataChanged();
            this.model.setChanged();
            this.setEnabled(false);
        }
    }
}

