/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.LocalizationManager;
import de.uwemock.eur.gui.CalculationDialog;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.OldDepreciationPool;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.guitools.AbstractToolbarAction;
import de.uwemock.htmltools.HtmlContext;
import de.uwemock.htmltools.HtmlSimpleElement;
import de.uwemock.htmltools.HtmlTable;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;

public class ActionCalcTax
extends AbstractToolbarAction {
    private JFrame parent;

    public ActionCalcTax(JFrame parent, String resourceIconSmall, String resourceIconLarge) {
        super(TextPool.getString("menuCalcTax"), resourceIconSmall, resourceIconLarge);
        this.parent = parent;
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String taxKey;
        CalculationDialog dialog = new CalculationDialog(this.parent, TextPool.getString("titleTimeSelectionDialog"), 4);
        dialog.setVisible(true);
        if (dialog.getResult() != 1) {
            dialog.dispose();
            return;
        }
        int timeFrame = dialog.getSelectedTimeFrame();
        String timeFrameText = dialog.getSelectedTimeFrameText();
        dialog.dispose();
        List<AbstractReceipt> receiptsToProcess = ReceiptGroupManager.getInstance().getReceiptCollectionByTimeFrame(timeFrame);
        receiptsToProcess.addAll(PoolManager.getInstance().getReceiptCollectionByTimeFrame(timeFrame));
        int businessYear = DataCenter.getInstance().getBusinessYear();
        HashMap<String, BigDecimal> incomeTaxItems = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> incomeAmountItems = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> spendingTaxItems = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> spendingAmountItems = new HashMap<String, BigDecimal>();
        for (Receipt receipt : receiptsToProcess) {
            if (receipt.isDeleted() || !receipt.isPaid() || receipt instanceof OldDepreciationPool || receipt.hasDepreciationStrategy() && receipt.getDepreciationStrategy().getStartYear() != businessYear) continue;
            Collection<Integer> accounts = receipt.accountNumbersAddedTo();
            int receiptType = -1;
            Iterator<Integer> i = accounts.iterator();
            while (i.hasNext()) {
                Account a = DataCenter.getInstance().getAccountList().getByAccountNumber(i.next());
                if (receiptType >= 0 || a == null) continue;
                receiptType = a.getAccountType();
                assert (receiptType == a.getAccountType()) : "Receipt of type " + receipt.getClass() + " contains accounts of multiple type";
            }
            if ((receiptType & 4) != 0) continue;
            Collection<String> taxKeys = receipt.taxKeysAddedTo();
            for (String taxKey2 : taxKeys) {
                BigDecimal newTaxSum;
                if ((receiptType & 2) > 0) {
                    if (taxKey2 == null) continue;
                    if (!incomeTaxItems.containsKey(taxKey2)) {
                        incomeTaxItems.put(taxKey2, Constants.ZERO);
                        incomeAmountItems.put(taxKey2, Constants.ZERO);
                    }
                    newTaxSum = ((BigDecimal)incomeTaxItems.get(taxKey2)).add(receipt.taxAddedToTaxKey(taxKey2));
                    BigDecimal newIncomeSum = ((BigDecimal)incomeAmountItems.get(taxKey2)).add(receipt.amountAddedToTaxKey(taxKey2));
                    incomeTaxItems.put(taxKey2, newTaxSum);
                    incomeAmountItems.put(taxKey2, newIncomeSum);
                }
                if ((receiptType & 1) <= 0 || taxKey2 == null) continue;
                if (!spendingTaxItems.containsKey(taxKey2)) {
                    spendingTaxItems.put(taxKey2, Constants.ZERO);
                    spendingAmountItems.put(taxKey2, Constants.ZERO);
                }
                newTaxSum = ((BigDecimal)spendingTaxItems.get(taxKey2)).add(receipt.taxAddedToTaxKey(taxKey2));
                BigDecimal newSpendingSum = ((BigDecimal)spendingAmountItems.get(taxKey2)).add(receipt.amountAddedToTaxKey(taxKey2));
                spendingTaxItems.put(taxKey2, newTaxSum);
                spendingAmountItems.put(taxKey2, newSpendingSum);
            }
        }
        String string = "body { font-family:Verdana,Arial,Helvetia,sans-serif; }\nh1 { }\nh3 { }\ntd.general_label { font-weight:bold; font-size:80%; }\ntd.general_contents { font-size:80%; }\nth { background-color:#e0e0e0; }\ntd.headline { background-color:#e0e0e0; }\ntd.label_tax { }\ntd.label_result { font-weight:bold; background-color:#ffffa0; }\ntd.amount_tax { font-family:monospace; }\ntd.amount_result { font-family:monospace; font-weight:bold; background-color:#ffffa0; }\ntd.final_result { font-family:monospace; font-weight:bold; background-color:#ffff66; }\n";
        HtmlContext html = new HtmlContext();
        html.setTitle(TextPool.getString("htmlTitleCalcTax"));
        html.addStyleSheet("all", string);
        html.addElement(new HtmlSimpleElement("h1", null, null, null, TextPool.getString("htmlTitleCalcTax")));
        html.addElement(new HtmlSimpleElement("h3", null, null, null, String.valueOf(timeFrameText) + " " + DataCenter.getInstance().getBusinessYear()));
        html.addElement(DataCenter.getInstance().createGeneralDataHtmlTable());
        html.addLineBreak();
        HtmlTable taxTable = new HtmlTable();
        taxTable.setCellspacing("0px");
        taxTable.setCellpadding("4px");
        BigDecimal incomeAmountAll = Constants.ZERO;
        BigDecimal incomeTaxAll = Constants.ZERO;
        BigDecimal spendingsAmountAll = Constants.ZERO;
        BigDecimal spendingsTaxAll = Constants.ZERO;
        taxTable.setContents(0, 0, TextPool.getString("htmlTextTaxVat"));
        taxTable.setHeadline(0, 0, true);
        taxTable.setAlign(0, 0, "left");
        taxTable.setCssClass(1, 0, "headline");
        taxTable.setContents(1, 0, TextPool.getString("htmlTextPayments"));
        taxTable.setAlign(1, 0, "center");
        taxTable.setCssClass(1, 0, "headline");
        taxTable.setContents(2, 0, TextPool.getString("htmlTextTax"));
        taxTable.setAlign(2, 0, "center");
        taxTable.setCssClass(2, 0, "headline");
        int y = 1;
        Set taxEntrySet = incomeTaxItems.entrySet();
        for (Map.Entry taxEntry : taxEntrySet) {
            taxKey = (String)taxEntry.getKey();
            taxTable.setContents(0, y, taxKey);
            taxTable.setCssClass(0, y, "label_tax");
            taxTable.setContents(1, y, LocalizationManager.amountToCurrencyString((BigDecimal)incomeAmountItems.get(taxKey)));
            taxTable.setCssClass(1, y, "amount_tax");
            taxTable.setAlign(1, y, "right");
            incomeAmountAll = incomeAmountAll.add((BigDecimal)incomeAmountItems.get(taxKey));
            taxTable.setContents(2, y, LocalizationManager.amountToCurrencyString((BigDecimal)taxEntry.getValue()));
            taxTable.setCssClass(2, y, "amount_tax");
            taxTable.setAlign(2, y, "right");
            incomeTaxAll = incomeTaxAll.add((BigDecimal)incomeTaxItems.get(taxKey));
            ++y;
        }
        taxTable.setContents(0, y, TextPool.getString("htmlTextSumPayments"));
        taxTable.setCssClass(0, y, "label_result");
        taxTable.setContents(1, y, LocalizationManager.amountToCurrencyString(incomeAmountAll));
        taxTable.setCssClass(1, y, "amount_result");
        taxTable.setAlign(1, y, "right");
        taxTable.setContents(0, ++y, TextPool.getString("htmlTextSumTax"));
        taxTable.setCssClass(0, y, "label_result");
        taxTable.setCssClass(1, y, "label_result");
        taxTable.setContents(2, y, LocalizationManager.amountToCurrencyString(incomeTaxAll));
        taxTable.setCssClass(2, y, "amount_result");
        taxTable.setAlign(2, y, "right");
        taxTable.setContents(0, ++y, "<br>");
        taxTable.setContents(0, ++y, TextPool.getString("htmlTextTaxPaidVat"));
        taxTable.setHeadline(0, y, true);
        taxTable.setAlign(0, y, "left");
        taxTable.setCssClass(0, y, "headline");
        taxTable.setContents(1, y, TextPool.getString("htmlTextPayments"));
        taxTable.setAlign(1, y, "center");
        taxTable.setCssClass(1, y, "headline");
        taxTable.setContents(2, y, TextPool.getString("htmlTextTax"));
        taxTable.setAlign(2, y, "center");
        taxTable.setCssClass(2, y, "headline");
        ++y;
        taxEntrySet = spendingTaxItems.entrySet();
        for (Map.Entry taxEntry : taxEntrySet) {
            taxKey = (String)taxEntry.getKey();
            taxTable.setContents(0, y, taxKey);
            taxTable.setCssClass(0, y, "label_tax");
            taxTable.setContents(1, y, LocalizationManager.amountToCurrencyString((BigDecimal)spendingAmountItems.get(taxKey)));
            taxTable.setCssClass(1, y, "amount_tax");
            taxTable.setAlign(1, y, "right");
            taxTable.setNoWrap(1, y, true);
            spendingsAmountAll = spendingsAmountAll.add((BigDecimal)spendingAmountItems.get(taxKey));
            taxTable.setContents(2, y, LocalizationManager.amountToCurrencyString((BigDecimal)taxEntry.getValue()));
            taxTable.setCssClass(2, y, "amount_tax");
            taxTable.setAlign(2, y, "right");
            taxTable.setNoWrap(2, y, true);
            spendingsTaxAll = spendingsTaxAll.add((BigDecimal)spendingTaxItems.get(taxKey));
            ++y;
        }
        taxTable.setContents(0, y, TextPool.getString("htmlTextSumPayments"));
        taxTable.setCssClass(0, y, "label_result");
        taxTable.setContents(1, y, LocalizationManager.amountToCurrencyString(spendingsAmountAll));
        taxTable.setCssClass(1, y, "amount_result");
        taxTable.setAlign(1, y, "right");
        taxTable.setNoWrap(1, y, true);
        taxTable.setContents(0, ++y, TextPool.getString("htmlTextSumTax"));
        taxTable.setCssClass(0, y, "label_result");
        taxTable.setCssClass(1, y, "label_result");
        taxTable.setContents(2, y, LocalizationManager.amountToCurrencyString(spendingsTaxAll));
        taxTable.setCssClass(2, y, "amount_result");
        taxTable.setAlign(2, y, "right");
        taxTable.setNoWrap(2, y, true);
        taxTable.setContents(0, ++y, "<br>");
        taxTable.setContents(0, ++y, TextPool.getString("htmlTextRemainingTax"));
        taxTable.setCssClass(0, y, "final_result");
        taxTable.setContents(1, y, "&nbsp;");
        taxTable.setCssClass(1, y, "final_result");
        taxTable.setContents(2, y, LocalizationManager.amountToCurrencyString(incomeTaxAll.subtract(spendingsTaxAll)));
        taxTable.setCssClass(2, y, "final_result");
        taxTable.setAlign(2, y, "right");
        taxTable.setNoWrap(2, y, true);
        html.addElement(taxTable);
        html.addElement(DataCenter.getInstance().createGeneralInfoHtml());
        DataCenter.getInstance().showHTML(html.toStringBuffer());
    }
}

