/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.csvtools.CsvTable;
import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.LocalizationManager;
import de.uwemock.eur.gui.CalculationDialog;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.TimeFrame;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.DepreciationPool;
import de.uwemock.eur.receipt.Payment;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.guitools.AbstractToolbarAction;
import de.uwemock.htmltools.HtmlContainer;
import de.uwemock.htmltools.HtmlContext;
import de.uwemock.htmltools.HtmlLink;
import de.uwemock.htmltools.HtmlSimpleElement;
import de.uwemock.htmltools.HtmlTable;
import de.uwemock.htmltools.HtmlText;
import de.uwemock.tools.LoggingManager;
import de.uwemock.tools.Numbers;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JFrame;

public class ActionCalcAccountSums
extends AbstractToolbarAction {
    private JFrame parent;
    private Map<Integer, BigDecimal> accountSumItemsExcludingTax;
    private Map<Integer, BigDecimal> accountSumItemsIncludingTax;
    private Set<Integer> accountsUsed;
    private boolean calcSumsExcludingTax;
    private boolean calcSumsIncludingTax;
    private boolean showTaxAccounts;
    private int columnNumberExcludingTax;
    private int columnNumberIncludingTax;
    private AccountList accountList;

    public ActionCalcAccountSums(JFrame parent, String resourceIconSmall, String resourceIconLarge) {
        super(TextPool.getString("menuCalcAccountSums"), resourceIconSmall, resourceIconLarge);
        this.parent = parent;
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        HtmlContext html;
        block41: {
            CalculationDialog dialog = new CalculationDialog(this.parent, TextPool.getString("titleTimeSelectionDialog"), 196);
            dialog.setVisible(true);
            if (dialog.getResult() != 1) {
                dialog.dispose();
                return;
            }
            int timeFrame = dialog.getSelectedTimeFrame();
            String timeFrameText = dialog.getSelectedTimeFrameText();
            dialog.dispose();
            List<AbstractReceipt> receiptsToProcess = ReceiptGroupManager.getInstance().getReceiptCollectionByTimeFrame(timeFrame);
            List<Integer> poolYears = PoolManager.getInstance().getContainedYears();
            for (Integer n : poolYears) {
                DepreciationPool r = PoolManager.getInstance().getDepreciationPoolForYear(n);
                if (!TimeFrame.isInTimeFrame(timeFrame, r.getDate())) continue;
                receiptsToProcess.add(r);
            }
            this.accountList = DataCenter.getInstance().getAccountList();
            this.calcSumsExcludingTax = dialog.isColumnSelectedExcludingTax();
            this.calcSumsIncludingTax = dialog.isColumnSelectedIncludingTax();
            this.showTaxAccounts = dialog.isShowTaxAccountsSelected();
            if (!this.calcSumsExcludingTax && !this.calcSumsIncludingTax) {
                this.calcSumsIncludingTax = true;
            }
            if (this.calcSumsExcludingTax) {
                this.columnNumberExcludingTax = 2;
            }
            if (this.calcSumsIncludingTax) {
                this.columnNumberIncludingTax = this.calcSumsExcludingTax ? 3 : 2;
            }
            this.accountSumItemsExcludingTax = new HashMap<Integer, BigDecimal>();
            this.accountSumItemsIncludingTax = new HashMap<Integer, BigDecimal>();
            this.accountsUsed = new TreeSet<Integer>();
            for (Receipt receipt : receiptsToProcess) {
                if (receipt.isDeleted() || !receipt.isPaid()) continue;
                Collection<Payment> payments = receipt.getAllPayments();
                for (Payment payment : payments) {
                    this.addToAccount(payment);
                }
            }
            String string = "body { font-family:Verdana,Arial,Helvetia,sans-serif; }\nh1 { }\nh3 { }\ntd.general_label { font-weight:bold; font-size:80%; }\ntd.general_contents { font-size:80%; }\nth { background-color:#e0e0e0; }\ntr.row_even { background-color:#f0f0f0; }\ntd.row_odd { background-color:#ffffff; }\ntd.cell_sum { font-family:monospace; text-align:right; white-space:nowrap; }\ntd.total { font-weight:bold; }";
            String accountCssPrint = ".noprint { display:none; }\n";
            BigDecimal incomingExcludingTax = Numbers.BIG_DECIMAL_ZERO;
            BigDecimal incomingIncludingTax = Numbers.BIG_DECIMAL_ZERO;
            BigDecimal outgoingExcludingTax = Numbers.BIG_DECIMAL_ZERO;
            BigDecimal outgoingIncludingTax = Numbers.BIG_DECIMAL_ZERO;
            html = new HtmlContext();
            html.setTitle(TextPool.getString("htmlTitleAccountSums"));
            html.addStyleSheet(null, string);
            html.addStyleSheet("print", accountCssPrint);
            html.addElement("h1", null, null, null, TextPool.getString("htmlTitleAccountSums"));
            html.addElement("h3", null, null, null, String.valueOf(timeFrameText) + " " + DataCenter.getInstance().getBusinessYear());
            html.addElement(DataCenter.getInstance().createGeneralDataHtmlTable());
            html.addLineBreak();
            HtmlTable outgoingAccountsHtmlTable = this.createTable(html);
            HtmlTable incomingAccountsHtmlTable = this.createTable(html);
            CsvTable accountsCsvTable = new CsvTable();
            accountsCsvTable.setContents(0, 0, TextPool.getString("htmlTextAccountNumber"));
            accountsCsvTable.setContents(1, 0, TextPool.getString("htmlTextAccountDesc"));
            if (this.calcSumsExcludingTax) {
                accountsCsvTable.setContents(this.columnNumberExcludingTax, 0, String.valueOf(TextPool.getString("htmlTextAccountSum")) + " (" + TextPool.getString("labelInfoAmountExcludingTax") + ")");
            }
            if (this.calcSumsIncludingTax) {
                accountsCsvTable.setContents(this.columnNumberIncludingTax, 0, String.valueOf(TextPool.getString("htmlTextAccountSum")) + " (" + TextPool.getString("labelInfoAmountIncludingTax") + ")");
            }
            int yOut = 1;
            int yIn = 1;
            int yCsv = 1;
            for (Integer account : this.accountsUsed) {
                Account a = this.accountList.getByAccountNumber(account);
                if (a == null) continue;
                HtmlTable targetTable = null;
                boolean even = false;
                int y = 0;
                if (a.isIncomeAccount()) {
                    targetTable = incomingAccountsHtmlTable;
                    even = yIn % 2 == 0;
                    y = yIn++;
                }
                if (a.isSpendingsAccount()) {
                    targetTable = outgoingAccountsHtmlTable;
                    even = yOut % 2 == 0;
                    y = yOut++;
                }
                if (targetTable != null) {
                    if (even) {
                        targetTable.setRowCssClass(y, "row_even");
                    } else {
                        outgoingAccountsHtmlTable.setRowCssClass(y, "row_odd");
                    }
                    targetTable.setContents(0, y, Integer.toString(a.getAccountNumber()));
                    targetTable.setCssClass(0, y, "cell_number");
                    targetTable.setContents(1, y, a.getAccountName());
                    targetTable.setCssClass(1, y, "cell_text");
                    BigDecimal accountSumExcludingTax = this.accountSumItemsExcludingTax.get(a.getAccountNumber());
                    BigDecimal accountSumIncludingTax = this.accountSumItemsIncludingTax.get(a.getAccountNumber());
                    if (a.isIncomeAccount()) {
                        incomingExcludingTax = incomingExcludingTax.add(accountSumExcludingTax);
                        incomingIncludingTax = incomingIncludingTax.add(accountSumIncludingTax);
                    }
                    if (a.isSpendingsAccount()) {
                        outgoingExcludingTax = outgoingExcludingTax.add(accountSumExcludingTax);
                        outgoingIncludingTax = outgoingIncludingTax.add(accountSumIncludingTax);
                    }
                    if (this.calcSumsExcludingTax) {
                        targetTable.setContents(this.columnNumberExcludingTax, y, LocalizationManager.amountToCurrencyString(accountSumExcludingTax));
                        targetTable.setCssClass(this.columnNumberExcludingTax, y, "cell_sum");
                    }
                    if (this.calcSumsIncludingTax) {
                        targetTable.setContents(this.columnNumberIncludingTax, y, LocalizationManager.amountToCurrencyString(accountSumIncludingTax));
                        targetTable.setCssClass(this.columnNumberIncludingTax, y, "cell_sum");
                    }
                }
                accountsCsvTable.setContents(0, yCsv, Integer.toString(a.getAccountNumber()));
                accountsCsvTable.setContents(1, yCsv, a.getAccountName());
                if (this.calcSumsExcludingTax) {
                    accountsCsvTable.setContents(this.columnNumberExcludingTax, yCsv, LocalizationManager.amountToPlainString(this.accountSumItemsExcludingTax.get(a.getAccountNumber())));
                }
                if (this.calcSumsIncludingTax) {
                    accountsCsvTable.setContents(this.columnNumberIncludingTax, yCsv, LocalizationManager.amountToPlainString(this.accountSumItemsIncludingTax.get(a.getAccountNumber())));
                }
                ++yCsv;
            }
            if (this.calcSumsExcludingTax) {
                outgoingAccountsHtmlTable.setContents(this.columnNumberExcludingTax, yOut, LocalizationManager.amountToCurrencyString(outgoingExcludingTax));
                outgoingAccountsHtmlTable.setCssClass(this.columnNumberExcludingTax, yOut, "cell_sum total");
                incomingAccountsHtmlTable.setContents(this.columnNumberExcludingTax, yIn, LocalizationManager.amountToCurrencyString(incomingExcludingTax));
                incomingAccountsHtmlTable.setCssClass(this.columnNumberExcludingTax, yIn, "cell_sum total");
            }
            if (this.calcSumsIncludingTax) {
                outgoingAccountsHtmlTable.setContents(this.columnNumberIncludingTax, yOut, LocalizationManager.amountToCurrencyString(outgoingIncludingTax));
                outgoingAccountsHtmlTable.setCssClass(this.columnNumberIncludingTax, yOut, "cell_sum total");
                incomingAccountsHtmlTable.setContents(this.columnNumberIncludingTax, yIn, LocalizationManager.amountToCurrencyString(incomingIncludingTax));
                incomingAccountsHtmlTable.setCssClass(this.columnNumberIncludingTax, yIn, "cell_sum total");
            }
            outgoingAccountsHtmlTable.setRowAsFooter(yOut, true);
            incomingAccountsHtmlTable.setRowAsFooter(yIn, true);
            HtmlTable totalsTable = new HtmlTable(html);
            totalsTable.addCssStyle("width", "100%");
            totalsTable.setCellspacing("0px");
            totalsTable.setCellpadding("4px");
            totalsTable.setBorder("none");
            totalsTable.setHeadline(0, 0, true);
            totalsTable.setContents(0, 0, "&nbsp;");
            totalsTable.setHeadline(1, 0, true);
            totalsTable.setContents(1, 0, "&nbsp;");
            if (this.calcSumsExcludingTax) {
                totalsTable.setContents(this.columnNumberExcludingTax, 0, TextPool.getString("labelInfoAmountExcludingTax"));
                totalsTable.setHeadline(this.columnNumberExcludingTax, 0, true);
                totalsTable.setAlign(this.columnNumberExcludingTax, 0, "right");
                totalsTable.setCssClass(this.columnNumberExcludingTax, 0, "sorttable_numeric");
                totalsTable.setCssStyle(this.columnNumberExcludingTax, 0, "width:1px; white-space:nowrap;");
            }
            if (this.calcSumsIncludingTax) {
                totalsTable.setContents(this.columnNumberIncludingTax, 0, TextPool.getString("labelInfoAmountIncludingTax"));
                totalsTable.setHeadline(this.columnNumberIncludingTax, 0, true);
                totalsTable.setAlign(this.columnNumberIncludingTax, 0, "right");
                totalsTable.setCssClass(this.columnNumberIncludingTax, 0, "sorttable_numeric");
                totalsTable.setCssStyle(this.columnNumberIncludingTax, 0, "width:1px; white-space:nowrap;");
            }
            totalsTable.setRowAsHeader(0, true);
            totalsTable.setContents(0, 1, TextPool.getString("htmlTextTotalIncoming"));
            totalsTable.setContents(0, 2, TextPool.getString("htmlTextTotalOutgoing"));
            totalsTable.setContents(0, 3, TextPool.getString("htmlTextTotal"));
            if (this.calcSumsExcludingTax) {
                totalsTable.setContents(this.columnNumberExcludingTax, 1, LocalizationManager.amountToCurrencyString(incomingExcludingTax));
                totalsTable.setContents(this.columnNumberExcludingTax, 2, "-" + LocalizationManager.amountToCurrencyString(outgoingExcludingTax));
                totalsTable.setContents(this.columnNumberExcludingTax, 3, LocalizationManager.amountToCurrencyString(incomingExcludingTax.subtract(outgoingExcludingTax)));
                totalsTable.setCssClass(this.columnNumberExcludingTax, 1, "cell_sum");
                totalsTable.setCssClass(this.columnNumberExcludingTax, 2, "cell_sum");
                totalsTable.setCssClass(this.columnNumberExcludingTax, 3, "cell_sum total");
            }
            if (this.calcSumsIncludingTax) {
                totalsTable.setContents(this.columnNumberIncludingTax, 1, LocalizationManager.amountToCurrencyString(incomingIncludingTax));
                totalsTable.setContents(this.columnNumberIncludingTax, 2, "-" + LocalizationManager.amountToCurrencyString(outgoingIncludingTax));
                totalsTable.setContents(this.columnNumberIncludingTax, 3, LocalizationManager.amountToCurrencyString(incomingIncludingTax.subtract(outgoingIncludingTax)));
                totalsTable.setCssClass(this.columnNumberIncludingTax, 1, "cell_sum");
                totalsTable.setCssClass(this.columnNumberIncludingTax, 2, "cell_sum");
                totalsTable.setCssClass(this.columnNumberIncludingTax, 3, "cell_sum total");
            }
            HtmlTable surroundingTable = new HtmlTable(html);
            surroundingTable.setCellpadding("0");
            surroundingTable.setCellspacing("0");
            surroundingTable.setBorder("none");
            surroundingTable.setContents(0, 0, new HtmlSimpleElement("h3", null, null, null, TextPool.getString("accountTypeIncome")));
            surroundingTable.setContents(0, 1, incomingAccountsHtmlTable);
            surroundingTable.setContents(0, 2, new HtmlSimpleElement("h3", null, null, null, TextPool.getString("accountTypeSpending")));
            surroundingTable.setContents(0, 3, outgoingAccountsHtmlTable);
            surroundingTable.setContents(0, 4, "&nbsp;");
            surroundingTable.setContents(0, 5, totalsTable);
            html.addElement(surroundingTable);
            html.addElement(DataCenter.getInstance().createGeneralInfoHtml());
            Calendar c = Calendar.getInstance();
            OutputStreamWriter writer = null;
            try {
                try {
                    File file = File.createTempFile(String.valueOf(String.format("%4d-%02d-%02d", c.get(1), c.get(2) + 1, c.get(5))) + "_eur_accounts", ".csv");
                    file.deleteOnExit();
                    writer = new FileWriter(file);
                    writer.write(accountsCsvTable.toCsvString().toString());
                    writer.flush();
                    HtmlLink link = new HtmlLink(file.getName());
                    link.addHtmlElement(new HtmlText(TextPool.getString("htmlTextLinkToCsv")));
                    HtmlContainer linkContainer = new HtmlContainer("p");
                    linkContainer.addCssClass("noprint");
                    linkContainer.addHtmlElement(link);
                    html.addElement(linkContainer);
                }
                catch (IOException e1) {
                    LoggingManager.logException(this.getClass(), e1);
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e2) {
                            LoggingManager.logException(this.getClass(), e2);
                        }
                    }
                    break block41;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        LoggingManager.logException(this.getClass(), e2);
                    }
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e2) {
                    LoggingManager.logException(this.getClass(), e2);
                }
            }
        }
        DataCenter.getInstance().showHTML(html.toStringBuffer());
    }

    private HtmlTable createTable(HtmlContext html) {
        HtmlTable table = new HtmlTable(html, true);
        table.addCssStyle("width", "100%");
        table.setCellspacing("0px");
        table.setCellpadding("4px");
        table.setBorder("none");
        table.setContents(0, 0, TextPool.getString("htmlTextAccountNumber"));
        table.setHeadline(0, 0, true);
        table.setContents(1, 0, TextPool.getString("htmlTextAccountDesc"));
        table.setHeadline(1, 0, true);
        if (this.calcSumsExcludingTax) {
            table.setContents(this.columnNumberExcludingTax, 0, String.valueOf(TextPool.getString("htmlTextAccountSum")) + " (" + TextPool.getString("labelInfoAmountExcludingTax") + ")");
            table.setHeadline(this.columnNumberExcludingTax, 0, true);
            table.setAlign(this.columnNumberExcludingTax, 0, "right");
            table.setCssClass(this.columnNumberExcludingTax, 0, "sorttable_numeric");
            table.setCssStyle(this.columnNumberExcludingTax, 0, "width:1px; white-space:nowrap;");
        }
        if (this.calcSumsIncludingTax) {
            table.setContents(this.columnNumberIncludingTax, 0, String.valueOf(TextPool.getString("htmlTextAccountSum")) + " (" + TextPool.getString("labelInfoAmountIncludingTax") + ")");
            table.setHeadline(this.columnNumberIncludingTax, 0, true);
            table.setAlign(this.columnNumberIncludingTax, 0, "right");
            table.setCssClass(this.columnNumberIncludingTax, 0, "sorttable_numeric");
            table.setCssStyle(this.columnNumberIncludingTax, 0, "width:1px; white-space:nowrap;");
        }
        table.setRowAsHeader(0, true);
        return table;
    }

    private void addToAccount(Payment payment) {
        Integer account = payment.getAccount();
        Account a = this.accountList.getByAccountNumber(account);
        if (a.isTaxAccount() && !this.showTaxAccounts) {
            return;
        }
        this.accountsUsed.add(account);
        if (!this.accountSumItemsExcludingTax.containsKey(account)) {
            this.accountSumItemsExcludingTax.put(account, Constants.ZERO);
        }
        if (!this.accountSumItemsIncludingTax.containsKey(account)) {
            this.accountSumItemsIncludingTax.put(account, Constants.ZERO);
        }
        BigDecimal amountExcludingTax = payment.getAmountExcludingTax();
        BigDecimal newAccountSum = this.accountSumItemsExcludingTax.get(account).add(amountExcludingTax);
        this.accountSumItemsExcludingTax.put(account, newAccountSum);
        BigDecimal amountIncludingTax = payment.getAmountIncludingTax();
        newAccountSum = this.accountSumItemsIncludingTax.get(account).add(amountIncludingTax);
        this.accountSumItemsIncludingTax.put(account, newAccountSum);
    }
}

