/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.datetools.Date;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.gui.DepreciationCreationPanel;
import de.uwemock.eur.depreciation.gui.DepreciationFactory;
import de.uwemock.eur.gui.JesIcons;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.undo.AddDepreciationEdit;
import de.uwemock.eur.gui.undo.JesUndoManager;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.guitools.StandardDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class ActionAddDepreciation
extends AbstractAction {
    private int businessYear;
    private Frame parent;
    private AbstractReceipt receipt;

    public ActionAddDepreciation(Frame parent, AbstractReceipt r, int businessYear) {
        super(TextPool.getString("menuPopupAddDepreciation"));
        this.putValue("SmallIcon", JesIcons.iconDepreciation);
        this.parent = parent;
        this.receipt = r;
        this.businessYear = businessYear;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DepreciationCreationPanel dcp = new DepreciationCreationPanel(this.receipt.getDate());
        StandardDialog dialog = new StandardDialog(this.parent, dcp.getTitle(), dcp);
        dialog.setVisible(true);
        int numYears = dcp.getNumYears();
        int type = dcp.getDepreciationType();
        Date date = dcp.getDate();
        if (dialog.getResult() == 1 && numYears > 0 && type >= 0) {
            DepreciationStrategy strategy = DepreciationFactory.createDepreciationStrategy(this.parent, this.receipt, type, numYears, date, this.businessYear);
            this.receipt.setDepreciationStrategy(strategy);
            this.receipt.setChanged();
            this.receipt.notifyObservers();
            JesUndoManager.getInstance().addEdit(new AddDepreciationEdit(this.receipt, strategy));
        }
        dialog.dispose();
    }
}

