/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.AbstractDepreciationStrategy;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.formatter.ReceiptDescriptionFormatter;
import de.uwemock.tools.LRUCache;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TooltipCenter
implements Observer {
    public static final int TOOLTIP_ACCOUNT = 0;
    public static final int TOOLTIP_STATUS = 1;
    public static final int TOOLTIP_AMOUNT = 2;
    private static final int NUM_TOOLTIP_MAPS = 3;
    private static final int MAX_MAP_SIZE = 512;
    private static volatile TooltipCenter instance;
    private final Map<AbstractReceipt, String>[] tooltipMaps = new Map[3];
    private StringBuilder statusInfo = new StringBuilder();

    private TooltipCenter() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        int i = 0;
        while (i < 3) {
            this.tooltipMaps[i] = new LRUCache<AbstractReceipt, String>(512, logger.isLoggable(Level.FINE));
            ((LRUCache)this.tooltipMaps[i]).setCacheTitle("TooltipCenter.tooltipMap[" + i + "]");
            ++i;
        }
    }

    public static synchronized TooltipCenter getInstance() {
        if (instance == null) {
            instance = new TooltipCenter();
        }
        return instance;
    }

    public String getTooltip(AbstractReceipt r, int tooltipType) {
        if (r == null || tooltipType < 0 || tooltipType >= 3) {
            return null;
        }
        Map<AbstractReceipt, String> tooltipMap = this.tooltipMaps[tooltipType];
        String result = tooltipMap.get(r);
        if (result != null) {
            return result;
        }
        result = this.createTooltip(r, tooltipType);
        tooltipMap.put(r, result);
        r.addObserver(this);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createTooltip(AbstractReceipt r, int tooltipType) {
        StringBuilder stringBuilder = this.statusInfo;
        synchronized (stringBuilder) {
            switch (tooltipType) {
                case 0: {
                    AccountList accountList = DataCenter.getInstance().getAccountList();
                    Collection accounts = r.getAllAccountNumbers();
                    if (accounts.size() == 1) {
                        Iterator i = accounts.iterator();
                        Integer account = (Integer)i.next();
                        this.statusInfo.setLength(0);
                        this.statusInfo.append(account);
                        this.statusInfo.append(' ');
                        Account accountFromList = accountList.getByAccountNumber(account);
                        if (accountFromList != null) {
                            this.statusInfo.append(accountFromList.getAccountName());
                        } else {
                            this.statusInfo.append(TextPool.getString("labelAccountUnknown"));
                        }
                        return this.statusInfo.toString();
                    }
                    this.statusInfo.setLength(0);
                    this.statusInfo.append("<html><body><table border=\"0\">");
                    for (Integer accountNumber : accounts) {
                        this.statusInfo.append("<tr><td>");
                        Account account = accountList.getByAccountNumber(accountNumber);
                        this.statusInfo.append(accountNumber.toString());
                        this.statusInfo.append("</td><td>");
                        this.statusInfo.append(account != null ? account.getAccountName() : TextPool.getString("labelAccountUnknown"));
                        this.statusInfo.append("</td></tr>");
                    }
                    this.statusInfo.append("</table></body></html>");
                    return this.statusInfo.toString();
                }
                case 1: {
                    List<Attachment> attachments = r.getAttachments();
                    int size = attachments.size();
                    if (size > 0) {
                        this.statusInfo.setLength(0);
                        this.statusInfo.append("<html>");
                        this.statusInfo.append(attachments.size());
                        this.statusInfo.append(' ');
                        this.statusInfo.append(size == 1 ? TextPool.getString("textAttachment") : TextPool.getString("textAttachments"));
                        this.statusInfo.append(':');
                        for (Attachment attachment : attachments) {
                            this.statusInfo.append("<br>");
                            this.statusInfo.append(attachment.getFilename());
                        }
                        this.statusInfo.append("</html>");
                        return this.statusInfo.toString();
                    }
                    return TextPool.getString("textNoAttachments");
                }
                case 2: {
                    this.statusInfo.setLength(0);
                    this.statusInfo.append("<html>");
                    this.statusInfo.append(ReceiptDescriptionFormatter.getPaymentsTableAsHTML(r.getAllPayments()).toHtmlString());
                    if (r.hasDepreciationStrategy()) {
                        this.statusInfo.append("<br><hr>");
                        this.statusInfo.append(((AbstractDepreciationStrategy)r.getDepreciationStrategy()).getDepreciationTableAsHTML());
                    }
                    this.statusInfo.append("</html>");
                    return this.statusInfo.toString();
                }
            }
        }
        return "";
    }

    public String getAccountTip(AbstractReceipt r) {
        return this.getTooltip(r, 0);
    }

    public String getStatusTip(AbstractReceipt r) {
        return this.getTooltip(r, 1);
    }

    public String getAmountTip(AbstractReceipt r) {
        return this.getTooltip(r, 2);
    }

    @Override
    public void update(Observable o, Object arg) {
        AbstractReceipt r = (AbstractReceipt)o;
        Map<AbstractReceipt, String>[] mapArray = this.tooltipMaps;
        int n = this.tooltipMaps.length;
        int n2 = 0;
        while (n2 < n) {
            Map<AbstractReceipt, String> tooltipMap = mapArray[n2];
            tooltipMap.remove(r);
            ++n2;
        }
        r.deleteObserver(this);
    }

    public void removeAllTooltips() {
        Map<AbstractReceipt, String>[] mapArray = this.tooltipMaps;
        int n = this.tooltipMaps.length;
        int n2 = 0;
        while (n2 < n) {
            Map<AbstractReceipt, String> tooltipMap = mapArray[n2];
            tooltipMap.clear();
            ++n2;
        }
    }
}

