/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import java.awt.BorderLayout;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;

public class TimeFrameSelectionPanel
extends AbstractStandardDialogPanel {
    private JComboBox timeFrameList = new JComboBox<String>(TextPool.TIMEFRAMES);
    private int selectedTimeFrame = -1;
    private String selectedTimeFrameText = null;

    public TimeFrameSelectionPanel(Window parent) {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleTimeSelectionDialog")));
        this.add("Center", this.timeFrameList);
    }

    public int getSelectedTimeFrame() {
        return this.selectedTimeFrame;
    }

    public String getSelectedTimeFrameText() {
        return this.selectedTimeFrameText;
    }

    @Override
    public void dialogOpens() {
        this.timeFrameList.setSelectedIndex(this.timeFrameList.getItemCount() - 1);
    }

    @Override
    public void saveDialogData() {
        int selected = this.timeFrameList.getSelectedIndex();
        this.selectedTimeFrameText = this.timeFrameList.getSelectedItem().toString();
        switch (selected) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.selectedTimeFrame = selected + 1;
                break;
            }
            case 12: {
                this.selectedTimeFrame = 41;
                break;
            }
            case 13: {
                this.selectedTimeFrame = 42;
                break;
            }
            case 14: {
                this.selectedTimeFrame = 43;
                break;
            }
            case 15: {
                this.selectedTimeFrame = 44;
                break;
            }
            case 16: {
                this.selectedTimeFrame = 100;
            }
        }
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleTimeSelectionDialog");
    }
}

