/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.datetools.Date;
import de.uwemock.eur.gui.TextPool;

public class TimeFrame {
    public static final int JANUARY = 1;
    public static final int FEBRUARY = 2;
    public static final int MARCH = 3;
    public static final int APRIL = 4;
    public static final int MAY = 5;
    public static final int JUNE = 6;
    public static final int JULY = 7;
    public static final int AUGUST = 8;
    public static final int SEPTEMBER = 9;
    public static final int OCTOBER = 10;
    public static final int NOVEMBER = 11;
    public static final int DECEMBER = 12;
    public static final int FIRST_QUARTER = 41;
    public static final int SECOND_QUARTER = 42;
    public static final int THIRD_QUARTER = 43;
    public static final int FOURTH_QUARTER = 44;
    public static final int WHOLE_YEAR = 100;

    private TimeFrame() {
    }

    public static boolean isInTimeFrame(int timeFrame, Date date) {
        if (timeFrame == 100) {
            return true;
        }
        int month = date.getMonth();
        if (timeFrame == 41) {
            return month == 1 || month == 2 || month == 3;
        }
        if (timeFrame == 42) {
            return month == 4 || month == 5 || month == 6;
        }
        if (timeFrame == 43) {
            return month == 7 || month == 8 || month == 9;
        }
        if (timeFrame == 44) {
            return month == 10 || month == 11 || month == 12;
        }
        if (timeFrame >= 1 && timeFrame <= 12) {
            return timeFrame == month;
        }
        return false;
    }

    public static String toString(int timeFrame) {
        if (timeFrame >= 1 && timeFrame <= 12) {
            return TextPool.TIMEFRAMES[timeFrame - 1];
        }
        if (timeFrame >= 41 && timeFrame <= 44) {
            return TextPool.TIMEFRAMES[-29 + timeFrame];
        }
        if (timeFrame == 100) {
            return TextPool.TIMEFRAMES[TextPool.TIMEFRAMES.length - 1];
        }
        return null;
    }
}

