/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

public class ThinkingComboBoxModel
extends DefaultComboBoxModel {
    private int maxItems = -1;

    public ThinkingComboBoxModel() {
    }

    public ThinkingComboBoxModel(int maxItems) {
        this.maxItems = maxItems;
    }

    public ThinkingComboBoxModel(Vector items) {
        super(items);
        this.sortItems();
    }

    public ThinkingComboBoxModel(Vector items, int maxItems) {
        this(items);
        this.maxItems = maxItems;
    }

    public ThinkingComboBoxModel(ComboBoxModel model) {
        int i = 0;
        while (i < model.getSize()) {
            this.addElement(model.getElementAt(i));
            ++i;
        }
    }

    @Override
    public void addElement(Object newElement) {
        if (newElement instanceof ListItem) {
            super.addElement(newElement);
        } else {
            super.addElement(new ListItem(newElement));
        }
    }

    @Override
    public void insertElementAt(Object newElement, int index) {
        if (newElement instanceof ListItem) {
            super.insertElementAt(newElement, index);
        } else {
            super.insertElementAt(new ListItem(newElement), index);
        }
    }

    public void addToList(Object newItem) {
        this.addToList(newItem, false);
    }

    public void addToList(Object newItem, boolean fixed) {
        ListItem newListItem = null;
        int i = 0;
        while (i < this.getSize()) {
            ListItem item = (ListItem)this.getElementAt(i);
            if (item.contents.toString().equals(newItem.toString())) {
                if (item.isFixed()) {
                    return;
                }
                newListItem = item;
                this.removeElement(item);
                break;
            }
            ++i;
        }
        if (newListItem == null) {
            newListItem = new ListItem(newItem, fixed);
        }
        i = 0;
        if (!newListItem.isFixed()) {
            while (i < this.getSize()) {
                ListItem iItem = (ListItem)this.getElementAt(i);
                if (iItem.isFixed() == fixed) break;
                ++i;
            }
        }
        this.insertElementAt(newListItem, i);
        if (this.maxItems > 0) {
            while (this.getSize() > this.maxItems) {
                int j = this.getSize() - 1;
                while (i >= 0 && ((ListItem)this.getElementAt(j)).isFixed()) {
                    --j;
                }
                if (j < 0) break;
                this.removeElementAt(j);
            }
        }
        this.setSelectedItem(newListItem);
    }

    public void setItemContents(int index, Object contents) {
        ((ListItem)this.getElementAt(index)).setItem(contents);
    }

    public void setItemFixed(int index, boolean fixed) {
        ((ListItem)this.getElementAt(index)).setFixed(fixed);
    }

    public boolean isItemFixed(int index) {
        return ((ListItem)this.getElementAt(index)).isFixed();
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public void sortItems() {
        boolean again = true;
        while (again) {
            again = false;
            int i = 0;
            while (i < this.getSize() - 1) {
                ListItem item1 = (ListItem)this.getElementAt(i);
                ListItem item2 = (ListItem)this.getElementAt(i + 1);
                if (!item1.isFixed() && item2.isFixed()) {
                    this.removeElementAt(i + 1);
                    this.insertElementAt(item2, i);
                    again = true;
                }
                ++i;
            }
        }
    }

    static class ListItem {
        private boolean fixed = false;
        private Object contents;

        public ListItem(Object contents) {
            this.contents = contents;
        }

        public ListItem(Object contents, boolean fixed) {
            this(contents);
            this.fixed = fixed;
        }

        public Object getItem() {
            return this.contents;
        }

        public void setItem(Object contents) {
            this.contents = contents;
        }

        public boolean isFixed() {
            return this.fixed;
        }

        public void setFixed(boolean fixed) {
            this.fixed = fixed;
        }

        public String toString() {
            return this.contents.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof ListItem) {
                return this.toString().equals(o.toString());
            }
            return false;
        }

        public int hashCode() {
            return this.contents.hashCode();
        }
    }
}

