/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.tools.LoggingManager;
import java.lang.ref.SoftReference;
import java.text.DateFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

public class TextPool {
    public static String[] MONTHS;
    public static String[] QUARTERS;
    public static String YEAR;
    public static String[] TIMEFRAMES;
    public static final int COLUMN_TAGS_NUMBER = 0;
    public static final int COLUMN_TAGS_DATE = 1;
    public static final int COLUMN_TAGS_ACCOUNT = 2;
    public static final int COLUMN_TAGS_RECEIPT_ID = 3;
    public static final int COLUMN_TAGS_RECEIPT_DESCRIPTION = 4;
    public static final int COLUMN_TAGS_INCOMING_OUTGOING = 5;
    public static final int COLUMN_TAGS_STATUS = 6;
    public static final int COLUMN_TAGS_AMOUNT_EXCLUDING_TAX = 7;
    public static final int COLUMN_TAGS_AMOUNT_INCLUDING_TAX = 8;
    public static final int COLUMN_TAGS_AMOUNT_TAX = 9;
    public static final int COLUMN_TAGS_TAX_PERCENT = 10;
    public static final int[] INCLUDING_EXCLUDING_TAX_OUTPUTTYPE;
    public static final int[] RECEIPT_SORT_CONSTANTS;
    public static final int SEARCH_OPTION_DATE = 0;
    public static final int SEARCH_OPTION_ACCOUNT = 1;
    public static final int SEARCH_OPTION_ID = 2;
    public static final int SEARCH_OPTION_DESCRIPTION = 3;
    public static final int SEARCH_OPTION_PAID_STATE = 4;
    public static final int SEARCH_OPTION_AMOUNT = 5;
    public static final int SEARCH_OPTION_TAX = 6;
    public static final String SEARCH_LABEL_EQUALS = "ist gleich";
    public static final String SEARCH_LABEL_CONTAINS = "enth\u00e4lt";
    public static final String SEARCH_AND = "UND";
    private static ResourceBundle bundleStrings;
    private static ResourceBundle bundleArrays;
    private static Map<String, SoftReference<String[]>> arrayCache;
    private static final Pattern COMMA;

    static {
        INCLUDING_EXCLUDING_TAX_OUTPUTTYPE = new int[]{1, 2, 4};
        RECEIPT_SORT_CONSTANTS = new int[]{1, 2, 3, 4, 5, 7, 6, 8};
        arrayCache = new HashMap<String, SoftReference<String[]>>();
        COMMA = Pattern.compile(",");
        try {
            bundleStrings = ResourceBundle.getBundle("de.uwemock.eur.resources.jesstrings");
            bundleArrays = ResourceBundle.getBundle("de.uwemock.eur.resources.jesarrays");
        }
        catch (MissingResourceException e) {
            LoggingManager.logException(TextPool.class, e);
            System.out.println("Text resources not found. Exiting.");
            System.exit(0);
        }
        Locale locale = Locale.getDefault();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        MONTHS = dateFormatSymbols.getMonths();
        QUARTERS = TextPool.getArray("QUARTERS");
        YEAR = TextPool.getString("YEAR");
        TIMEFRAMES = new String[12 + QUARTERS.length + 1];
        int j = 0;
        int i = 0;
        while (i < 12) {
            TextPool.TIMEFRAMES[j++] = MONTHS[i++];
        }
        i = 0;
        while (i < QUARTERS.length) {
            TextPool.TIMEFRAMES[j++] = QUARTERS[i++];
        }
        TextPool.TIMEFRAMES[j] = YEAR;
    }

    public static String getString(String id) {
        String result;
        try {
            result = bundleStrings.getString(id);
            if (result != null) {
                return result;
            }
        }
        catch (MissingResourceException e) {
            result = "Resource text \"" + id + "\" is missing";
            System.out.println(result);
        }
        return result;
    }

    public static String[] getArray(String id) {
        String[] result = null;
        SoftReference<String[]> softref = arrayCache.get(id);
        if (softref != null) {
            result = softref.get();
        }
        if (result == null) {
            try {
                String text = bundleArrays.getString(id);
                if (text != null) {
                    result = COMMA.split(text);
                    arrayCache.put(id, new SoftReference<String[]>(result));
                    return result;
                }
            }
            catch (MissingResourceException e) {
                result = new String[]{"Resource array \"" + id + "\" is missing"};
                System.out.println(result[0]);
            }
        }
        return result;
    }
}

