/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import chrriis.dj.swingsuite.JWidePopupComboBox;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.DataProvider;
import de.uwemock.eur.data.Tax;
import de.uwemock.eur.data.TaxList;
import de.uwemock.eur.data.gui.TaxRenderer;
import de.uwemock.eur.gui.TaxListListener;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.actions.ActionImportTaxSettings;
import de.uwemock.guitools.AbstractSimpleAssistantPanel;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.MoveListItemAction;
import de.uwemock.guitools.MutableListModel;
import de.uwemock.guitools.validators.FloatValidator;
import de.uwemock.guitools.validators.ValidatorHook;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TaxListEditor
extends AbstractSimpleAssistantPanel
implements TaxListListener {
    private Frame parent;
    private TaxList taxList;
    private JList taxListDisplay;
    private JButton addButton;
    private JButton removeButton;
    private JWidePopupComboBox taxListSelection;
    private JButton applySelectedTaxListButton;
    private JButton importTaxListButton;
    private boolean isFinished = false;
    private Action okAction = null;

    public TaxListEditor(Frame parent, TaxList taxList) {
        this.parent = parent;
        this.taxList = taxList != null ? (TaxList)taxList.clone() : new TaxList();
        DataCenter.getInstance().addTaxListListener(this);
        this.taxListDisplay = new JList(new MutableListModel(this.taxList));
        this.taxListDisplay.setBorder(BorderFactory.createEtchedBorder());
        this.taxListDisplay.setCellRenderer(new TaxRenderer());
        this.taxListDisplay.setSelectionMode(0);
        this.addButton = new JButton(new AbstractAction(TextPool.getString("buttonAdd")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TaxDialog d = new TaxDialog();
                d.setVisible(true);
                if (d.getTax() != null) {
                    ((MutableListModel)TaxListEditor.this.taxListDisplay.getModel()).addElement(d.getTax());
                    TaxListEditor.this.enableButtons();
                }
            }
        });
        this.removeButton = new JButton(new AbstractAction(TextPool.getString("buttonRemove")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int index = TaxListEditor.this.taxListDisplay.getSelectedIndex();
                if (index >= 0) {
                    ((MutableListModel)TaxListEditor.this.taxListDisplay.getModel()).removeElementAt(index);
                    TaxListEditor.this.enableButtons();
                }
            }
        });
        JButton moveUpButton = new JButton(new MoveListItemAction(this.taxListDisplay, MoveListItemAction.MOVE_UP, TextPool.getString("buttonMoveUp")));
        JButton moveDownButton = new JButton(new MoveListItemAction(this.taxListDisplay, MoveListItemAction.MOVE_DOWN, TextPool.getString("buttonMoveDown")));
        this.taxListDisplay.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TaxListEditor.this.enableButtons();
            }
        });
        JPanel buttonPanel = new JPanel(new GridLayout(4, 1, 5, 5));
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.removeButton);
        buttonPanel.add(moveUpButton);
        buttonPanel.add(moveDownButton);
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add("North", buttonPanel);
        GridBagLayout gbl = new GridBagLayout();
        JPanel topPanel = new JPanel(gbl);
        this.taxListSelection = new JWidePopupComboBox(DataProvider.taxListCollection.toArray());
        this.applySelectedTaxListButton = new JButton(new AbstractAction(TextPool.getString("buttonApply")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TaxList newTaxList = (TaxList)TaxListEditor.this.taxListSelection.getSelectedItem();
                if (newTaxList == null) {
                    return;
                }
                int res = JOptionPane.showConfirmDialog(TaxListEditor.this, TextPool.getString("msgApplyTaxList"), TextPool.getString("titleApplyTaxList"), 0);
                if (res == 0) {
                    TaxListEditor.this.taxList = newTaxList;
                    TaxListEditor.this.taxListDisplay.setModel(new MutableListModel(newTaxList));
                    TaxListEditor.this.enableButtons();
                }
            }
        });
        this.importTaxListButton = new JButton(new ActionImportTaxSettings(this.parent));
        GuiTools.addComponent(topPanel, gbl, this.taxListSelection, 0, 0, 1, 1, 1.0, 1.0);
        GuiTools.addComponent(topPanel, gbl, this.applySelectedTaxListButton, 1, 0, 1, 1, 0.0, 1.0);
        GuiTools.addComponent(topPanel, gbl, this.importTaxListButton, 2, 0, 1, 1, 0.0, 1.0);
        this.setLayout(new BorderLayout(10, 10));
        this.add("Center", new JScrollPane(this.taxListDisplay));
        this.add("East", rightPanel);
        this.add("North", topPanel);
        this.enableButtons();
    }

    private void enableButtons() {
        int sel = this.taxListDisplay.getSelectedIndex();
        this.removeButton.setEnabled(sel >= 0);
        if (this.okAction != null) {
            this.okAction.setEnabled(this.taxListDisplay.getModel().getSize() > 0);
        }
    }

    public ArrayList<Tax> getTaxList() {
        return this.taxList;
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleDataTax");
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void setFinished(boolean finished) {
        this.isFinished = finished;
    }

    @Override
    public void setNextAction(Action okAction) {
        this.okAction = okAction;
    }

    @Override
    public void saveDialogData() {
        DataCenter.getInstance().setTaxList(this.taxList);
        DataCenter.getInstance().setDataChanged();
    }

    @Override
    public String getInformationText() {
        return TextPool.getString("informationTaxList");
    }

    @Override
    public void dispose() {
        DataCenter.getInstance().removeTaxListListener(this);
    }

    @Override
    public void taxListHasChanged(TaxList taxList) {
        this.taxList = taxList != null ? (TaxList)taxList.clone() : new TaxList();
        this.taxListDisplay.setModel(new MutableListModel(this.taxList));
        this.enableButtons();
    }

    class TaxDialog
    extends JDialog {
        private JTextField taxPercent;
        private JTextField taxDescription;
        private Tax tax;

        public TaxDialog() {
            super(TaxListEditor.this.parent, TextPool.getString("titleNewTax"));
            this.taxPercent = new JTextField(40);
            this.taxDescription = new JTextField(40);
            this.tax = null;
            this.setModal(true);
            GridBagLayout gbl = new GridBagLayout();
            JPanel inputPanel = new JPanel(gbl);
            GuiTools.addComponent(inputPanel, gbl, new JLabel(TextPool.getString("labelPercentage")), 0, 0, 1, 1, 1.0, 1.0);
            GuiTools.addComponent(inputPanel, gbl, new JLabel(TextPool.getString("labelDescription")), 0, 1, 1, 1, 1.0, 1.0);
            GuiTools.addComponent(inputPanel, gbl, this.taxPercent, 1, 0, 1, 1, 1.0, 1.0);
            GuiTools.addComponent(inputPanel, gbl, this.taxDescription, 1, 1, 1, 1, 1.0, 1.0);
            new ValidatorHook(this.taxPercent, new FloatValidator(2));
            JPanel buttonPanel = new JPanel(new FlowLayout(1));
            buttonPanel.add(new JButton(new AbstractAction(TextPool.getString("buttonOk")){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TaxDialog.this.tax = new Tax(TaxListEditor.this.taxList, TaxDialog.this.taxDescription.getText(), new BigDecimal(TaxDialog.this.taxPercent.getText()));
                    TaxDialog.this.dispose();
                }
            }));
            buttonPanel.add(new JButton(new AbstractAction(TextPool.getString("buttonCancel")){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TaxDialog.this.dispose();
                }
            }));
            this.setLayout(new BorderLayout());
            this.add("Center", inputPanel);
            this.add("South", buttonPanel);
            this.pack();
            this.setLocationRelativeTo(TaxListEditor.this);
        }

        public Tax getTax() {
            return this.tax;
        }
    }
}

