/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import chrriis.dj.swingsuite.JComboButton;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.ImageComponent;
import de.uwemock.tools.LoggingManager;
import de.uwemock.tools.VersionManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Calendar;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class StartupDialog
extends JDialog
implements ActionListener {
    private JButton buttonStartupNewProject;
    private JButton buttonStartupOpenProject;
    private JComboButton buttonStartupLastOpenFile;
    private JLabel versionLabel;
    private boolean startupNew = false;
    private boolean startupOpen = false;
    private boolean startupLast = false;
    private String startupFileToOpen = SettingsManager.getInstance().getLastOpenFile();

    public StartupDialog(Frame parent) {
        super(parent, TextPool.getString("titleStartup"), true);
        this.setResizable(false);
        int numButtons = 2;
        String lastOpenFile = SettingsManager.getInstance().getLastOpenFile();
        if (lastOpenFile != null) {
            numButtons = 3;
        }
        JPanel buttonPanel = new JPanel(new GridLayout(numButtons + 1, 1, 0, 0));
        this.versionLabel = new JLabel("Version " + VersionManager.getThisProgramVersionString(), 0);
        this.versionLabel.setBackground(Color.WHITE);
        buttonPanel.add(this.versionLabel);
        this.buttonStartupNewProject = new JButton(TextPool.getString("buttonStartupNewProject"));
        this.buttonStartupNewProject.addActionListener(this);
        buttonPanel.add(this.buttonStartupNewProject);
        this.buttonStartupOpenProject = new JButton(TextPool.getString("buttonStartupOpenProject"));
        this.buttonStartupOpenProject.addActionListener(this);
        buttonPanel.add(this.buttonStartupOpenProject);
        if (lastOpenFile != null) {
            this.buttonStartupLastOpenFile = new JComboButton(String.valueOf(TextPool.getString("buttonLastOpenFile")) + " " + GuiTools.shortenPathname(lastOpenFile, 16, 2), true);
            String[] lastFilenames = SettingsManager.getInstance().getLastFilenames();
            JPopupMenu lastFilenamesMenu = new JPopupMenu();
            String[] stringArray = lastFilenames;
            int n = lastFilenames.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                lastFilenamesMenu.add(new OpenFileAction(filename));
                ++n2;
            }
            this.buttonStartupLastOpenFile.setArrowPopupMenu(lastFilenamesMenu);
            this.buttonStartupLastOpenFile.addActionListener(this);
            buttonPanel.add(this.buttonStartupLastOpenFile);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("South", buttonPanel);
        ImageComponent ic = new ImageComponent();
        BufferedImage image = null;
        String imageFilename = "/artwork/eur.png";
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) == 11 && calendar.get(5) <= 26) {
            imageFilename = "/artwork/eur_xmas.png";
        }
        try {
            image = ImageIO.read(this.getClass().getResource(imageFilename));
        }
        catch (IOException e) {
            LoggingManager.logException(this.getClass(), e);
        }
        if (image != null) {
            int newWidth;
            if (this.buttonStartupLastOpenFile != null) {
                newWidth = this.buttonStartupLastOpenFile.getPreferredSize().width;
                if (newWidth < 400) {
                    newWidth = 400;
                }
            } else {
                newWidth = 400;
            }
            int newHeight = image.getHeight() * newWidth / image.getWidth();
            BufferedImage scaledImage = new BufferedImage(newWidth, newHeight, 2);
            Graphics2D graphics2D = scaledImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(image, 0, 0, newWidth, newHeight, null);
            ic.setImage(scaledImage);
        }
        JPanel imagePanel = new JPanel(new FlowLayout(1, 0, 0));
        imagePanel.setBackground(this.getBackground());
        imagePanel.add(ic);
        this.add("Center", imagePanel);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton source = (JButton)e.getSource();
        if (source == this.buttonStartupNewProject) {
            this.startupNew = true;
        }
        if (source == this.buttonStartupOpenProject) {
            this.startupOpen = true;
        }
        if (source == this.buttonStartupLastOpenFile) {
            this.startupLast = true;
        }
        this.dispose();
    }

    public boolean startupNew() {
        return this.startupNew;
    }

    public boolean startupOpen() {
        return this.startupOpen;
    }

    public boolean startupLast() {
        return this.startupLast;
    }

    public String getStartupFilename() {
        return this.startupFileToOpen;
    }

    private class OpenFileAction
    extends AbstractAction {
        private String filename;

        public OpenFileAction(String filename) {
            super(GuiTools.shortenPathname(filename, 48, 4));
            this.filename = filename;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            StartupDialog.this.startupFileToOpen = this.filename;
            StartupDialog.this.startupLast = true;
            StartupDialog.this.dispose();
        }
    }
}

