/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.comparators.ReceiptComparator;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.GuiTools;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SortOptionsPanel
extends AbstractStandardDialogPanel {
    private ReceiptComparator sortComparator;
    private JComboBox sortOptionsList = new JComboBox<String>(TextPool.getArray("RECEIPT_SORT_OPTIONS"));
    private JComboBox sortOrderList = new JComboBox<String>(TextPool.getArray("RECEIPT_SORT_ORDER"));

    public SortOptionsPanel() {
        this.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleSortOptions")));
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GuiTools.addComponent(this, gbl, new JLabel(TextPool.getString("labelSortBy")), 0, 0, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, new JLabel(TextPool.getString("labelSortOrder")), 0, 1, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, this.sortOptionsList, 1, 0, 1, 1, 1.0, 0.0);
        GuiTools.addComponent(this, gbl, this.sortOrderList, 1, 1, 1, 1, 1.0, 0.0);
    }

    @Override
    public void saveDialogData() {
        int sortByIndex = this.sortOptionsList.getSelectedIndex();
        int sortOrderIndex = this.sortOrderList.getSelectedIndex();
        boolean descending = sortOrderIndex == 1;
        this.sortComparator = new ReceiptComparator(TextPool.RECEIPT_SORT_CONSTANTS[sortByIndex], descending);
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleSortOptions");
    }

    public ReceiptComparator getSortComparator() {
        return this.sortComparator;
    }
}

