/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.gui.MainTablePanel;
import de.uwemock.eur.gui.ReceiptGroupTable;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.search.AbstractReceiptSearcher;
import de.uwemock.eur.gui.search.ActionPrintSearchResult;
import de.uwemock.eur.gui.search.SearchInputPanel;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.ReceiptContainer;
import de.uwemock.eur.receipt.ReceiptGroupListener;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.eur.receipt.gui.ReceiptGroupTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;

public class SearchPanel
extends JSplitPane
implements ReceiptGroupListener,
ContainerListener {
    private MainTablePanel mainTablePanel;
    private ReceiptGroupTable table;
    private ReceiptContainer searchResult;
    private SearchInputPanel searchInput;
    private ActionPrintSearchResult actionPrint;

    public SearchPanel(Frame parentFrame, MainTablePanel mainTablePanel) {
        super(0);
        this.mainTablePanel = mainTablePanel;
        this.searchResult = new ReceiptContainer();
        this.table = new ReceiptGroupTable(parentFrame, new ReceiptGroupTableModel(this.searchResult));
        this.setBottomComponent(new JScrollPane(this.table));
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(new JButton(new AbstractAction(TextPool.getString("buttonStartSearch")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.performSearch();
            }
        }));
        this.actionPrint = new ActionPrintSearchResult();
        buttonPanel.add(new JButton(this.actionPrint));
        this.searchInput = new SearchInputPanel();
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add("Center", this.searchInput);
        topPanel.add("South", buttonPanel);
        this.setTopComponent(topPanel);
        this.setOneTouchExpandable(true);
        ReceiptGroupManager.getInstance().getAllReceiptsGroup().addReceiptGroupListener(this);
    }

    private void performSearch() {
        List<AbstractReceiptSearcher> searchers = this.searchInput.getSearch();
        if (searchers.size() == 0) {
            return;
        }
        this.searchResult.removeAll();
        List<AbstractReceipt> allReceipts = ReceiptGroupManager.getInstance().getAllReceiptsGroup().getReceiptList();
        block0: for (AbstractReceipt receipt : allReceipts) {
            for (AbstractReceiptSearcher searcher : searchers) {
                if (!searcher.selectReceipt(receipt)) continue block0;
            }
            this.searchResult.add(receipt);
        }
        this.actionPrint.setSearchText(searchers);
        this.actionPrint.setSearchResult(this.searchResult);
    }

    public JTable getDisplayTable() {
        return this.table;
    }

    @Override
    public void receiptGroupChanged() {
        this.performSearch();
    }

    @Override
    public void componentAdded(ContainerEvent e) {
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        Component c = e.getChild();
        if (this == c) {
            this.mainTablePanel.removeSearchPanel(this);
        }
    }
}

