/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.gui.JesIcons;
import de.uwemock.eur.gui.ReceiptCellRenderer;
import de.uwemock.eur.gui.TooltipCenter;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.gui.ReceiptGroupTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

public class ReceiptStatusCellRenderer
extends ReceiptCellRenderer {
    private JLabel labelAttachment;
    private JLabel labelPaid;
    private JLabel labelDeleted;
    private JLabel labelDepreciation;
    private JPanel panel = new JPanel(new GridLayout(1, 4, 1, 0));

    public ReceiptStatusCellRenderer(ReceiptGroupTableModel tableModel) {
        super(tableModel);
        this.panel.setOpaque(true);
        this.labelPaid = new JLabel();
        this.labelDeleted = new JLabel();
        this.labelAttachment = new JLabel();
        this.labelDepreciation = new JLabel();
        this.labelPaid.setOpaque(false);
        this.labelDeleted.setOpaque(false);
        this.labelAttachment.setOpaque(false);
        this.labelDepreciation.setOpaque(false);
        this.panel.add(this.labelPaid);
        this.panel.add(this.labelDeleted);
        this.panel.add(this.labelAttachment);
        this.panel.add(this.labelDepreciation);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color background;
        if (isSelected) {
            background = table.getSelectionBackground();
        } else {
            Color oldBackground = this.getDefaultRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column).getBackground();
            background = new Color(oldBackground.getRGB());
        }
        if (background != null) {
            this.panel.setBackground(background);
        }
        JPanel outputComponent = this.panel;
        AbstractReceipt r = this.getReceipt(table, row);
        if (r == null) {
            return outputComponent;
        }
        if (r.isDeleted()) {
            this.labelDeleted.setIcon(JesIcons.iconDeleted);
            if (r.isPaid()) {
                this.labelPaid.setIcon(JesIcons.iconPaidDeleted);
            } else {
                this.labelPaid.setIcon(JesIcons.iconNotPaidDeleted);
            }
        } else {
            this.labelDeleted.setIcon(JesIcons.iconEmpty);
            if (r.isPaid()) {
                this.labelPaid.setIcon(JesIcons.iconPaid);
            } else {
                this.labelPaid.setIcon(JesIcons.iconNotPaid);
            }
        }
        if (r.hasDepreciationStrategy()) {
            this.labelDepreciation.setIcon(JesIcons.iconDepreciation);
        } else {
            this.labelDepreciation.setIcon(JesIcons.iconEmpty);
        }
        String tooltip = TooltipCenter.getInstance().getStatusTip(r);
        List<Attachment> attachments = r.getAttachments();
        int size = attachments.size();
        if (size > 0) {
            this.labelAttachment.setIcon(JesIcons.iconAttachment);
        } else {
            this.labelAttachment.setIcon(JesIcons.iconEmpty);
        }
        outputComponent.setToolTipText(tooltip);
        return outputComponent;
    }
}

