/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.data.LocalizationManager;
import de.uwemock.eur.gui.ReceiptCellRenderer;
import de.uwemock.eur.gui.TooltipCenter;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.gui.ReceiptGroupTableModel;
import java.awt.Component;
import java.math.BigDecimal;
import javax.swing.JLabel;
import javax.swing.JTable;

public class ReceiptMoneyCellRenderer
extends ReceiptCellRenderer {
    public ReceiptMoneyCellRenderer(ReceiptGroupTableModel tableModel) {
        super(tableModel);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        AbstractReceipt r = this.getReceipt(table, row);
        if (r != null) {
            label.setToolTipText(TooltipCenter.getInstance().getAmountTip(r));
        }
        return label;
    }

    @Override
    public void setValue(Object value) {
        if (value == null || !(value instanceof BigDecimal)) {
            super.setValue(value);
            this.setHorizontalAlignment(2);
            return;
        }
        this.setText(LocalizationManager.amountToCurrencyString((BigDecimal)value));
        this.setHorizontalAlignment(4);
    }
}

