/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import chrriis.dj.swingsuite.SwingSuiteUtilities;
import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.depreciation.ExtraDepreciation;
import de.uwemock.eur.gui.DateCellRenderer;
import de.uwemock.eur.gui.JesIcons;
import de.uwemock.eur.gui.ReceiptAccountCellRenderer;
import de.uwemock.eur.gui.ReceiptCellRenderer;
import de.uwemock.eur.gui.ReceiptMoneyCellRenderer;
import de.uwemock.eur.gui.ReceiptPercentCellRenderer;
import de.uwemock.eur.gui.ReceiptStatusCellRenderer;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.actions.ActionAddDepreciation;
import de.uwemock.eur.gui.actions.ActionAddToPool;
import de.uwemock.eur.gui.actions.ActionDeleteReceipt;
import de.uwemock.eur.gui.actions.ActionDepreciationAssistant;
import de.uwemock.eur.gui.actions.ActionEditDepreciationStrategy;
import de.uwemock.eur.gui.actions.ActionEditExtraDepreciation;
import de.uwemock.eur.gui.actions.ActionEditReceipt;
import de.uwemock.eur.gui.actions.ActionPartialPayment;
import de.uwemock.eur.gui.actions.ActionPaymentTemplateFromReceipt;
import de.uwemock.eur.gui.actions.ActionReceiptInput;
import de.uwemock.eur.gui.actions.ActionRemoveDepreciationSettings;
import de.uwemock.eur.gui.actions.ActionRemoveExtraDepreciation;
import de.uwemock.eur.gui.actions.ActionRemoveFromPool;
import de.uwemock.eur.gui.actions.ActionRemoveReceipt;
import de.uwemock.eur.gui.actions.ActionToggleReceiptUnpaidState;
import de.uwemock.eur.gui.actions.attachment.AttachmentAdder;
import de.uwemock.eur.gui.actions.attachment.AttachmentMenu;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.OldDepreciationPool;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.eur.receipt.ReceiptNumberManager;
import de.uwemock.eur.receipt.gui.ReceiptGroupTableModel;
import de.uwemock.tools.LoggingManager;
import de.uwemock.tools.Numbers;
import java.awt.Component;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

public class ReceiptGroupTable
extends JTable {
    private HashMap<AbstractReceipt, Collection<String>> dragAndDropBuffer = new HashMap();
    private Frame parentFrame;

    public ReceiptGroupTable(Frame parentFrame, ReceiptGroupTableModel model) {
        super(model);
        this.parentFrame = parentFrame;
        final Frame parent = parentFrame;
        this.setColumnRenderers(model);
        DefaultTableCellRenderer iconHeaderRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header;
                if (table != null && (header = table.getTableHeader()) != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                this.setIcon(JesIcons.iconInfo);
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                this.setHorizontalAlignment(0);
                return this;
            }
        };
        this.getTableHeader().getColumnModel().getColumn(6).setHeaderRenderer(iconHeaderRenderer);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    if (!DataCenter.getInstance().isDataEditable()) {
                        return;
                    }
                    JTable table = (JTable)e.getComponent();
                    int y = table.rowAtPoint(e.getPoint());
                    table.setRowSelectionInterval(y, y);
                    ReceiptGroupTableModel model = (ReceiptGroupTableModel)table.getModel();
                    AbstractReceipt r = model.getItemAt(table.getRowSorter().convertRowIndexToModel(y));
                    if (!PoolManager.getInstance().contains(r) || PoolManager.getInstance().getCurrentDepreciationPool().contains(r)) {
                        ActionEditReceipt a = new ActionEditReceipt(parent, r, ReceiptGroupManager.getInstance());
                        a.actionPerformed(null);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JTable tabelle = (JTable)e.getComponent();
                    int y = tabelle.rowAtPoint(e.getPoint());
                    tabelle.setRowSelectionInterval(y, y);
                    this.showPopupMenu(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JTable tabelle = (JTable)e.getComponent();
                    int y = tabelle.rowAtPoint(e.getPoint());
                    tabelle.setRowSelectionInterval(y, y);
                    this.showPopupMenu(e.getComponent(), e.getX(), e.getY());
                }
            }

            private void showPopupMenu(Component c, int x, int y) {
                boolean depreciationPossible;
                JTable tabelle = (JTable)c;
                int selected = tabelle.getSelectedRow();
                if (selected < 0) {
                    return;
                }
                ReceiptGroupTableModel model = (ReceiptGroupTableModel)tabelle.getModel();
                int realSelected = tabelle.getRowSorter().convertRowIndexToModel(selected);
                AbstractReceipt r = model.getItemAt(realSelected);
                int currentYear = DataCenter.getInstance().getBusinessYear();
                JPopupMenu menu = new JPopupMenu();
                boolean editAllowed = DataCenter.getInstance().isDataEditable();
                if (editAllowed) {
                    if (!PoolManager.getInstance().contains(r) || PoolManager.getInstance().getCurrentDepreciationPool().contains(r)) {
                        if (r.isEditable()) {
                            menu.add(new ActionEditReceipt(parent, r, ReceiptGroupManager.getInstance()));
                            menu.add(new ActionReceiptInput(parent, r, JesIcons.iconEditAsNew, JesIcons.iconEditAsNew));
                        }
                        menu.add(new ActionToggleReceiptUnpaidState(parent, r));
                        if (!r.isPaid()) {
                            menu.add(new ActionPartialPayment(parent, r, ReceiptGroupManager.getInstance()));
                        }
                        menu.add(new ActionDeleteReceipt(r));
                        if (r.getNumber() + 1 == ReceiptNumberManager.getInstance().getNextReceiptNumber()) {
                            menu.add(new ActionRemoveReceipt(parent, DataCenter.getInstance().getFileContext(), r));
                        }
                    } else {
                        menu.add(new ActionToggleReceiptUnpaidState(parent, r));
                    }
                }
                Collection<Integer> receiptAccounts = r.accountNumbersAddedTo();
                int firstAccount = -1;
                if (receiptAccounts.size() > 0) {
                    Iterator<Integer> i = receiptAccounts.iterator();
                    firstAccount = i.next();
                }
                Account account = DataCenter.getInstance().getAccountList().getByAccountNumber(firstAccount);
                boolean bl = depreciationPossible = firstAccount >= 0 && receiptAccounts.size() == 1 && account != null && account.getAccountType() == 1;
                if (depreciationPossible && menu.getComponentCount() > 0) {
                    menu.addSeparator();
                }
                if (editAllowed && !r.hasDepreciationStrategy() && !PoolManager.getInstance().contains(r) && depreciationPossible) {
                    menu.add(new ActionAddToPool(parent, r));
                    menu.add(new ActionAddDepreciation(parent, r, currentYear));
                }
                if (editAllowed && PoolManager.getInstance().getCurrentDepreciationPool().contains(r)) {
                    menu.add(new ActionRemoveFromPool(parent, r));
                }
                if (r.hasDepreciationStrategy()) {
                    menu.add(new ActionEditDepreciationStrategy(parent, r, currentYear, editAllowed));
                    if (!SettingsManager.getInstance().useDepreciationAssistant() && !(r instanceof OldDepreciationPool)) {
                        menu.add(new ActionDepreciationAssistant(parent, r, currentYear, editAllowed));
                    }
                }
                if (editAllowed && r.hasDepreciationStrategy() && !(r instanceof OldDepreciationPool)) {
                    menu.add(new ActionRemoveDepreciationSettings(parent, r, currentYear));
                }
                if (r.hasDepreciationStrategy() && !(r instanceof OldDepreciationPool)) {
                    String title = TextPool.getString("menuPopupAddExtraDepreciation");
                    if (r.getDepreciationStrategy().hasExtraDepreciation()) {
                        title = editAllowed ? TextPool.getString("menuPopupEditExtraDepreciation") : TextPool.getString("menuPopupShowExtraDepreciation");
                    }
                    menu.add(new ActionEditExtraDepreciation(parent, r, currentYear, title, editAllowed));
                    if (editAllowed && r.getDepreciationStrategy().hasExtraDepreciation()) {
                        ExtraDepreciation e = r.getDepreciationStrategy().getExtraDepreciation();
                        int year = r.getDepreciationStrategy().getStartYear();
                        while (year < currentYear) {
                            if (Numbers.isPositive(e.getPercentForYear(year))) break;
                            ++year;
                        }
                        if (year == currentYear) {
                            menu.add(new ActionRemoveExtraDepreciation(parent, r, DataCenter.getInstance().getBusinessYear()));
                        }
                    }
                }
                boolean attachmentsAllowed = SettingsManager.getInstance().attachmentsAllowed();
                if (r.hasAttachments() || attachmentsAllowed && editAllowed) {
                    AttachmentMenu attachmentsMenu = new AttachmentMenu(parent, DataCenter.getInstance().getFileContext(), r, attachmentsAllowed, editAllowed);
                    if (menu.getComponentCount() > 0) {
                        menu.addSeparator();
                    }
                    menu.add(attachmentsMenu);
                }
                if (editAllowed) {
                    menu.addSeparator();
                    menu.add(new ActionPaymentTemplateFromReceipt(parent, r, DataCenter.getInstance().getPaymentTemplateList()));
                }
                menu.show(c, x, y);
            }
        });
        final ReceiptGroupTable autoResizeTable = this;
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SwingSuiteUtilities.autoFitTableColumns(autoResizeTable, Integer.MAX_VALUE);
                if (SettingsManager.getInstance().doAutoScroll()) {
                    final int lastRowChanged = e.getLastRow();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            autoResizeTable.scrollRectToVisible(autoResizeTable.getCellRect(lastRowChanged, 0, true));
                        }
                    });
                }
            }
        });
        TableRowSorter<ReceiptGroupTableModel> tableRowSorter = new TableRowSorter<ReceiptGroupTableModel>();
        tableRowSorter.setModel(model);
        this.setRowSorter(tableRowSorter);
        this.setTransferHandler(new DndHandler());
    }

    private void setColumnRenderer(JTable tabelle, int c, TableCellRenderer r) {
        tabelle.getColumn(tabelle.getModel().getColumnName(c)).setCellRenderer(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAttachmentStack() {
        HashMap<AbstractReceipt, Collection<String>> hashMap = this.dragAndDropBuffer;
        synchronized (hashMap) {
            for (AbstractReceipt r : this.dragAndDropBuffer.keySet()) {
                AttachmentAdder.addAttachments(this.parentFrame, r, this.dragAndDropBuffer.get(r));
            }
            this.dragAndDropBuffer.clear();
        }
    }

    private void setColumnRenderers(ReceiptGroupTableModel tableModel) {
        this.setColumnRenderer(this, 0, new ReceiptCellRenderer(tableModel));
        this.setColumnRenderer(this, 1, new DateCellRenderer(tableModel));
        this.setColumnRenderer(this, 2, new ReceiptAccountCellRenderer(tableModel));
        this.setColumnRenderer(this, 3, new ReceiptCellRenderer(tableModel));
        this.setColumnRenderer(this, 4, new ReceiptCellRenderer(tableModel));
        this.setColumnRenderer(this, 6, new ReceiptStatusCellRenderer(tableModel));
        this.setColumnRenderer(this, 7, new ReceiptMoneyCellRenderer(tableModel));
        this.setColumnRenderer(this, 8, new ReceiptMoneyCellRenderer(tableModel));
        this.setColumnRenderer(this, 9, new ReceiptMoneyCellRenderer(tableModel));
        this.setColumnRenderer(this, 10, new ReceiptPercentCellRenderer(tableModel));
    }

    @Override
    public void updateUI() {
        ReceiptGroupTableModel tableModel = (ReceiptGroupTableModel)this.getModel();
        this.setColumnRenderers(tableModel);
        super.updateUI();
    }

    private class DndHandler
    extends TransferHandler {
        private DndHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!SettingsManager.getInstance().attachmentsAllowed()) {
                return false;
            }
            return support.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        private void addToDNDBuffer(AbstractReceipt r, File f) {
            LinkedList<String> receiptCollection = (LinkedList<String>)ReceiptGroupTable.this.dragAndDropBuffer.get(r);
            if (receiptCollection == null) {
                receiptCollection = new LinkedList<String>();
                ReceiptGroupTable.this.dragAndDropBuffer.put(r, receiptCollection);
            }
            receiptCollection.add(f.getAbsolutePath());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
            int row = dl.getRow();
            ReceiptGroupTableModel model = (ReceiptGroupTableModel)ReceiptGroupTable.this.getModel();
            AbstractReceipt receipt = model.getItemAt(ReceiptGroupTable.this.getRowSorter().convertRowIndexToModel(row));
            Transferable t = support.getTransferable();
            DataFlavor bestTextFlavor = DataFlavor.selectBestTextFlavor(t.getTransferDataFlavors());
            if (bestTextFlavor.getMimeType().startsWith("text/plain") || bestTextFlavor.getMimeType().startsWith("text/html")) {
                Reader reader = null;
                OutputStreamWriter writer = null;
                File tempFile = null;
                try {
                    try {
                        reader = bestTextFlavor.getReaderForText(t);
                        String extension = ".txt";
                        if (bestTextFlavor.getMimeType().startsWith("text/html")) {
                            extension = ".html";
                        }
                        tempFile = File.createTempFile("jes_import_" + ReceiptNumberManager.getInstance().getNextReceiptNumber() + "_", extension);
                        tempFile.deleteOnExit();
                        writer = new FileWriter(tempFile);
                        int c = -1;
                        while ((c = reader.read()) >= 0) {
                            writer.write(c);
                        }
                    }
                    catch (UnsupportedFlavorException e) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e2) {
                                LoggingManager.logException(this.getClass(), e2);
                            }
                        }
                        if (writer == null) return false;
                        try {
                            writer.close();
                            return false;
                        }
                        catch (IOException e3) {
                            LoggingManager.logException(this.getClass(), e3);
                        }
                        return false;
                    }
                    catch (IOException e) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e4) {
                                LoggingManager.logException(this.getClass(), e4);
                            }
                        }
                        if (writer == null) return false;
                        try {
                            writer.close();
                            return false;
                        }
                        catch (IOException e5) {
                            LoggingManager.logException(this.getClass(), e5);
                        }
                        return false;
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            LoggingManager.logException(this.getClass(), e);
                        }
                    }
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            LoggingManager.logException(this.getClass(), e);
                        }
                    }
                }
                HashMap e = ReceiptGroupTable.this.dragAndDropBuffer;
                synchronized (e) {
                    if (tempFile != null) {
                        this.addToDNDBuffer(receipt, tempFile);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ReceiptGroupTable.this.processAttachmentStack();
                            }
                        });
                        return true;
                    }
                }
            }
            if (!bestTextFlavor.getMimeType().startsWith("text/uri-list")) return true;
            try {
                String line;
                BufferedReader buffer = new BufferedReader(bestTextFlavor.getReaderForText(t));
                do {
                    if ((line = buffer.readLine()) == null) continue;
                    try {
                        URI uri = new URI(line);
                        File f = new File(uri);
                        if (!f.exists() || !f.isFile() || !f.canRead()) continue;
                        HashMap hashMap = ReceiptGroupTable.this.dragAndDropBuffer;
                        synchronized (hashMap) {
                            this.addToDNDBuffer(receipt, f);
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                } while (line != null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ReceiptGroupTable.this.processAttachmentStack();
                    }
                });
                return true;
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
    }
}

