/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.gui.ReceiptGroupTable;
import de.uwemock.eur.receipt.ReceiptGroup;
import de.uwemock.eur.receipt.ReceiptGroupListListener;
import de.uwemock.eur.receipt.ReceiptGroupListProvider;
import de.uwemock.eur.receipt.gui.ReceiptGroupTableModel;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ReceiptGroupSelectionPanel
extends JPanel
implements ReceiptGroupListListener {
    private ReceiptGroupListProvider listProvider;
    private List<ReceiptGroup> receiptGroupList;
    private JComboBox groupSelectionList = new JComboBox();
    private ReceiptGroupTable groupDisplayTable;
    private ReceiptGroupTableModel groupTableModel;
    private DefaultComboBoxModel listModel = new DefaultComboBoxModel();
    private JPanel topPanel;

    public ReceiptGroupSelectionPanel(JFrame parent, String title, ReceiptGroupListProvider listProvider) {
        this.listProvider = listProvider;
        this.listProvider.addReceiptGroupListListener(this);
        this.receiptGroupList = listProvider.getReceiptGroupList();
        this.groupSelectionList.setModel(this.listModel);
        this.putGroupList();
        this.setLayout(new BorderLayout());
        this.groupTableModel = new ReceiptGroupTableModel(this.receiptGroupList.get(0));
        this.groupDisplayTable = new ReceiptGroupTable(parent, this.groupTableModel);
        this.add("Center", new JScrollPane(this.groupDisplayTable));
        this.topPanel = new JPanel(new BorderLayout(20, 0));
        this.topPanel.setBorder(BorderFactory.createTitledBorder(title));
        this.topPanel.add(this.groupSelectionList);
        this.add("North", this.topPanel);
        this.groupSelectionList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = ReceiptGroupSelectionPanel.this.groupSelectionList.getSelectedIndex();
                if (selectedIndex >= 0) {
                    ReceiptGroup group = (ReceiptGroup)ReceiptGroupSelectionPanel.this.receiptGroupList.get(selectedIndex);
                    ReceiptGroupSelectionPanel.this.connectTabletoGroupList(group);
                }
            }
        });
    }

    private void putGroupList() {
        this.listModel.removeAllElements();
        for (ReceiptGroup group : this.receiptGroupList) {
            this.listModel.addElement(group);
        }
    }

    private void connectTabletoGroupList(ReceiptGroup group) {
        this.groupTableModel.setReceiptGroup(group);
    }

    public ReceiptGroupTable getDisplayTable() {
        return this.groupDisplayTable;
    }

    @Override
    public void receiptGroupListChanged() {
        int selectedIndex = this.groupSelectionList.getSelectedIndex();
        ReceiptGroup selected = this.receiptGroupList.get(selectedIndex);
        this.receiptGroupList = this.listProvider.getReceiptGroupList();
        this.putGroupList();
        if (this.receiptGroupList.contains(selected)) {
            this.groupSelectionList.setSelectedIndex(this.receiptGroupList.indexOf(selected));
        } else {
            this.groupSelectionList.setSelectedIndex(0);
            this.connectTabletoGroupList(this.receiptGroupList.get(0));
        }
    }

    public ReceiptGroup getSelectedGroup() {
        int selectedIndex = this.groupSelectionList.getSelectedIndex();
        return this.receiptGroupList.get(selectedIndex);
    }

    public void setTopPanelExtraAction(Action action) {
        if (action == null) {
            int numComponents = this.topPanel.getComponentCount();
            int i = 0;
            while (i < numComponents) {
                if (this.topPanel.getComponent(i) != this.groupSelectionList) {
                    this.topPanel.remove(i);
                    break;
                }
                ++i;
            }
        } else {
            this.topPanel.add("East", new JButton(action));
        }
    }
}

