/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.filter.ReceiptFilterChain;
import de.uwemock.eur.receipt.filter.ReceiptFilterDeleted;
import de.uwemock.eur.receipt.filter.ReceiptFilterNotDeleted;
import de.uwemock.eur.receipt.filter.ReceiptFilterPaid;
import de.uwemock.eur.receipt.filter.ReceiptFilterUnpaid;
import de.uwemock.eur.receipt.filter.ReceiptListFilter;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;

public class ReceiptFilterPanel
extends AbstractStandardDialogPanel {
    private ReceiptListFilter receiptFilter;
    private JCheckBox paidReceipts = new JCheckBox(TextPool.getString("labelFilterPaidReceipts"), true);
    private JCheckBox unpaidReceipts = new JCheckBox(TextPool.getString("labelFilterUnpaidReceipts"), true);
    private JCheckBox deletedReceipts = new JCheckBox(TextPool.getString("labelFilterDeletedReceipts"), true);
    private JCheckBox notDeletedReceipts = new JCheckBox(TextPool.getString("labelFilterNotDeletedReceipts"), true);

    public ReceiptFilterPanel() {
        this.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleReceiptFilter")));
        this.setLayout(new GridLayout(4, 1));
        this.add(this.paidReceipts);
        this.add(this.unpaidReceipts);
        this.add(this.deletedReceipts);
        this.add(this.notDeletedReceipts);
    }

    @Override
    public void saveDialogData() {
        ReceiptFilterChain filter = new ReceiptFilterChain();
        if (this.paidReceipts.isSelected()) {
            filter.addToChain(new ReceiptFilterPaid());
        }
        if (this.unpaidReceipts.isSelected()) {
            filter.addToChain(new ReceiptFilterUnpaid());
        }
        if (this.deletedReceipts.isSelected()) {
            filter.addToChain(new ReceiptFilterDeleted());
        }
        if (this.notDeletedReceipts.isSelected()) {
            filter.addToChain(new ReceiptFilterNotDeleted());
        }
        this.receiptFilter = new ReceiptListFilter(filter);
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleReceiptFilter");
    }

    public ReceiptListFilter getReceiptFilter() {
        return this.receiptFilter;
    }
}

