/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import chrriis.dj.swingsuite.SwingSuiteUtilities;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.ThinkingComboBoxModel;
import de.uwemock.eur.gui.ThinkingComboBoxModelAdapterForJTable;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ReceiptDescriptionListEditor
extends AbstractStandardDialogPanel {
    private JTable descriptionListDisplay;
    private ThinkingComboBoxModel descriptionList;
    private JButton addButton;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    private JSpinner numLastReceiptDescriptionsInput = new JSpinner();

    public ReceiptDescriptionListEditor(Window parent, ThinkingComboBoxModel currentDescriptions) {
        this.numLastReceiptDescriptionsInput.setModel(new SpinnerNumberModel(1, 1, 99, 1));
        this.numLastReceiptDescriptionsInput.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                int numLastReceiptDescriptions = (Integer)ReceiptDescriptionListEditor.this.numLastReceiptDescriptionsInput.getModel().getValue();
                ThinkingComboBoxModel model = ReceiptDescriptionListEditor.this.descriptionList;
                while (model.getSize() > numLastReceiptDescriptions) {
                    model.removeElementAt(model.getSize() - 1);
                }
                ((AbstractTableModel)ReceiptDescriptionListEditor.this.descriptionListDisplay.getModel()).fireTableDataChanged();
                ReceiptDescriptionListEditor.this.enableButtons();
                DataCenter.getInstance().setDataChanged();
            }
        });
        JPanel topPanel = new JPanel(new FlowLayout(0));
        topPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleSettingsReceiptDescriptionsNumber")));
        topPanel.add(new JLabel(TextPool.getString("labelSettingsNumReceiptDescriptions")));
        topPanel.add(this.numLastReceiptDescriptionsInput);
        this.descriptionList = currentDescriptions;
        this.descriptionList.sortItems();
        this.descriptionListDisplay = new JTable();
        this.descriptionListDisplay.setSelectionMode(0);
        this.descriptionListDisplay.setModel(new ThinkingComboBoxModelAdapterForJTable(currentDescriptions));
        SwingSuiteUtilities.autoFitTableColumns(this.descriptionListDisplay, Integer.MAX_VALUE);
        this.addButton = new JButton(new AbstractAction(TextPool.getString("buttonAdd")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String newDescriptionText = JOptionPane.showInputDialog(ReceiptDescriptionListEditor.this, (Object)TextPool.getString("labelInputReceiptDescription"));
                if (newDescriptionText != null) {
                    ReceiptDescriptionListEditor.this.descriptionList.addElement(newDescriptionText);
                    AbstractTableModel model = (AbstractTableModel)ReceiptDescriptionListEditor.this.descriptionListDisplay.getModel();
                    model.fireTableRowsInserted(model.getRowCount(), model.getRowCount());
                    ReceiptDescriptionListEditor.this.enableButtons();
                    DataCenter.getInstance().setDataChanged();
                }
            }
        });
        this.removeButton = new JButton(new AbstractAction(TextPool.getString("buttonRemove")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JTable table = ReceiptDescriptionListEditor.this.descriptionListDisplay;
                ThinkingComboBoxModel model = ReceiptDescriptionListEditor.this.descriptionList;
                int sel = table.getSelectedRow();
                if (sel >= 0) {
                    model.removeElementAt(sel);
                    ((AbstractTableModel)table.getModel()).fireTableRowsDeleted(sel, sel);
                    ReceiptDescriptionListEditor.this.enableButtons();
                    DataCenter.getInstance().setDataChanged();
                }
            }
        });
        this.upButton = new JButton(new AbstractAction(TextPool.getString("buttonMoveUp")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JTable table = ReceiptDescriptionListEditor.this.descriptionListDisplay;
                ThinkingComboBoxModel model = ReceiptDescriptionListEditor.this.descriptionList;
                int sel = table.getSelectedRow();
                Object o = model.getElementAt(sel);
                model.removeElementAt(sel);
                model.insertElementAt(o, sel - 1);
                model.sortItems();
                ((AbstractTableModel)table.getModel()).fireTableDataChanged();
                table.getSelectionModel().setSelectionInterval(sel - 1, sel - 1);
                ReceiptDescriptionListEditor.this.enableButtons();
                DataCenter.getInstance().setDataChanged();
            }
        });
        this.downButton = new JButton(new AbstractAction(TextPool.getString("buttonMoveDown")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable table = ReceiptDescriptionListEditor.this.descriptionListDisplay;
                ThinkingComboBoxModel model = ReceiptDescriptionListEditor.this.descriptionList;
                int sel = table.getSelectedRow();
                Object o = model.getElementAt(sel);
                model.removeElementAt(sel);
                model.insertElementAt(o, sel + 1);
                model.sortItems();
                ((AbstractTableModel)table.getModel()).fireTableDataChanged();
                table.getSelectionModel().setSelectionInterval(sel + 1, sel + 1);
                ReceiptDescriptionListEditor.this.enableButtons();
                DataCenter.getInstance().setDataChanged();
            }
        });
        this.descriptionListDisplay.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ReceiptDescriptionListEditor.this.enableButtons();
            }
        });
        this.descriptionListDisplay.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ReceiptDescriptionListEditor.this.enableButtons();
            }
        });
        JPanel buttonPanel = new JPanel(new GridLayout(4, 1, 5, 5));
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.removeButton);
        buttonPanel.add(this.upButton);
        buttonPanel.add(this.downButton);
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add("North", buttonPanel);
        JPanel tablePanel = new JPanel(new BorderLayout(10, 0));
        tablePanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleSettingsReceiptDescriptionsTextAndOrder")));
        tablePanel.add("Center", new JScrollPane(this.descriptionListDisplay));
        tablePanel.add("East", rightPanel);
        this.setLayout(new BorderLayout(10, 10));
        this.add("North", topPanel);
        this.add("Center", tablePanel);
        this.enableButtons();
    }

    private void enableButtons() {
        int sel = this.descriptionListDisplay.getSelectedRow();
        ThinkingComboBoxModel model = this.descriptionList;
        int numLastReceiptDescriptions = (Integer)this.numLastReceiptDescriptionsInput.getModel().getValue();
        this.removeButton.setEnabled(sel >= 0);
        this.upButton.setEnabled(sel > 0 && model.isItemFixed(sel) == model.isItemFixed(sel - 1));
        this.downButton.setEnabled(sel >= 0 && sel < this.descriptionListDisplay.getModel().getRowCount() - 1 && model.isItemFixed(sel) == model.isItemFixed(sel + 1));
        this.addButton.setEnabled(this.descriptionListDisplay.getRowCount() < numLastReceiptDescriptions);
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleDataReceiptDescriptions");
    }

    @Override
    public void saveDialogData() {
        int numLastReceiptDescriptions = (Integer)this.numLastReceiptDescriptionsInput.getModel().getValue();
        if (numLastReceiptDescriptions != DataCenter.getInstance().getMaxLastReceiptDescriptions()) {
            DataCenter.getInstance().setMaxLastReceiptDescriptions(numLastReceiptDescriptions);
            DataCenter.getInstance().setDataChanged();
        }
    }

    @Override
    public void dialogOpens() {
        this.numLastReceiptDescriptionsInput.getModel().setValue(DataCenter.getInstance().getMaxLastReceiptDescriptions());
    }
}

