/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.gui.ReceiptGroupTableModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ReceiptCellRenderer
extends DefaultTableCellRenderer {
    private DefaultTableCellRenderer defaultrenderer = new DefaultTableCellRenderer();
    private ReceiptGroupTableModel tableModel;

    public ReceiptCellRenderer(ReceiptGroupTableModel tableModel) {
        this.tableModel = tableModel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        AbstractReceipt r = this.getReceipt(table, row);
        if (r != null && r.hasDepreciationStrategy()) {
            c.setFont(c.getFont().deriveFont(1));
        }
        Color foreground = this.defaultrenderer.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column).getForeground();
        if (r != null && r.isDeleted()) {
            Color color = foreground = isSelected ? Color.WHITE : Color.LIGHT_GRAY;
        }
        if (r != null && !r.isPaid()) {
            foreground = Color.RED;
        }
        if (r != null && r.isDeleted() && !r.isPaid()) {
            foreground = Color.ORANGE;
        }
        c.setForeground(foreground);
        return c;
    }

    protected final AbstractReceipt getReceipt(JTable table, int row) {
        return this.tableModel.getItemAt(table.getRowSorter().convertRowIndexToModel(row));
    }

    protected TableCellRenderer getDefaultRenderer() {
        return this.defaultrenderer;
    }
}

