/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.datetools.Date;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.PoolDepreciationStrategy;
import de.uwemock.eur.gui.AccountListEditor;
import de.uwemock.eur.gui.CalculationPluginEditor;
import de.uwemock.eur.gui.GeneralDataPanel;
import de.uwemock.eur.gui.ImportOldDataPanel;
import de.uwemock.eur.gui.TaxListEditor;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.DepreciationPool;
import de.uwemock.eur.receipt.OldDepreciationPool;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.eur.receipt.ReceiptNumberManager;
import de.uwemock.guitools.SimpleAssistant;
import de.uwemock.guitools.SimpleAssistantPanel;
import java.awt.Frame;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ProjectAssistant
extends SimpleAssistant {
    private ImportOldDataPanel panelImport;
    private SimpleAssistantPanel panelStammdaten;
    private SimpleAssistantPanel panelTax;
    private SimpleAssistantPanel panelAccounts;
    private SimpleAssistantPanel panelPlugins;

    public ProjectAssistant(Frame parent) {
        super((JFrame)null, TextPool.getString("titleNewProject"), true);
        this.setInformationTitle(TextPool.getString("titleInformation"));
        this.setInformationType("text/html");
        this.setOverviewInformationText(TextPool.getString("informationStartupOverview"));
        this.panelImport = new ImportOldDataPanel();
        this.panelStammdaten = new GeneralDataPanel();
        this.panelTax = new TaxListEditor(parent, DataCenter.getInstance().getTaxList());
        this.panelAccounts = new AccountListEditor(parent, DataCenter.getInstance().getAccountList());
        this.panelPlugins = new CalculationPluginEditor(parent, DataCenter.getInstance().getAccountList(), DataCenter.getInstance().getPluginList());
        this.addAssistantPanel(this.panelImport);
        this.addAssistantPanel(this.panelStammdaten);
        this.addAssistantPanel(this.panelTax);
        this.addAssistantPanel(this.panelAccounts);
        this.addAssistantPanel(this.panelPlugins);
    }

    @Override
    public void saveDialogData() {
        this.panelStammdaten.saveDialogData();
        this.panelTax.saveDialogData();
        this.panelAccounts.saveDialogData();
        this.panelPlugins.saveDialogData();
        int currentBusinessYear = DataCenter.getInstance().getBusinessYear();
        Date firstDayOfYear = Date.getDate(currentBusinessYear, 1, 1);
        List<AbstractReceipt> receipts = this.panelImport.getDepreciationReceiptList();
        if (receipts != null) {
            int countNonPoolReceiptsAccepted = 0;
            int countPoolsAccepted = 0;
            int countReceiptsExpired = 0;
            for (AbstractReceipt r : receipts) {
                if (r.isDeleted() || !r.hasDepreciationStrategy()) continue;
                if (r.getDepreciationStrategy().isDepreciatedInYear(currentBusinessYear)) {
                    if (r instanceof OldDepreciationPool) {
                        ++countPoolsAccepted;
                        int year = r.getDate().getYear();
                        DepreciationPool pool = PoolManager.getInstance().getDepreciationPoolForYear(year);
                        DepreciationStrategy ds = r.getDepreciationStrategy();
                        if (!(ds instanceof PoolDepreciationStrategy)) {
                            ds = new PoolDepreciationStrategy(ds.getStartYear(), ds.getNumYears() + 1, pool);
                        }
                        pool.setDepreciationStrategy(ds);
                        for (AbstractReceipt containedReceipt : ((OldDepreciationPool)r).getReceiptList()) {
                            int newReceiptNumber = ReceiptNumberManager.getInstance().getNextReceiptNumber();
                            containedReceipt.setNumber(newReceiptNumber);
                            PoolManager.getInstance().add(containedReceipt);
                        }
                        continue;
                    }
                    ++countNonPoolReceiptsAccepted;
                    r.setNumber(ReceiptNumberManager.getInstance().getNextReceiptNumber());
                    r.setDate(firstDayOfYear);
                    ReceiptGroupManager.getInstance().add(r);
                    continue;
                }
                ++countReceiptsExpired;
            }
            List<DepreciationPool> pools = this.panelImport.getPoolsList();
            if (pools != null) {
                for (DepreciationPool pool : pools) {
                    DepreciationStrategy ds = pool.getDepreciationStrategy();
                    if (ds.isDepreciatedInYear(currentBusinessYear)) {
                        int startYear = ds.getStartYear();
                        DepreciationPool newPool = PoolManager.getInstance().getDepreciationPoolForYear(startYear);
                        for (AbstractReceipt r : pool.getReceiptList()) {
                            r.setNumber(ReceiptNumberManager.getInstance().getNextReceiptNumber());
                            newPool.add(r);
                        }
                        ++countPoolsAccepted;
                        continue;
                    }
                    ++countReceiptsExpired;
                }
            }
            if (countNonPoolReceiptsAccepted > 0 || countPoolsAccepted > 0 || countReceiptsExpired > 0) {
                String message = String.format(TextPool.getString("msgImportDone"), countNonPoolReceiptsAccepted, countPoolsAccepted, countReceiptsExpired);
                JOptionPane.showMessageDialog(this, message);
            }
        }
        if ((receipts = this.panelImport.getUnpaidReceiptList()) != null) {
            int countUnpaidReceiptsAccepted = 0;
            for (AbstractReceipt r : receipts) {
                if (r.isDeleted() || r.hasDepreciationStrategy() || r.isPaid()) continue;
                ++countUnpaidReceiptsAccepted;
                r.setNumber(ReceiptNumberManager.getInstance().getNextReceiptNumber());
                r.setDate(firstDayOfYear);
                ReceiptGroupManager.getInstance().add(r);
            }
            if (countUnpaidReceiptsAccepted > 0) {
                String message = countUnpaidReceiptsAccepted == 1 ? TextPool.getString("msgImportSingleUnpaidDone") : String.format(TextPool.getString("msgImportUnpaidDone"), countUnpaidReceiptsAccepted);
                JOptionPane.showMessageDialog(this, message);
            }
        }
    }
}

