/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.accounts.gui.AccountComboBox;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.gui.TaxComboBox;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.PaymentTemplate;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.validators.FloatValidator;
import de.uwemock.guitools.validators.ValidatorHook;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PaymentTemplateSettingsPanel
extends AbstractStandardDialogPanel {
    private JCheckBox setAccount = new JCheckBox();
    private JCheckBox setAmount = new JCheckBox();
    private JCheckBox setTax = new JCheckBox();
    private JCheckBox setInclExclTax = new JCheckBox();
    private JTextField inputDescription;
    private AccountComboBox inputAccount;
    private JTextField inputAmount;
    private TaxComboBox inputTax;
    private JComboBox inputInclExclTax;
    private JButton okButton;

    public PaymentTemplateSettingsPanel() {
        this.createComponentTree();
    }

    public PaymentTemplateSettingsPanel(JButton okButton) {
        this();
        this.okButton = okButton;
    }

    private void createComponentTree() {
        this.inputDescription = new JTextField();
        this.inputDescription.getDocument().addDocumentListener(new DocumentListener(){

            private void setOkButton() {
                boolean enabled;
                boolean bl = enabled = !PaymentTemplateSettingsPanel.this.inputDescription.getText().trim().isEmpty();
                if (PaymentTemplateSettingsPanel.this.okButton != null) {
                    PaymentTemplateSettingsPanel.this.okButton.setEnabled(enabled);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                this.setOkButton();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                this.setOkButton();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                this.setOkButton();
            }
        });
        this.inputAmount = new JTextField();
        new ValidatorHook(this.inputAmount, new FloatValidator(3, 2));
        this.inputAmount.getDocument().addDocumentListener(new DocumentListener(){

            private void setCheckboxState() {
                boolean checked = !PaymentTemplateSettingsPanel.this.inputAmount.getText().isEmpty();
                PaymentTemplateSettingsPanel.this.setAmount.setSelected(checked);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.setCheckboxState();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.setCheckboxState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.setCheckboxState();
            }
        });
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GuiTools.addComponent(this, gbl, new JLabel(TextPool.getString("labelName")), 1, 0, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, this.inputDescription, 2, 0, 1, 1, 1.0, 0.0);
        this.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titlePaymentTemplateSettings")));
        GuiTools.addComponent(this, gbl, this.setAccount, 0, 1, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, this.setAmount, 0, 2, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, this.setTax, 0, 3, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, this.setInclExclTax, 0, 4, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, new JLabel(TextPool.getString("labelTemplateSetAccount")), 1, 1, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, new JLabel(TextPool.getString("labelTemplateSetAmount")), 1, 2, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, new JLabel(TextPool.getString("labelTemplateSetTax")), 1, 3, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, new JLabel(TextPool.getString("labelTemplateSetInclExclTax")), 1, 4, 1, 1, 0.0, 0.0);
        this.inputAccount = new AccountComboBox(DataCenter.getInstance().getAccountList());
        this.inputAccount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaymentTemplateSettingsPanel.this.setAccount.setSelected(true);
            }
        });
        this.inputTax = new TaxComboBox(DataCenter.getInstance().getTaxList());
        this.inputTax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaymentTemplateSettingsPanel.this.setTax.setSelected(true);
            }
        });
        this.inputInclExclTax = new JComboBox<String>(TextPool.getArray("INCLUDING_EXCLUDING_TAX"));
        this.inputInclExclTax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaymentTemplateSettingsPanel.this.setInclExclTax.setSelected(true);
            }
        });
        GuiTools.addComponent(this, gbl, this.inputAccount, 2, 1, 1, 1, 1.0, 0.0);
        GuiTools.addComponent(this, gbl, this.inputAmount, 2, 2, 1, 1, 1.0, 0.0);
        GuiTools.addComponent(this, gbl, this.inputTax, 2, 3, 1, 1, 1.0, 0.0);
        GuiTools.addComponent(this, gbl, this.inputInclExclTax, 2, 4, 1, 1, 1.0, 0.0);
    }

    public void setTemplate(PaymentTemplate template) {
        if (template == null) {
            throw new RuntimeException("Null reference to PaymentTemplate in " + this.getClass().getName() + ".setTemplate()");
        }
        this.inputDescription.setText(template.getDescription());
        this.setAccount.setSelected(template.getAccountNumber() != null);
        this.setAmount.setSelected(template.getAmount() != null);
        this.setTax.setSelected(template.getTaxID() != null);
        this.setInclExclTax.setSelected(template.getIncludingExcludingTax() != null);
        if (template.getAccountNumber() != null) {
            this.inputAccount.setSelectedAccount(template.getAccountNumber());
        }
        if (template.getAmount() != null) {
            this.inputAmount.setText(template.getAmount().toPlainString());
        } else {
            this.inputAmount.setText("");
        }
        if (template.getTaxID() != null) {
            this.inputTax.setSelectedTax(template.getTaxID());
        }
        if (template.getIncludingExcludingTax() != null) {
            this.inputInclExclTax.setSelectedIndex(template.getIncludingExcludingTax());
        }
    }

    public void setPanelEnabled(boolean enabled) {
        this.setAccount.setEnabled(enabled);
        this.setAmount.setEnabled(enabled);
        this.setTax.setEnabled(enabled);
        this.setInclExclTax.setEnabled(enabled);
        this.inputDescription.setEnabled(enabled);
        this.inputAccount.setEnabled(enabled);
        this.inputAmount.setEnabled(enabled);
        this.inputTax.setEnabled(enabled);
        this.inputInclExclTax.setEnabled(enabled);
    }

    public void saveToTemplate(PaymentTemplate template) {
        if (template == null) {
            throw new RuntimeException("Null reference to PaymentTemplate in " + this.getClass().getName() + ".saveToTemplate()");
        }
        String description = this.inputDescription.getText().trim();
        if (!description.isEmpty()) {
            template.setDescription(description);
        }
        if (this.setAccount.isSelected()) {
            template.setAccountNumber(this.inputAccount.getSelectedAccountNumber());
        } else {
            template.setAccountNumber(null);
        }
        if (this.setAmount.isSelected()) {
            template.setAmount(new BigDecimal(this.inputAmount.getText()));
        } else {
            template.setAmount(null);
        }
        if (this.setTax.isSelected()) {
            template.setTaxID(this.inputTax.getSelectedTax().getID());
        } else {
            template.setTaxID(null);
        }
        if (this.setInclExclTax.isSelected()) {
            template.setIncludingExcludingTax(this.inputInclExclTax.getSelectedIndex());
        } else {
            template.setIncludingExcludingTax(null);
        }
    }
}

