/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.gui.PaymentTemplateSettingsPanel;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.actions.ActionImportPaymentTemplates;
import de.uwemock.eur.receipt.PaymentTemplate;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.MoveListItemAction;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PaymentTemplateEditorPanel
extends AbstractStandardDialogPanel {
    private Frame parent;
    private Action okAction;
    private MutableComboBoxModel templateList;
    private JList templateSelector;
    private JPanel bottomPanel;
    private JPanel bottomEditButtonPanel;
    private JPanel bottomSaveCancelButtonPanel;
    private PaymentTemplateSettingsPanel templateSettingsPanel;
    private JButton buttonNewTemplate;
    private JButton buttonDeleteTemplate;
    private JButton buttonImportTemplates;
    private JButton buttonEditTemplate;
    private JButton buttonSaveTemplate;
    private JButton buttonCancelEdit;
    private boolean listChanged = false;

    public PaymentTemplateEditorPanel(Frame parent, MutableComboBoxModel templateList) {
        this.parent = parent;
        this.templateList = templateList;
        this.createComponentTree();
    }

    private void createComponentTree() {
        this.templateSelector = new JList(this.templateList);
        this.templateSelector.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                PaymentTemplate template = (PaymentTemplate)PaymentTemplateEditorPanel.this.templateSelector.getSelectedValue();
                if (template != null) {
                    PaymentTemplateEditorPanel.this.showTemplateSettings(template);
                }
                PaymentTemplateEditorPanel.this.setButtonsEnabled();
            }
        });
        JPanel topButtonPanel = new JPanel(new GridLayout(5, 1, 8, 8));
        this.buttonNewTemplate = new JButton(TextPool.getString("buttonNew"));
        this.buttonNewTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaymentTemplateEditorPanel.this.newTemplate();
            }
        });
        topButtonPanel.add(this.buttonNewTemplate);
        this.buttonDeleteTemplate = new JButton(TextPool.getString("buttonRemove"));
        this.buttonDeleteTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaymentTemplateEditorPanel.this.deleteTemplate();
            }
        });
        topButtonPanel.add(this.buttonDeleteTemplate);
        topButtonPanel.add(new JButton(new MoveListItemAction(this.templateSelector, MoveListItemAction.MOVE_UP, TextPool.getString("buttonMoveUp"))));
        topButtonPanel.add(new JButton(new MoveListItemAction(this.templateSelector, MoveListItemAction.MOVE_DOWN, TextPool.getString("buttonMoveDown"))));
        this.buttonImportTemplates = new JButton(new ActionImportPaymentTemplates(this.parent));
        this.buttonImportTemplates.setText(TextPool.getString("buttonImport"));
        topButtonPanel.add(this.buttonImportTemplates);
        JPanel topPanel = new JPanel(new BorderLayout(10, 0));
        topPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titlePaymentTemplates")));
        topPanel.add("Center", new JScrollPane(this.templateSelector));
        topPanel.add("East", topButtonPanel);
        this.bottomEditButtonPanel = new JPanel(new BorderLayout());
        this.buttonEditTemplate = new JButton(TextPool.getString("buttonEdit"));
        this.buttonEditTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaymentTemplateEditorPanel.this.editTemplate();
            }
        });
        this.bottomEditButtonPanel.add(this.buttonEditTemplate);
        this.bottomSaveCancelButtonPanel = new JPanel(new GridLayout(1, 2));
        this.buttonSaveTemplate = new JButton(TextPool.getString("buttonOk"));
        this.buttonSaveTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaymentTemplateEditorPanel.this.saveTemplate();
            }
        });
        this.bottomSaveCancelButtonPanel.add(this.buttonSaveTemplate);
        this.buttonCancelEdit = new JButton(TextPool.getString("buttonCancel"));
        this.buttonCancelEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaymentTemplateEditorPanel.this.cancelEdit();
            }
        });
        this.bottomSaveCancelButtonPanel.add(this.buttonCancelEdit);
        this.templateSettingsPanel = new PaymentTemplateSettingsPanel(this.buttonSaveTemplate);
        this.bottomPanel = new JPanel(new BorderLayout());
        this.bottomPanel.add("Center", this.templateSettingsPanel);
        this.bottomPanel.add("South", this.bottomEditButtonPanel);
        this.setLayout(new BorderLayout());
        this.add("Center", topPanel);
        this.add("South", this.bottomPanel);
        this.setTopPanelEnabled(true);
        this.setBottomPanelEnabled(false);
        this.setButtonsEnabled();
    }

    private void newTemplate() {
        String newTemplateDescription = JOptionPane.showInputDialog(this, (Object)TextPool.getString("titleNewPaymentTemplate"));
        if (newTemplateDescription == null || newTemplateDescription.trim().isEmpty()) {
            return;
        }
        PaymentTemplate newTemplate = new PaymentTemplate(newTemplateDescription.trim());
        if (newTemplate != null) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.templateSelector.getModel();
            model.addElement(newTemplate);
            this.templateSelector.setSelectedValue(newTemplate, true);
            this.setButtonsEnabled();
            this.listChanged = true;
        }
    }

    private void deleteTemplate() {
        int index = this.templateSelector.getSelectedIndex();
        if (index >= 0) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.templateSelector.getModel();
            model.removeElementAt(index);
            this.setButtonsEnabled();
        }
    }

    private void editTemplate() {
        this.setTopPanelEnabled(false);
        this.setBottomPanelEnabled(true);
        this.bottomPanel.remove(this.bottomEditButtonPanel);
        this.bottomPanel.add("South", this.bottomSaveCancelButtonPanel);
        this.revalidate();
        this.repaint();
        this.okAction.setEnabled(false);
    }

    private void saveTemplate() {
        PaymentTemplate template = (PaymentTemplate)this.templateSelector.getSelectedValue();
        this.templateSettingsPanel.saveToTemplate(template);
        this.listChanged = true;
        this.setTopPanelEnabled(true);
        this.setBottomPanelEnabled(false);
        this.bottomPanel.remove(this.bottomSaveCancelButtonPanel);
        this.bottomPanel.add("South", this.bottomEditButtonPanel);
        this.revalidate();
        this.repaint();
        this.okAction.setEnabled(true);
        this.showTemplateSettings((PaymentTemplate)this.templateSelector.getSelectedValue());
    }

    private void cancelEdit() {
        this.setTopPanelEnabled(true);
        this.setBottomPanelEnabled(false);
        this.bottomPanel.remove(this.bottomSaveCancelButtonPanel);
        this.bottomPanel.add("South", this.bottomEditButtonPanel);
        this.revalidate();
        this.repaint();
        this.okAction.setEnabled(true);
        this.showTemplateSettings((PaymentTemplate)this.templateSelector.getSelectedValue());
    }

    private void showTemplateSettings(PaymentTemplate template) {
        this.templateSettingsPanel.setTemplate(template);
    }

    private void setButtonsEnabled() {
        boolean listEnabled = this.templateSelector.isEnabled();
        int index = this.templateSelector.getSelectedIndex();
        this.buttonNewTemplate.setEnabled(listEnabled);
        this.buttonDeleteTemplate.setEnabled(listEnabled && index >= 0);
        this.buttonEditTemplate.setEnabled(listEnabled && index >= 0);
    }

    private void setTopPanelEnabled(boolean enabled) {
        this.templateSelector.setEnabled(enabled);
        this.setButtonsEnabled();
    }

    private void setBottomPanelEnabled(boolean enabled) {
        this.templateSettingsPanel.setPanelEnabled(enabled);
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleEditPaymentTemplates");
    }

    @Override
    public void setOkAction(Action okAction) {
        this.okAction = okAction;
    }

    public boolean listChanged() {
        return this.listChanged;
    }
}

