/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.datetools.Date;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import java.math.BigDecimal;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public abstract class MainWindowTableModel
extends AbstractTableModel {
    private static ImageIcon iconMoneyIn = new ImageIcon(MainWindowTableModel.class.getResource("/icons/money_in.png"));
    private static ImageIcon iconMoneyOut = new ImageIcon(MainWindowTableModel.class.getResource("/icons/money_out.png"));
    private static final String[] COLUMNS_MAIN = TextPool.getArray("COLUMNS_MAIN");

    @Override
    public int getColumnCount() {
        return COLUMNS_MAIN.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AbstractReceipt r = this.getItemAt(rowIndex);
        Object res = null;
        switch (columnIndex) {
            case 0: {
                res = r.getReceiptInfo(1);
                break;
            }
            case 1: {
                res = r.getReceiptInfo(2);
                break;
            }
            case 2: {
                res = r.getReceiptInfo(4);
                break;
            }
            case 3: {
                res = r.getReceiptInfo(3);
                break;
            }
            case 4: {
                res = r.getReceiptInfo(13);
                break;
            }
            case 5: {
                if (r.isOutgoingReceipt()) {
                    return iconMoneyOut;
                }
                if (r.isIncomingReceipt()) {
                    return iconMoneyIn;
                }
                return "";
            }
            case 7: {
                res = r.getReceiptInfo(6);
                break;
            }
            case 8: {
                res = r.getReceiptInfo(5);
                break;
            }
            case 9: {
                res = r.getReceiptInfo(7);
                break;
            }
            case 10: {
                res = r.getReceiptInfo(11);
                break;
            }
            default: {
                res = "";
            }
        }
        return res;
    }

    public abstract AbstractReceipt getItemAt(int var1);

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNS_MAIN[columnIndex];
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Date.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return ImageIcon.class;
            }
            case 6: {
                return BigDecimal.class;
            }
            case 7: {
                return BigDecimal.class;
            }
            case 8: {
                return BigDecimal.class;
            }
        }
        return super.getColumnClass(c);
    }
}

