/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.calculation.plugins.AbstractEurPlugin;
import de.uwemock.eur.calculation.plugins.EurPlugin;
import de.uwemock.eur.calculation.plugins.PluginsListListener;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.DirectoryManager;
import de.uwemock.eur.data.FilenameExtensions;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.gui.GeneralDataListener;
import de.uwemock.eur.gui.InfoPanel;
import de.uwemock.eur.gui.JesFileChooser;
import de.uwemock.eur.gui.MainTablePanel;
import de.uwemock.eur.gui.ProjectAssistant;
import de.uwemock.eur.gui.StartupDialog;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.actions.ActionAbout;
import de.uwemock.eur.gui.actions.ActionAddSearchPanel;
import de.uwemock.eur.gui.actions.ActionCalcAccountSums;
import de.uwemock.eur.gui.actions.ActionCalcTax;
import de.uwemock.eur.gui.actions.ActionDepreciationList;
import de.uwemock.eur.gui.actions.ActionDialogEditAccounts;
import de.uwemock.eur.gui.actions.ActionDialogEditPaymentTemplates;
import de.uwemock.eur.gui.actions.ActionDialogEditReceiptDescriptions;
import de.uwemock.eur.gui.actions.ActionDialogGeneralData;
import de.uwemock.eur.gui.actions.ActionDialogPlugins;
import de.uwemock.eur.gui.actions.ActionDialogTax;
import de.uwemock.eur.gui.actions.ActionEditDepreciationRules;
import de.uwemock.eur.gui.actions.ActionExit;
import de.uwemock.eur.gui.actions.ActionExportAccounts;
import de.uwemock.eur.gui.actions.ActionExportPaymentTemplates;
import de.uwemock.eur.gui.actions.ActionExportPlugins;
import de.uwemock.eur.gui.actions.ActionExportTaxes;
import de.uwemock.eur.gui.actions.ActionImportDepreciationReceipts;
import de.uwemock.eur.gui.actions.ActionImportPaymentTemplates;
import de.uwemock.eur.gui.actions.ActionOpenFile;
import de.uwemock.eur.gui.actions.ActionPoolList;
import de.uwemock.eur.gui.actions.ActionProcessHtmlKernel;
import de.uwemock.eur.gui.actions.ActionProcessPlugin;
import de.uwemock.eur.gui.actions.ActionProgramSettings;
import de.uwemock.eur.gui.actions.ActionReceiptInput;
import de.uwemock.eur.gui.actions.ActionReceiptList;
import de.uwemock.eur.gui.actions.ActionSave;
import de.uwemock.eur.gui.actions.ActionSaveAs;
import de.uwemock.eur.gui.undo.JesUndoManager;
import de.uwemock.eur.gui.undo.RedoAction;
import de.uwemock.eur.gui.undo.UndoAction;
import de.uwemock.eur.kernels.KernelMonthlySummary;
import de.uwemock.eur.kernels.KernelReadEuxFile;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.guitools.CurrentFileListener;
import de.uwemock.guitools.EnhancedJToolBar;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.LastFilesListener;
import de.uwemock.guitools.LookAndFeelMenu;
import de.uwemock.guitools.ProgressBarForRunnable;
import de.uwemock.guitools.RunnableResultReceiver;
import de.uwemock.kernel.ProgressBarAdapterForKernel;
import de.uwemock.tools.CommandLineArguments;
import de.uwemock.tools.LoggingManager;
import de.uwemock.tools.Numbers;
import de.uwemock.tools.VersionManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.xml.stream.XMLStreamException;
import org.simplericity.macify.eawt.ApplicationEvent;
import org.simplericity.macify.eawt.ApplicationListener;
import org.simplericity.macify.eawt.DefaultApplication;

public class MainWindow
extends JFrame
implements CurrentFileListener,
LastFilesListener,
PluginsListListener,
GeneralDataListener,
ApplicationListener {
    private final ImageIcon jesIcon = new ImageIcon(MainWindow.class.getResource("/icons/jes.png"));
    private JMenu lastFilesMenu = new JMenu(TextPool.getString("menuLastFiles"));
    private JMenu calculationMenu = new JMenu(TextPool.getString("menuCalc"));
    private JMenuItem editableMenuItem;
    private Action actionOpen = new ActionOpenFile(this, "/icons/open.png", "/icons/large/open.png");
    private Action actionSave = new ActionSave(this, "/icons/save.png", "/icons/large/save.png");
    private Action actionSaveAs = new ActionSaveAs(this);
    private Action actionImportDepreciationReceipts = new ActionImportDepreciationReceipts(this);
    private Action actionImportPaymentTemplates = new ActionImportPaymentTemplates(this);
    private Action actionExportAccounts = new ActionExportAccounts(this);
    private Action actionExportTaxes = new ActionExportTaxes(this);
    private Action actionExportPlugins = new ActionExportPlugins(this);
    private Action actionExportPaymentTemplates = new ActionExportPaymentTemplates(this);
    private Action actionExit = new ActionExit(this);
    private Action actionReceiptInput = new ActionReceiptInput(this, "/icons/input.png", "/icons/large/input.png");
    private Action actionCalcTax = new ActionCalcTax(this, "/icons/tax.png", "/icons/large/tax.png");
    private Action actionCalcAccountSums = new ActionCalcAccountSums(this, "/icons/accountsums.png", "/icons/large/accountsums.png");
    private Action actionReceiptList = new ActionReceiptList(this, "/icons/receiptslist.png", "/icons/large/receiptslist.png");
    private Action actionMonthlySummaryIncludingTax = new ActionProcessHtmlKernel(TextPool.getString("menuMonthlySummaryIncludingTax"), "/icons/month.png", "/icons/large/month.png", new KernelMonthlySummary(ReceiptGroupManager.getInstance(), DataCenter.getInstance(), true));
    private Action actionMonthlySummaryExcludingTax = new ActionProcessHtmlKernel(TextPool.getString("menuMonthlySummaryExcludingTax"), "/icons/month.png", "/icons/large/month.png", new KernelMonthlySummary(ReceiptGroupManager.getInstance(), DataCenter.getInstance(), false));
    private Action actionDepreciationList = new ActionDepreciationList(this, "/icons/depreciation.png", "/icons/large/depreciation.png");
    private Action actionPoolList = new ActionPoolList(this, "/icons/dep_pools.png", "/icons/large/dep_pools.png");
    private ActionProgramSettings actionProgramSettings = new ActionProgramSettings(this);
    private Action actionSettingsGeneralData = new ActionDialogGeneralData(this);
    private Action actionSettingsReceiptDescriptions = new ActionDialogEditReceiptDescriptions(this);
    private Action actionSettingsReceiptTemplates = new ActionDialogEditPaymentTemplates(this);
    private Action actionSettingsTax = new ActionDialogTax(this);
    private Action actionSettingsAccounts = new ActionDialogEditAccounts(this);
    private Action actionSettingsPlugins = new ActionDialogPlugins(this);
    private Action actionAbout = new ActionAbout(this);
    private Action actionUndo = new UndoAction();
    private Action actionRedo = new RedoAction();
    private Action actionAddSearchPanel = new ActionAddSearchPanel(this);
    private EnhancedJToolBar toolbar = new EnhancedJToolBar();
    private JToolBar toolbarOnlyInfo;
    private InfoPanel infoPanel = new InfoPanel();
    private AbstractEurPlugin firstPlugin;
    private MainTablePanel mainTablePanel;

    public MainWindow() {
        super(TextPool.getString("titleMainWindow"));
        Calendar today;
        String currentStartupFileLocation;
        String currentAssociationCommand;
        this.setIconImage(this.jesIcon.getImage());
        this.setDefaultCloseOperation(0);
        SettingsManager settingsManager = SettingsManager.getInstance();
        settingsManager.addLastFilesChangedListener(this);
        settingsManager.addCurrentFileListener(this);
        DataCenter dataCenter = DataCenter.getInstance();
        dataCenter.addPluginsListListener(this);
        dataCenter.addGeneralDataListener(this);
        DefaultApplication application = new DefaultApplication();
        application.addApplicationListener(this);
        JMenu menuImport = new JMenu(TextPool.getString("menuImport"));
        menuImport.add(this.actionImportDepreciationReceipts);
        menuImport.add(this.actionImportPaymentTemplates);
        JMenu menuExport = new JMenu(TextPool.getString("menuExport"));
        menuExport.add(this.actionExportAccounts);
        menuExport.add(this.actionExportTaxes);
        menuExport.add(this.actionExportPlugins);
        menuExport.add(this.actionExportPaymentTemplates);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu(TextPool.getString("menuFile"));
        menu.add(this.actionOpen);
        menu.add(this.actionSave);
        menu.add(this.actionSaveAs);
        menu.addSeparator();
        menu.add(menuImport);
        menu.add(menuExport);
        menu.addSeparator();
        menu.add(this.lastFilesMenu);
        menu.add(new JSeparator());
        menu.add(this.actionExit);
        menuBar.add(menu);
        menu = new JMenu(TextPool.getString("menuEdit"));
        menu.add(this.actionUndo);
        menu.add(this.actionRedo);
        menu.addSeparator();
        this.editableMenuItem = new JCheckBoxMenuItem(new AbstractAction(TextPool.getString("menuSetDataLocked")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataCenter dc;
                dc.setDataEditable(!(dc = DataCenter.getInstance()).isDataEditable());
            }
        });
        menu.add(this.editableMenuItem);
        menuBar.add(menu);
        menu = new JMenu(TextPool.getString("menuView"));
        JCheckBoxMenuItem viewYearTableMenuItem = new JCheckBoxMenuItem(TextPool.getString("menuShowYearTable"));
        viewYearTableMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean showTable = SettingsManager.getInstance().doUseYearTable();
                if (showTable) {
                    MainWindow.this.mainTablePanel.removeYearTable();
                } else {
                    MainWindow.this.mainTablePanel.addYearTable();
                }
                SettingsManager.getInstance().setUseYearTable(!showTable);
                ((JCheckBoxMenuItem)e.getSource()).setSelected(!showTable);
            }
        });
        menu.add(viewYearTableMenuItem);
        JCheckBoxMenuItem viewPoolsTableMenuItem = new JCheckBoxMenuItem(TextPool.getString("menuShowPoolsTable"));
        viewPoolsTableMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean showTable = SettingsManager.getInstance().doUsePoolsTable();
                if (showTable) {
                    MainWindow.this.mainTablePanel.removePoolsTable();
                } else {
                    MainWindow.this.mainTablePanel.addPoolsTable();
                }
                SettingsManager.getInstance().setUsePoolsTable(!showTable);
                ((JCheckBoxMenuItem)e.getSource()).setSelected(!showTable);
            }
        });
        menu.add(viewPoolsTableMenuItem);
        menu.add(this.actionAddSearchPanel);
        menu.addSeparator();
        menu.add(new AbstractAction(TextPool.getString("menuResetColumnOrder")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainWindow.this.getMainTablePanel().resetColumnOrder();
            }
        });
        ButtonGroup toolbarMenuItemGroup = new ButtonGroup();
        JMenu toolbarSymbolsMenu = new JMenu(TextPool.getString("menuToolbarIcons"));
        JRadioButtonMenuItem toolbarSmallIcons = new JRadioButtonMenuItem(TextPool.getString("menuToolbarSmallIcons"));
        toolbarSmallIcons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.setToolbarIconSize(1);
            }
        });
        toolbarMenuItemGroup.add(toolbarSmallIcons);
        toolbarSymbolsMenu.add(toolbarSmallIcons);
        JRadioButtonMenuItem toolbarBigIcons = new JRadioButtonMenuItem(TextPool.getString("menuToolbarBigIcons"));
        toolbarBigIcons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.setToolbarIconSize(2);
            }
        });
        toolbarMenuItemGroup.add(toolbarBigIcons);
        toolbarSymbolsMenu.add(toolbarBigIcons);
        menu.addSeparator();
        menu.add(toolbarSymbolsMenu);
        menuBar.add(menu);
        menu = new JMenu(TextPool.getString("menuReceipt"));
        menu.add(this.actionReceiptInput);
        menuBar.add(menu);
        this.pluginsListHasChanged(dataCenter.getPluginList());
        menuBar.add(this.calculationMenu);
        menu = new JMenu(TextPool.getString("menuSettings"));
        menu.add(this.actionProgramSettings);
        menu.addSeparator();
        menu.add(this.actionSettingsGeneralData);
        menu.add(this.actionSettingsTax);
        menu.add(this.actionSettingsAccounts);
        menu.add(this.actionSettingsPlugins);
        menu.addSeparator();
        menu.add(this.actionSettingsReceiptDescriptions);
        menu.add(this.actionSettingsReceiptTemplates);
        menu.addSeparator();
        menu.add(new ActionEditDepreciationRules(this));
        menu.addSeparator();
        menu.add(new LookAndFeelMenu(this));
        menuBar.add(menu);
        menu = new JMenu(TextPool.getString("menuHelp"));
        menu.add(this.actionAbout);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        this.toolbar.setFloatable(true);
        this.toolbar.setUndockingEnabled(false);
        this.getContentPane().addContainerListener(new ContainerListener(){

            @Override
            public void componentRemoved(ContainerEvent e) {
                if (e.getChild() == MainWindow.this.toolbar) {
                    MainWindow.this.toolbar.remove(MainWindow.this.infoPanel);
                    MainWindow.this.getContentPane().add((Component)MainWindow.this.toolbarOnlyInfo, "North");
                }
            }

            @Override
            public void componentAdded(ContainerEvent e) {
                if (e.getChild() == MainWindow.this.toolbar) {
                    String toolbarPosition = MainWindow.this.toolbar.getToolbarPosition().toString();
                    if ("West".equals(toolbarPosition) || "East".equals(toolbarPosition) || toolbarPosition == null) {
                        MainWindow.this.toolbar.remove(MainWindow.this.infoPanel);
                        MainWindow.this.getContentPane().add((Component)MainWindow.this.toolbarOnlyInfo, "North");
                        return;
                    }
                    if ("North".equals(toolbarPosition) || "South".equals(toolbarPosition)) {
                        MainWindow.this.toolbar.add(MainWindow.this.infoPanel);
                        MainWindow.this.getContentPane().remove(MainWindow.this.toolbarOnlyInfo);
                        return;
                    }
                }
            }
        });
        dataCenter.addGeneralDataListener(this.infoPanel);
        InfoPanel ip = new InfoPanel();
        dataCenter.addGeneralDataListener(ip);
        this.toolbarOnlyInfo = new JToolBar();
        this.toolbarOnlyInfo.add(Box.createHorizontalGlue());
        this.toolbarOnlyInfo.add(ip);
        this.toolbarOnlyInfo.repaint();
        this.toolbarOnlyInfo.setFloatable(false);
        this.mainTablePanel = new MainTablePanel(this);
        this.actionProgramSettings.setMainTablePanel(this.mainTablePanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.mainTablePanel);
        this.getContentPane().add("North", this.toolbar);
        this.getContentPane().doLayout();
        this.pack();
        if (settingsManager.getMainWindowPos() != null) {
            this.setLocation(settingsManager.getMainWindowPos());
        }
        if (settingsManager.getMainWindowSize() != null) {
            this.setSize(settingsManager.getMainWindowSize());
        }
        if (settingsManager.getColumnOrder() != null) {
            this.getMainTablePanel().setColumnOrder(settingsManager.getColumnOrder());
        }
        if (settingsManager.getToolbarPos() != null) {
            this.setToolbarPosition(settingsManager.getToolbarPos());
        }
        if (settingsManager.getToolbarIconSize() != null) {
            this.setToolbarIconSize(Numbers.getIntFromString(settingsManager.getToolbarIconSize(), 1));
        }
        if (settingsManager.getLookAndFeel() != null) {
            try {
                UIManager.setLookAndFeel(settingsManager.getLookAndFeel());
                SwingUtilities.updateComponentTreeUI(this.getRootPane());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(currentAssociationCommand = settingsManager.getFileTypeAssociationCommand()).equals(currentStartupFileLocation = GuiTools.getAbsoluteProgramPath()) && GuiTools.makeWindowsFileAssociation(".eux", "JesDataFile")) {
            settingsManager.setFileTypeAssociationCommand(currentStartupFileLocation);
        }
        GuiTools.adjustFrameToScreenSize(this);
        if (settingsManager.doUseYearTable()) {
            this.mainTablePanel.addYearTable();
        }
        viewYearTableMenuItem.setSelected(settingsManager.doUseYearTable());
        if (settingsManager.doUsePoolsTable()) {
            this.mainTablePanel.addPoolsTable();
        }
        viewPoolsTableMenuItem.setSelected(settingsManager.doUsePoolsTable());
        toolbarSmallIcons.setSelected(this.getToolbarIconSize() == 1);
        toolbarBigIcons.setSelected(this.getToolbarIconSize() == 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.this.closeMainWindow();
            }
        });
        String fileToOpen = null;
        fileToOpen = this.checkForRecoveryFile();
        if (fileToOpen == null && CommandLineArguments.getInstance().getArgumentCount() > 0 && !new File(fileToOpen = CommandLineArguments.getInstance().getArgument(0)).exists()) {
            fileToOpen = null;
        }
        if (fileToOpen == null) {
            fileToOpen = this.startupDialog();
        }
        if (fileToOpen != null) {
            this.loadFile(fileToOpen);
        }
        if ((today = Calendar.getInstance()).get(1) == dataCenter.getBusinessYear()) {
            this.mainTablePanel.setSelectedMonth(today.get(2) + 1);
        }
        if (settingsManager.doLookForUpdates() && VersionManager.isUpdateAvailable()) {
            String message = String.format(TextPool.getString("msgUpdateFound"), VersionManager.getServerProgramVersionString());
            JOptionPane.showMessageDialog(this, message, TextPool.getString("titleUpdateFound"), 1);
        }
        Timer timer = new Timer(60000, new ActionListener(){
            private int numMinutesPassed = 0;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int autoSaveDelay = SettingsManager.getInstance().getAutoSaveDelay();
                ++this.numMinutesPassed;
                if (autoSaveDelay > 0 && autoSaveDelay <= this.numMinutesPassed) {
                    DataCenter.getInstance().requestFillOutputBuffer();
                    this.numMinutesPassed = 0;
                }
            }
        });
        timer.start();
    }

    private String checkForRecoveryFile() {
        if (DataCenter.recoveryFilePresent()) {
            int res = JOptionPane.showConfirmDialog(null, TextPool.getString("msgRecoveryFileFound"), TextPool.getString("titleRecovery"), 1);
            if (res == 2) {
                this.shutdown();
            }
            if (res == 0) {
                if (DataCenter.recoveryFileRecoverable()) {
                    JOptionPane.showMessageDialog(null, TextPool.getString("msgRecoveryFileImported"), TextPool.getString("titleRecovery"), 1);
                    return DirectoryManager.recoveryFileName;
                }
                JOptionPane.showMessageDialog(null, TextPool.getString("msgRecoveryFileCorrupt"), TextPool.getString("titleRecovery"), 0);
                DataCenter.getInstance().deleteRecoveryFile();
                return null;
            }
            if (res == 1) {
                DataCenter.getInstance().deleteRecoveryFile();
                return null;
            }
        }
        return null;
    }

    private String startupDialog() {
        StartupDialog s = new StartupDialog(this);
        s.setVisible(true);
        if (!(s.startupNew() || s.startupLast() || s.startupOpen())) {
            this.shutdown();
        }
        if (s.startupNew()) {
            ProjectAssistant pa = new ProjectAssistant(null);
            pa.setVisible(true);
            if (!pa.allFinished()) {
                this.shutdown();
            }
            return null;
        }
        if (s.startupOpen()) {
            JesFileChooser dialog = new JesFileChooser();
            dialog.setFileFilter(FilenameExtensions.fileFilterEurFiles);
            int res = dialog.showOpenDialog(this);
            if (res == 0) {
                if (dialog.getSelectedFile() != null) {
                    return dialog.getSelectedFile().getAbsolutePath();
                }
            } else {
                this.shutdown();
            }
        } else if (s.startupLast()) {
            return s.getStartupFilename();
        }
        return null;
    }

    private void loadFile(String fileToOpen) {
        KernelReadEuxFile k = new KernelReadEuxFile(fileToOpen);
        ProgressBarAdapterForKernel<KernelReadEuxFile> adapterForKernel = new ProgressBarAdapterForKernel<KernelReadEuxFile>(k);
        ProgressBarForRunnable progressBar = new ProgressBarForRunnable(this, adapterForKernel, new RunnableResultReceiver(){

            @Override
            public void processResult(Object result) {
                try {
                    ProgressBarAdapterForKernel pb = (ProgressBarAdapterForKernel)result;
                    Exception e = (Exception)pb.get("KERNEL_EXCEPTION");
                    if (e != null) {
                        throw e;
                    }
                    DataCenter.getInstance().getAllDataFromKernel((KernelReadEuxFile)pb.getKernel());
                }
                catch (Exception ex) {
                    LoggingManager.logException(this.getClass(), ex);
                    JOptionPane.showMessageDialog(MainWindow.this, ex.getMessage(), TextPool.getString("titleErrorMessage"), 0);
                    MainWindow.this.shutdown();
                }
            }
        });
        progressBar.setText(TextPool.getString("msgLoadingFile"));
        progressBar.start();
    }

    public JMenu getLastFilesMenu() {
        return this.lastFilesMenu;
    }

    public JMenu getCalculationMenu() {
        return this.calculationMenu;
    }

    public MainTablePanel getMainTablePanel() {
        return this.mainTablePanel;
    }

    public void saveData() {
        Logger logger = Logger.getLogger("de.uwemock.eur.MainWindow");
        String filename = SettingsManager.getInstance().getCurrentFilename();
        if (filename == null) {
            JesFileChooser dialog = new JesFileChooser();
            int res = dialog.showSaveDialog(this);
            if (dialog.getSelectedFile() != null && !dialog.getSelectedFile().isDirectory() && res == 0) {
                filename = dialog.getSelectedFile().getAbsolutePath();
            } else {
                return;
            }
        }
        filename = FilenameExtensions.makeEuxFilename(filename);
        try {
            DataCenter.getInstance().writeAllData(filename, SettingsManager.getInstance().doCreateBackup());
            SettingsManager.getInstance().setCurrentFilename(filename);
        }
        catch (FileNotFoundException ex) {
            logger.finest("File not found exception thrown...");
            logger.finest(Arrays.toString(ex.getStackTrace()));
            JOptionPane.showMessageDialog(this, ex.getMessage(), TextPool.getString("titleErrorMessage"), 0);
        }
        catch (IOException ex) {
            logger.finest("IO exception thrown...");
            logger.finest(Arrays.toString(ex.getStackTrace()));
            JOptionPane.showMessageDialog(this, TextPool.getString("msgWriteError"), TextPool.getString("titleErrorMessage"), 0);
        }
        catch (XMLStreamException ex) {
            logger.finest("XML stream exception thrown...");
            logger.finest(Arrays.toString(ex.getStackTrace()));
            JOptionPane.showMessageDialog(this, TextPool.getString("msgWriteError"), TextPool.getString("titleErrorMessage"), 0);
        }
    }

    public void saveDataAs() {
        Logger logger = Logger.getLogger("de.uwemock.eur.MainWindow");
        boolean loggerIsLoggingFinest = logger.isLoggable(Level.FINEST);
        JesFileChooser dialog = new JesFileChooser();
        dialog.showSaveDialog(this);
        if (dialog.getSelectedFile() != null && !dialog.getSelectedFile().isDirectory()) {
            File file;
            String filename = dialog.getSelectedFile().getAbsolutePath();
            if (loggerIsLoggingFinest) {
                logger.finest("User entered filename " + filename);
            }
            filename = FilenameExtensions.makeEuxFilename(filename);
            if (loggerIsLoggingFinest) {
                logger.finest("Filename with extension: " + filename);
            }
            if ((file = new File(filename)).exists()) {
                logger.finest("File exists; will ask user what to do...");
                int confirmation = JOptionPane.showConfirmDialog(this, TextPool.getString("msgFileExists"), TextPool.getString("titleOverwriteMessage"), 0);
                if (confirmation == 1) {
                    return;
                }
                logger.finest("User says: overwrite.");
            }
            try {
                DataCenter.getInstance().writeAllData(filename, SettingsManager.getInstance().doCreateBackup());
                SettingsManager.getInstance().setCurrentFilename(filename);
            }
            catch (FileNotFoundException ex) {
                logger.finest("File not found exception thrown...");
                logger.finest(Arrays.toString(ex.getStackTrace()));
                JOptionPane.showMessageDialog(this, ex.getMessage(), TextPool.getString("titleErrorMessage"), 0);
            }
            catch (IOException ex) {
                logger.finest("IO exception thrown...");
                logger.finest(Arrays.toString(ex.getStackTrace()));
                JOptionPane.showMessageDialog(this, TextPool.getString("msgWriteError"), TextPool.getString("titleErrorMessage"), 0);
            }
            catch (XMLStreamException ex) {
                logger.finest("XML stream exception thrown...");
                logger.finest(Arrays.toString(ex.getStackTrace()));
                JOptionPane.showMessageDialog(this, TextPool.getString("msgWriteError"), TextPool.getString("titleErrorMessage"), 0);
            }
        }
    }

    public void closeMainWindow() {
        if (DataCenter.getInstance().dataHasChanged()) {
            int res = JOptionPane.showConfirmDialog(this, TextPool.getString("msgDataChangedAtEnd"), TextPool.getString("titleProgramClosing"), 1);
            if (res == 2) {
                return;
            }
            if (res == 0) {
                this.saveData();
            }
        }
        SettingsManager settingsManager = SettingsManager.getInstance();
        settingsManager.setMainWindowPos(this.getLocation());
        settingsManager.setMainWindowSize(this.getSize());
        settingsManager.setToolbarPos(this.getToolbarPosition().toString());
        settingsManager.setToolbarIconSize(this.getToolbarIconSize());
        settingsManager.setColumnOrder(this.getMainTablePanel().getColumnOrder());
        settingsManager.setLookAndFeel(UIManager.getLookAndFeel().getClass().getName());
        settingsManager.writeSettings();
        DataCenter.getInstance().deleteRecoveryFile();
        this.shutdown();
    }

    private void shutdown() {
        DataCenter.getInstance().closeFileContext();
        System.exit(0);
    }

    @Override
    public void lastFilesChanged(String[] lastFiles) {
        this.lastFilesMenu.removeAll();
        String[] stringArray = lastFiles;
        int n = lastFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            ActionOpenFile action = new ActionOpenFile(this, filename);
            this.lastFilesMenu.add(action);
            ++n2;
        }
    }

    @Override
    public void updateCurrentFileInfo(String currentFile) {
        String locked = "";
        if (!DataCenter.getInstance().isDataEditable()) {
            locked = TextPool.getString("textDataLocked");
        }
        if (currentFile != null && !currentFile.isEmpty()) {
            this.setTitle(String.valueOf(TextPool.getString("titleMainWindow")) + " - " + GuiTools.shortenPathname(currentFile, 64, 4) + locked);
        } else {
            this.setTitle(String.valueOf(TextPool.getString("titleMainWindow")) + locked);
        }
    }

    private void createToolbar() {
        this.toolbar.removeAll();
        this.toolbar.add(this.actionOpen);
        this.toolbar.add(this.actionSave);
        this.toolbar.add(this.actionReceiptInput);
        this.toolbar.addSeparator();
        this.toolbar.add(this.actionCalcTax);
        this.toolbar.add(this.actionCalcAccountSums);
        this.toolbar.add(this.actionReceiptList);
        this.toolbar.add(this.actionDepreciationList);
        this.toolbar.add(this.actionPoolList);
        if (this.firstPlugin != null) {
            this.toolbar.addSeparator();
            this.toolbar.add(new ActionProcessPlugin(this, this.firstPlugin, "/icons/plugin.png", "/icons/large/plugin.png"));
        }
        this.toolbar.addSeparator();
        this.toolbar.add(this.actionAddSearchPanel);
        this.toolbar.add(Box.createHorizontalGlue());
        if (this.toolbar.getOrientation() == 0) {
            this.toolbar.add(this.infoPanel);
        }
        this.toolbar.repaint();
    }

    public Object getToolbarPosition() {
        return this.toolbar.getToolbarPosition();
    }

    public void setToolbarPosition(Object pos) {
        this.toolbar.setToolbarPosition(pos, this.getContentPane());
        this.toolbar.remove(this.infoPanel);
        if (pos.equals("North") || pos.equals("South")) {
            this.toolbar.add(this.infoPanel);
        }
        this.toolbar.repaint();
    }

    public int getToolbarIconSize() {
        return this.toolbar.getIconSize();
    }

    public void setToolbarIconSize(int size) {
        this.toolbar.setIconSize(size);
    }

    public void setSaveActionEnabled(boolean enabled) {
        this.actionSave.setEnabled(enabled);
    }

    @Override
    public void pluginsListHasChanged(List<AbstractEurPlugin> plugins) {
        this.calculationMenu.removeAll();
        this.calculationMenu.add(this.actionCalcTax);
        this.calculationMenu.add(this.actionCalcAccountSums);
        this.calculationMenu.add(this.actionReceiptList);
        this.calculationMenu.add(this.actionMonthlySummaryIncludingTax);
        this.calculationMenu.add(this.actionMonthlySummaryExcludingTax);
        this.calculationMenu.add(this.actionDepreciationList);
        this.calculationMenu.add(this.actionPoolList);
        this.firstPlugin = null;
        if (plugins.size() > 0) {
            this.calculationMenu.add(new JSeparator());
            for (EurPlugin eurPlugin : plugins) {
                this.calculationMenu.add(new ActionProcessPlugin(this, eurPlugin, "/icons/plugin.png", "/icons/large/plugin.png"));
            }
            this.firstPlugin = plugins.get(0);
        }
        this.createToolbar();
    }

    @Override
    public void generalDataChanged() {
        boolean dataEditable = DataCenter.getInstance().isDataEditable();
        this.editableMenuItem.setSelected(!dataEditable);
        this.actionUndo.setEnabled(dataEditable && JesUndoManager.getInstance().canUndo());
        this.actionRedo.setEnabled(dataEditable && JesUndoManager.getInstance().canRedo());
        this.actionReceiptInput.setEnabled(dataEditable);
        this.actionSettingsGeneralData.setEnabled(dataEditable);
        this.actionSettingsTax.setEnabled(dataEditable);
        this.actionSettingsAccounts.setEnabled(dataEditable);
        this.updateCurrentFileInfo(SettingsManager.getInstance().getCurrentFilename());
    }

    @Override
    public void handleAbout(ApplicationEvent arg0) {
        this.actionAbout.actionPerformed(null);
    }

    @Override
    public void handleOpenApplication(ApplicationEvent arg0) {
    }

    @Override
    public void handleOpenFile(ApplicationEvent arg0) {
        this.actionOpen.actionPerformed(null);
    }

    @Override
    public void handlePreferences(ApplicationEvent arg0) {
        this.actionProgramSettings.actionPerformed(null);
    }

    @Override
    public void handlePrintFile(ApplicationEvent arg0) {
    }

    @Override
    public void handleQuit(ApplicationEvent arg0) {
        this.closeMainWindow();
    }

    @Override
    public void handleReOpenApplication(ApplicationEvent arg0) {
    }
}

