/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.gui.ReceiptGroupSelectionPanel;
import de.uwemock.eur.gui.ReceiptGroupTable;
import de.uwemock.eur.gui.SearchPanel;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.actions.ActionEditPoolDepreciationSettings;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.eur.receipt.ReceiptGroup;
import de.uwemock.eur.receipt.ReceiptGroupListener;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.eur.receipt.gui.ReceiptGroupTableModel;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.TableColumnOrderManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class MainTablePanel
extends JPanel {
    private JFrame parent;
    private JTabbedPane tabbedPane;
    private ReceiptGroupTable[] monthTables = new ReceiptGroupTable[12];
    private ReceiptGroupSelectionPanel poolTablePanel;
    private JComponent yearTablePanel;
    private TableColumnOrderManager columnManager = new TableColumnOrderManager();

    MainTablePanel(JFrame parent) {
        this.parent = parent;
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, "Center");
        this.poolTablePanel = new ReceiptGroupSelectionPanel(this.parent, "Pools", PoolManager.getInstance());
        this.poolTablePanel.setTopPanelExtraAction(new ActionEditPoolDepreciationSettings(this.parent, this.poolTablePanel));
        this.columnManager.add(this.poolTablePanel.getDisplayTable());
        ReceiptGroupTable yearTable = new ReceiptGroupTable(this.parent, new ReceiptGroupTableModel(ReceiptGroupManager.getInstance().getAllReceiptsGroup()));
        this.yearTablePanel = new JScrollPane(yearTable);
        this.columnManager.add(yearTable);
        this.addMonthTables();
    }

    private void addMonthTables() {
        int i = 1;
        while (i <= 12) {
            ReceiptGroupTable table;
            ReceiptGroup group = ReceiptGroupManager.getInstance().getReceiptGroup(i);
            this.monthTables[i - 1] = table = new ReceiptGroupTable(this.parent, new ReceiptGroupTableModel(group));
            final int month = i;
            group.addReceiptGroupListener(new ReceiptGroupListener(){

                @Override
                public void receiptGroupChanged() {
                    Logger logger = Logger.getLogger("de.uwemock.eur.gui.MainTablePanel");
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("ReceiptGroupListener notification received: " + month);
                    }
                    if (SettingsManager.getInstance().doAutoScroll() && MainTablePanel.this.tabbedPane.getSelectedIndex() < 12) {
                        MainTablePanel.this.tabbedPane.setSelectedIndex(month - 1);
                    }
                }
            });
            this.columnManager.add(table);
            JScrollPane scroller = new JScrollPane(table);
            this.tabbedPane.add(TextPool.MONTHS[i - 1], scroller);
            ++i;
        }
        this.tabbedPane.setSelectedIndex(0);
    }

    public void addYearTable() {
        Component[] allTabs = this.tabbedPane.getComponents();
        int i = 0;
        while (i < allTabs.length) {
            if (allTabs[i] == this.yearTablePanel) {
                return;
            }
            ++i;
        }
        this.tabbedPane.insertTab(TextPool.YEAR, null, this.yearTablePanel, null, 12);
    }

    public void addPoolsTable() {
        int position = 12;
        Component[] allTabs = this.tabbedPane.getComponents();
        int i = 0;
        while (i < allTabs.length) {
            if (allTabs[i] == this.poolTablePanel) {
                return;
            }
            if (allTabs[i] == this.yearTablePanel) {
                position = i + 1;
                break;
            }
            ++i;
        }
        this.tabbedPane.insertTab(TextPool.getString("titlePoolsPanel"), null, this.poolTablePanel, null, position);
    }

    public void addSearchPanel() {
        SearchPanel searchPanel = new SearchPanel(this.parent, this);
        this.columnManager.add(searchPanel.getDisplayTable());
        GuiTools.addClosableTab(this.tabbedPane, searchPanel, TextPool.getString("titleSearchPanel"), null);
        this.tabbedPane.addContainerListener(searchPanel);
        this.tabbedPane.doLayout();
        searchPanel.setDividerLocation(0.3);
    }

    public void removeSearchPanel(SearchPanel panel) {
        ReceiptGroupManager.getInstance().getAllReceiptsGroup().removeReceiptGroupListener(panel);
        this.tabbedPane.removeContainerListener(panel);
        this.columnManager.remove(panel.getDisplayTable());
    }

    public void removeYearTable() {
        this.tabbedPane.remove(this.yearTablePanel);
    }

    public void removePoolsTable() {
        this.tabbedPane.remove(this.poolTablePanel);
    }

    public void setSelectedMonth(int month) {
        this.tabbedPane.setSelectedIndex(month - 1);
    }

    public void repaintTables() {
        ReceiptGroupTable[] receiptGroupTableArray = this.monthTables;
        int n = this.monthTables.length;
        int n2 = 0;
        while (n2 < n) {
            ReceiptGroupTable table = receiptGroupTableArray[n2];
            ReceiptGroupTableModel model = (ReceiptGroupTableModel)table.getModel();
            model.fireTableDataChanged();
            ++n2;
        }
        this.yearTablePanel.repaint();
        this.poolTablePanel.repaint();
    }

    public String getColumnOrder() {
        return this.columnManager.getColumnsList();
    }

    public void setColumnOrder(String columnOrder) {
        this.columnManager.setColumnOrder(columnOrder);
    }

    public void resetColumnOrder() {
        this.columnManager.resetColumnOrder();
    }
}

