/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.GuiTools;
import de.uwemock.tools.LoggingManager;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LogSettingsPanel
extends AbstractStandardDialogPanel {
    private JPanel innerPanel = new JPanel();
    private JCheckBox loggingActive;
    private JTextField loggingFilename = new JTextField(40);
    private JTextField loggingScope = new JTextField(40);
    private JComboBox loggingLevel = new JComboBox<String>(LoggingManager.LEVEL_NAMES);
    private Action okAction;

    public LogSettingsPanel() {
        this.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleLoggingSettings")));
        this.loggingActive = new JCheckBox(new AbstractAction(TextPool.getString("labelLoggingActive")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (LogSettingsPanel.this.loggingActive.isSelected()) {
                    int res = JOptionPane.showConfirmDialog(null, TextPool.getString("msgActivateLogging"), TextPool.getString("titleInformation"), 2);
                    LogSettingsPanel.this.loggingActive.setSelected(res == 0);
                }
                LogSettingsPanel.this.enableInputs();
            }
        });
        this.loggingFilename.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                LogSettingsPanel.this.checkInputValid();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LogSettingsPanel.this.checkInputValid();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LogSettingsPanel.this.checkInputValid();
            }
        });
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GuiTools.addComponent(this, gbl, this.loggingActive, 0, 0, 2, 1, 1.0, 0.0);
        GuiTools.addComponent(this, gbl, Box.createHorizontalGlue(), 0, 1, 1, 1, 1.0, 1.0);
        GuiTools.addComponent(this, gbl, this.innerPanel, 1, 1, 1, 1, 1.0, 1.0);
        gbl = new GridBagLayout();
        this.innerPanel.setLayout(gbl);
        GuiTools.addComponent(this.innerPanel, gbl, new JLabel(TextPool.getString("labelLoggingFilename")), 0, 0, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this.innerPanel, gbl, new JLabel(TextPool.getString("labelLoggingLevel")), 0, 1, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this.innerPanel, gbl, new JLabel(TextPool.getString("labelLoggingScope")), 0, 2, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this.innerPanel, gbl, this.loggingFilename, 1, 0, 1, 1, 1.0, 0.0);
        GuiTools.addComponent(this.innerPanel, gbl, this.loggingLevel, 1, 1, 1, 1, 1.0, 0.0);
        GuiTools.addComponent(this.innerPanel, gbl, this.loggingScope, 1, 2, 1, 1, 1.0, 0.0);
    }

    private void enableInputs() {
        boolean inputEnabled = this.loggingActive.isSelected();
        this.loggingFilename.setEnabled(inputEnabled);
        this.loggingLevel.setEnabled(inputEnabled);
        this.loggingScope.setEnabled(inputEnabled);
        this.checkInputValid();
    }

    private void checkInputValid() {
        if (this.okAction != null) {
            this.okAction.setEnabled(!this.loggingActive.isSelected() || this.loggingFilename.getText().length() != 0);
        }
    }

    @Override
    public void dialogOpens() {
        this.loggingActive.setSelected(SettingsManager.getInstance().isLoggingActive());
        this.loggingFilename.setText(SettingsManager.getInstance().getLogFile());
        this.loggingScope.setText(SettingsManager.getInstance().getLogScope());
        String currentLevel = SettingsManager.getInstance().getLogLevel().getLocalizedName();
        int i = 0;
        while (i < this.loggingLevel.getModel().getSize()) {
            if (currentLevel.equals(this.loggingLevel.getModel().getElementAt(i).toString())) {
                this.loggingLevel.setSelectedIndex(i);
            }
            ++i;
        }
        this.enableInputs();
    }

    @Override
    public void saveDialogData() {
        SettingsManager.getInstance().setLoggingActive(this.loggingActive.isSelected());
        SettingsManager.getInstance().setLogFile(this.loggingFilename.getText());
        SettingsManager.getInstance().setLogLevel(LoggingManager.getLogLevelFromLocalizedName(this.loggingLevel.getSelectedItem().toString()));
        SettingsManager.getInstance().setLogScope(this.loggingScope.getText());
        LoggingManager.setupLogging(SettingsManager.getInstance().getLogFile(), SettingsManager.getInstance().getLogLevel(), SettingsManager.getInstance().getLogScope());
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleLoggingSettings");
    }

    @Override
    public void setOkAction(Action okAction) {
        this.okAction = okAction;
    }
}

