/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.gui.TextPool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class JesFileSaveDialog
extends JDialog
implements ActionListener {
    private JPanel optionsPanel;
    private JFileChooser fileChooser;
    private JCheckBox saveCompressed = new JCheckBox(TextPool.getString("labelUseCompression"));
    private File selectedFile;

    public JesFileSaveDialog(Frame parent, String startDirectory) {
        super(parent, true);
        this.setTitle(TextPool.getString("titleSaveData"));
        this.fileChooser = new JFileChooser(startDirectory);
        this.fileChooser.setDialogType(1);
        this.fileChooser.addActionListener(this);
        this.optionsPanel = new JPanel();
        this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleOptions")));
        this.optionsPanel.add(this.saveCompressed);
        this.setLayout(new BorderLayout());
        this.add((Component)this.fileChooser, "Center");
        this.add((Component)this.optionsPanel, "South");
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public String getSelectedFileName() {
        if (this.getSelectedFile() != null) {
            return this.selectedFile.getAbsolutePath();
        }
        return null;
    }

    public void setUseCompression(boolean useCompression) {
        this.saveCompressed.setSelected(useCompression);
    }

    public boolean doUseCompression() {
        return this.saveCompressed.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String command = arg0.getActionCommand();
        if ("ApproveSelection".equals(command)) {
            this.selectedFile = this.fileChooser.getSelectedFile();
            this.setVisible(false);
        }
        if ("CancelSelection".equals(command)) {
            this.selectedFile = null;
            this.setVisible(false);
        }
    }
}

