/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.data.SettingsManager;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;

public class JesFileChooser
extends JFileChooser {
    public JesFileChooser() {
        File currentDirectory = new File(SettingsManager.getInstance().getLastDirectoryUsed());
        this.setCurrentDirectory(currentDirectory);
    }

    @Override
    public int showOpenDialog(Component parent) {
        int res = super.showOpenDialog(parent);
        if (res == 0) {
            this.putLastDirectoryUsed();
        }
        return res;
    }

    @Override
    public int showSaveDialog(Component parent) {
        int res = super.showSaveDialog(parent);
        if (res == 0) {
            this.putLastDirectoryUsed();
        }
        return res;
    }

    private void putLastDirectoryUsed() {
        String directory;
        File selected = null;
        if (this.isMultiSelectionEnabled()) {
            File[] files = this.getSelectedFiles();
            if (files.length > 0) {
                selected = files[0];
            }
        } else {
            selected = this.getSelectedFile();
        }
        if (selected != null && (directory = selected.isDirectory() ? selected.getAbsolutePath() : selected.getParent()) != null) {
            SettingsManager.getInstance().setLastDirectoryUsed(directory);
        }
    }
}

