/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.calculation.plugins.AbstractEurPlugin;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.FilenameExtensions;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.data.TaxList;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.ThinkingComboBoxModel;
import de.uwemock.eur.kernels.KernelReadEuxFile;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.DepreciationPool;
import de.uwemock.guitools.AbstractSimpleAssistantPanel;
import de.uwemock.guitools.FilenamePanel;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ImportOldDataPanel
extends AbstractSimpleAssistantPanel {
    private boolean finished;
    private boolean importDone;
    private AccountList accountList;
    private LinkedList<AbstractReceipt> receiptsList;
    private LinkedList<DepreciationPool> poolsList;
    private TaxList taxList;
    private ArrayList<AbstractEurPlugin> pluginsList;
    private ThinkingComboBoxModel receiptDescriptions;
    private DefaultComboBoxModel paymentTemplates;
    private String ownerName;
    private String ownerCompany;
    private String ownerAddress;
    private String ownerTaxId;
    private int businessYear;
    private String currency;
    private int maxReceiptDescriptions;
    private JCheckBox importGeneralData = new JCheckBox(TextPool.getString("importGeneralData"), true);
    private JCheckBox importPaymentTemplates = new JCheckBox(TextPool.getString("importPaymentTemplates"), true);
    private JCheckBox importTaxes = new JCheckBox(TextPool.getString("importTaxes"), true);
    private JCheckBox importAccounts = new JCheckBox(TextPool.getString("importAccounts"), true);
    private JCheckBox importPlugins = new JCheckBox(TextPool.getString("importPlugins"), true);
    private JCheckBox importDepreciationReceipts = new JCheckBox(TextPool.getString("importDepreciationReceipts"), true);
    private JCheckBox importUnpaidReceipts = new JCheckBox(TextPool.getString("importUnpaidReceipts"), true);
    private FilenamePanel filenamePanel = new FilenamePanel(new JLabel(String.valueOf(TextPool.getString("labelFilename")) + ":"), FilenameExtensions.fileFilterEurFiles, new File(SettingsManager.getInstance().getLastDirectoryUsed()), TextPool.getString("buttonBrowse"));
    private JButton buttonImportNow = new JButton(TextPool.getString("buttonImportNow"));
    private JLabel importResultLabel = new JLabel();
    private Action nextAction;

    public ImportOldDataPanel() {
        this.setLayout(new GridLayout(9, 1, 10, 10));
        this.add(this.importGeneralData);
        this.add(this.importPaymentTemplates);
        this.add(this.importTaxes);
        this.add(this.importAccounts);
        this.add(this.importPlugins);
        this.add(this.importDepreciationReceipts);
        this.add(this.filenamePanel);
        this.add(this.buttonImportNow);
        this.add(this.importResultLabel);
        this.buttonImportNow.setEnabled(false);
        this.filenamePanel.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateButton(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateButton(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateButton(e);
            }

            private void updateButton(DocumentEvent e) {
                ImportOldDataPanel.this.buttonImportNow.setEnabled(!ImportOldDataPanel.this.importDone && e.getDocument().getLength() > 0);
                ImportOldDataPanel.this.nextAction.setEnabled(ImportOldDataPanel.this.importDone || e.getDocument().getLength() == 0);
            }
        });
        this.buttonImportNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportOldDataPanel.this.importNow();
            }
        });
    }

    @Override
    public String getInformationText() {
        return TextPool.getString("informationImportOldData");
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleDataImport");
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    private void importNow() {
        this.importResultLabel.setText("");
        KernelReadEuxFile k = new KernelReadEuxFile(this.filenamePanel.getFilename());
        try {
            k.executeWork();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this, TextPool.getString("msgFileNotFound"), TextPool.getString("titleErrorMessage"), 0);
            return;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), TextPool.getString("titleErrorMessage"), 0);
            return;
        }
        this.accountList = (AccountList)k.get("ACCOUNT_LIST");
        this.receiptsList = (LinkedList)k.get("RECEIPTS_LIST");
        this.poolsList = (LinkedList)k.get("DEPRECIATION_POOLS");
        this.taxList = (TaxList)k.get("TAX_LIST");
        this.pluginsList = (ArrayList)k.get("PLUGINS_LIST");
        this.receiptDescriptions = (ThinkingComboBoxModel)k.get("RECEIPT_DESCRIPTIONS");
        this.paymentTemplates = (DefaultComboBoxModel)k.get("RECEIPT_TEMPLATES");
        this.ownerName = (String)k.get("OWNER_NAME");
        this.ownerCompany = (String)k.get("OWNER_COMPANY");
        this.ownerAddress = (String)k.get("OWNER_ADDRESS");
        this.ownerTaxId = (String)k.get("OWNER_TAX_ID");
        this.businessYear = (Integer)k.get("BUSINESS_YEAR");
        this.currency = (String)k.get("CURRENCY");
        this.maxReceiptDescriptions = (Integer)k.get("MAX_DESCRIPTIONS");
        if (this.importGeneralData.isSelected()) {
            DataCenter dataCenter = DataCenter.getInstance();
            if (this.ownerName != null) {
                dataCenter.setOwnerName(this.ownerName);
            }
            if (this.ownerCompany != null) {
                dataCenter.setOwnerCompany(this.ownerCompany);
            }
            if (this.ownerAddress != null) {
                dataCenter.setOwnerAddress(this.ownerAddress);
            }
            if (this.ownerTaxId != null) {
                dataCenter.setOwnerTaxId(this.ownerTaxId);
            }
            if (this.businessYear != 0) {
                dataCenter.setBusinessYear(this.businessYear + 1);
            }
            if (this.currency != null) {
                dataCenter.setCurrency(this.currency);
            }
            if (this.receiptDescriptions != null) {
                dataCenter.setLastReceiptDescriptions(this.receiptDescriptions);
            }
            if (this.maxReceiptDescriptions != 0) {
                dataCenter.setMaxLastReceiptDescriptions(this.maxReceiptDescriptions);
            }
        }
        if (this.importAccounts.isSelected() && this.accountList != null) {
            DataCenter.getInstance().setAccountList(this.accountList);
        }
        if (this.importTaxes.isSelected() && this.taxList != null) {
            DataCenter.getInstance().setTaxList(this.taxList);
        }
        if (this.importPlugins.isSelected() && this.pluginsList != null) {
            DataCenter.getInstance().setPluginList(this.pluginsList);
        }
        if (this.importPaymentTemplates.isSelected() && this.paymentTemplates != null) {
            int size = this.paymentTemplates.getSize();
            DefaultComboBoxModel model = DataCenter.getInstance().getPaymentTemplateList();
            int i = 0;
            while (i < size) {
                model.addElement(this.paymentTemplates.getElementAt(i));
                ++i;
            }
        }
        this.importResultLabel.setFont(this.importResultLabel.getFont().deriveFont(1));
        this.importResultLabel.setForeground(Color.BLUE);
        this.importResultLabel.setHorizontalAlignment(0);
        this.importResultLabel.setText(TextPool.getString("labelImportDone"));
        this.importDone = true;
        this.nextAction.setEnabled(true);
        this.buttonImportNow.setEnabled(false);
    }

    @Override
    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    @Override
    public void setNextAction(Action nextAction) {
        this.nextAction = nextAction;
    }

    public List<AbstractReceipt> getDepreciationReceiptList() {
        if (this.importDepreciationReceipts.isSelected()) {
            return this.receiptsList;
        }
        return null;
    }

    public List<AbstractReceipt> getUnpaidReceiptList() {
        if (this.importUnpaidReceipts.isSelected()) {
            return this.receiptsList;
        }
        return null;
    }

    public List<DepreciationPool> getPoolsList() {
        if (this.importDepreciationReceipts.isSelected()) {
            return this.poolsList;
        }
        return null;
    }
}

