/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.data.FilenameExtensions;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.FilenamePanel;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ImportDepreciationReceiptsPanel
extends AbstractStandardDialogPanel {
    private boolean doImportReceipts;
    private boolean doImportPools;
    private String filename;
    private JCheckBox importReceipts = new JCheckBox(TextPool.getString("importDepreciationReceipts"), true);
    private JCheckBox importPools = new JCheckBox(TextPool.getString("importDepreciationPools"), true);
    private FilenamePanel filenamePanel = new FilenamePanel(new JLabel(String.valueOf(TextPool.getString("labelFilename")) + ":"), FilenameExtensions.fileFilterEurFiles, new File(SettingsManager.getInstance().getLastDirectoryUsed()), TextPool.getString("buttonBrowse"));
    private Action okAction;

    public ImportDepreciationReceiptsPanel() {
        this.setBorder(BorderFactory.createTitledBorder(this.getTitle()));
        this.setLayout(new GridLayout(4, 1, 10, 10));
        this.add(this.importReceipts);
        this.add(this.importPools);
        this.add(this.filenamePanel);
        this.filenamePanel.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateActions(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateActions(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateActions(e);
            }

            private void updateActions(DocumentEvent e) {
                ImportDepreciationReceiptsPanel.this.okAction.setEnabled(e.getDocument().getLength() > 0);
            }
        });
    }

    @Override
    public void saveDialogData() {
        this.doImportReceipts = this.importReceipts.isSelected();
        this.doImportPools = this.importPools.isSelected();
        this.filename = this.filenamePanel.getFilename();
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleDepreciationDataImport");
    }

    @Override
    public void setOkAction(Action okAction) {
        this.okAction = okAction;
        this.okAction.setEnabled(false);
    }

    public boolean doImportReceipts() {
        return this.doImportReceipts;
    }

    public boolean doImportPools() {
        return this.doImportPools;
    }

    public String getFilename() {
        return this.filename;
    }
}

