/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.datetools.gui.DateFormatComboBox;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.actions.ActionCheckForUpdates;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.GuiTools;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class GeneralSettingsPanel
extends AbstractStandardDialogPanel {
    private Frame parent;
    private JCheckBox createBackupFilesInput = new JCheckBox(TextPool.getString("labelSettingsCreateBackupFiles"));
    private JCheckBox lookForUpdatesInput = new JCheckBox(TextPool.getString("labelSettingsLookForUpdates"));
    private JSpinner numLastFilesInput = new JSpinner();
    private DateFormatComboBox dateFormatInput = new DateFormatComboBox();

    public GeneralSettingsPanel(Frame parent) {
        this.parent = parent;
        this.numLastFilesInput.setModel(new SpinnerNumberModel(1, 1, 32, 1));
        this.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleSettingsGeneral")));
        GridBagLayout gbl1 = new GridBagLayout();
        JPanel innerPanel1 = new JPanel(gbl1);
        GuiTools.addComponent(innerPanel1, gbl1, this.createBackupFilesInput, 0, 0, 2, 1, 1.0, 0.0);
        GuiTools.addComponent(innerPanel1, gbl1, this.lookForUpdatesInput, 0, 1, 1, 1, 0.5, 0.0);
        GuiTools.addComponent(innerPanel1, gbl1, new JButton(new ActionCheckForUpdates(this.parent)), 1, 1, 1, 1, 0.5, 0.0);
        GridBagLayout gbl2 = new GridBagLayout();
        JPanel innerPanel2 = new JPanel(gbl2);
        GuiTools.addComponent(innerPanel2, gbl2, new JLabel(TextPool.getString("labelSettingsNumLastFiles")), 0, 0, 1, 1, 0.0, 1.0);
        GuiTools.addComponent(innerPanel2, gbl2, this.numLastFilesInput, 1, 0, 1, 1, 0.0, 1.0);
        GuiTools.addComponent(innerPanel2, gbl2, new JLabel(TextPool.getString("labelSettingsDateFormat")), 0, 1, 1, 1, 0.0, 1.0);
        GuiTools.addComponent(innerPanel2, gbl2, this.dateFormatInput, 1, 1, 2, 1, 0.0, 1.0);
        GridBagLayout gbl = new GridBagLayout();
        JPanel innerPanel = new JPanel(gbl);
        GuiTools.addComponent(innerPanel, gbl, innerPanel1, 0, 0, 1, 1, 0.0, 1.0);
        GuiTools.addComponent(innerPanel, gbl, innerPanel2, 0, 2, 1, 1, 0.0, 1.0);
        this.setLayout(new FlowLayout(0));
        this.add(innerPanel);
    }

    @Override
    public void dialogOpens() {
        this.createBackupFilesInput.setSelected(SettingsManager.getInstance().doCreateBackup());
        this.lookForUpdatesInput.setSelected(SettingsManager.getInstance().doLookForUpdates());
        this.numLastFilesInput.getModel().setValue(SettingsManager.getInstance().getMaxLastFilenames());
        this.dateFormatInput.setSelectedDateFormat(SettingsManager.getInstance().getDateFormat());
    }

    @Override
    public void saveDialogData() {
        SettingsManager.getInstance().setCreateBackup(this.createBackupFilesInput.isSelected());
        SettingsManager.getInstance().setLookForUpdates(this.lookForUpdatesInput.isSelected());
        SettingsManager.getInstance().setMaxLastFilenames((Integer)this.numLastFilesInput.getModel().getValue());
        SettingsManager.getInstance().setDateFormat(this.dateFormatInput.getSelectedDateFormat());
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleSettingsGeneral");
    }
}

