/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.gui.GeneralDataListener;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractSimpleAssistantPanel;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.validators.IntegerValidator;
import de.uwemock.guitools.validators.ValidatorHook;
import java.awt.GridBagLayout;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GeneralDataPanel
extends AbstractSimpleAssistantPanel
implements DocumentListener,
GeneralDataListener {
    private JLabel labelName = new JLabel(TextPool.getString("labelName"));
    private JLabel labelCompany = new JLabel(TextPool.getString("labelCompany"));
    private JLabel labelAddress = new JLabel(TextPool.getString("labelAddress"));
    private JLabel labelTaxId = new JLabel(TextPool.getString("labelTaxId"));
    private JLabel labelBusinessYear = new JLabel(TextPool.getString("labelBusinessYear"));
    private JLabel labelCurrency = new JLabel(TextPool.getString("labelCurrency"));
    private JTextField inputName = new JTextField(40);
    private JTextField inputCompany = new JTextField(40);
    private JTextField inputAddress = new JTextField(40);
    private JTextField inputTaxId = new JTextField(40);
    private JTextField inputBusinessYear = new JTextField(10);
    private JTextField inputCurrency = new JTextField(5);
    private Action nextAction = null;
    private boolean isFinished = false;

    public GeneralDataPanel() {
        this.createComponentTree();
        this.registerValidators();
        this.fillCurrentData();
        DataCenter.getInstance().addGeneralDataListener(this);
    }

    private void createComponentTree() {
        this.inputName.setToolTipText(TextPool.getString("tooltipGeneralName"));
        this.inputCompany.setToolTipText(TextPool.getString("tooltipGeneralCompany"));
        this.inputAddress.setToolTipText(TextPool.getString("tooltipGeneralAddress"));
        this.inputTaxId.setToolTipText(TextPool.getString("tooltipGeneralTaxId"));
        this.inputBusinessYear.setToolTipText(TextPool.getString("tooltipGeneralBusinessYear"));
        this.inputCurrency.setToolTipText(TextPool.getString("tooltipGeneralCurrency"));
        GridBagLayout gl = new GridBagLayout();
        this.setLayout(gl);
        GuiTools.addComponent(this, gl, this.labelName, 0, 0, 1, 1, 0.0, 1.0);
        GuiTools.addComponent(this, gl, this.inputName, 1, 0, 1, 1, 1.0, 1.0);
        GuiTools.addComponent(this, gl, this.labelCompany, 0, 1, 1, 1, 0.0, 1.0);
        GuiTools.addComponent(this, gl, this.inputCompany, 1, 1, 1, 1, 1.0, 1.0);
        GuiTools.addComponent(this, gl, this.labelAddress, 0, 2, 1, 1, 0.0, 1.0);
        GuiTools.addComponent(this, gl, this.inputAddress, 1, 2, 1, 1, 1.0, 1.0);
        GuiTools.addComponent(this, gl, this.labelBusinessYear, 0, 3, 1, 1, 0.0, 1.0);
        GuiTools.addComponent(this, gl, this.inputBusinessYear, 1, 3, 1, 1, 1.0, 1.0);
        GuiTools.addComponent(this, gl, this.labelTaxId, 0, 4, 1, 1, 0.0, 1.0);
        GuiTools.addComponent(this, gl, this.inputTaxId, 1, 4, 1, 1, 1.0, 1.0);
        GuiTools.addComponent(this, gl, this.labelCurrency, 0, 5, 1, 1, 0.0, 1.0);
        GuiTools.addComponent(this, gl, this.inputCurrency, 1, 5, 1, 1, 1.0, 1.0);
        this.inputName.getDocument().addDocumentListener(this);
        this.inputCompany.getDocument().addDocumentListener(this);
        this.inputAddress.getDocument().addDocumentListener(this);
        this.inputTaxId.getDocument().addDocumentListener(this);
        this.inputBusinessYear.getDocument().addDocumentListener(this);
        this.inputCurrency.getDocument().addDocumentListener(this);
    }

    private void fillCurrentData() {
        this.inputName.setText(DataCenter.getInstance().getOwnerName());
        this.inputCompany.setText(DataCenter.getInstance().getOwnerCompany());
        this.inputAddress.setText(DataCenter.getInstance().getOwnerAddress());
        this.inputBusinessYear.setText(Integer.toString(DataCenter.getInstance().getBusinessYear()));
        this.inputTaxId.setText(DataCenter.getInstance().getOwnerTaxId());
        this.inputCurrency.setText(DataCenter.getInstance().getCurrency());
    }

    private void registerValidators() {
        new ValidatorHook(this.inputBusinessYear, new IntegerValidator(3));
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleDataGeneral");
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void setFinished(boolean finished) {
        this.isFinished = finished;
    }

    @Override
    public void setNextAction(Action okAction) {
        this.nextAction = okAction;
        this.contentUpdated();
    }

    private void contentUpdated() {
        boolean inputCurrencyFilled;
        boolean inputNameFilled = this.inputName.getText().length() > 0;
        boolean inputCompanyFilled = this.inputCompany.getText().length() > 0;
        boolean inputAddressFilled = this.inputAddress.getText().length() > 0;
        boolean inputTaxIdFilled = this.inputTaxId.getText().length() > 0;
        boolean inputBusinessYearFilled = this.inputBusinessYear.getText().length() > 0;
        boolean bl = inputCurrencyFilled = this.inputCurrency.getText().length() > 0;
        if (this.nextAction != null) {
            this.nextAction.setEnabled(inputNameFilled && inputCompanyFilled && inputAddressFilled && inputTaxIdFilled && inputBusinessYearFilled && inputCurrencyFilled);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.contentUpdated();
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.contentUpdated();
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.contentUpdated();
    }

    @Override
    public void saveDialogData() {
        String inputName = this.inputName.getText();
        String inputAddress = this.inputAddress.getText();
        String inputCompany = this.inputCompany.getText();
        String inputTaxId = this.inputTaxId.getText();
        int inputBusinessYear = Integer.parseInt(this.inputBusinessYear.getText());
        String inputCurrency = this.inputCurrency.getText();
        DataCenter.getInstance().setOwnerName(inputName);
        DataCenter.getInstance().setOwnerAddress(inputAddress);
        DataCenter.getInstance().setOwnerCompany(inputCompany);
        DataCenter.getInstance().setOwnerTaxId(inputTaxId);
        DataCenter.getInstance().setBusinessYear(inputBusinessYear);
        DataCenter.getInstance().setCurrency(inputCurrency);
    }

    @Override
    public String getInformationText() {
        return TextPool.getString("informationGeneralData");
    }

    @Override
    public void dispose() {
        DataCenter.getInstance().removeGeneralDataListener(this);
    }

    @Override
    public void generalDataChanged() {
        this.fillCurrentData();
    }

    @Override
    public void panelNowShowing(boolean isShowing) {
        if (isShowing) {
            if (this.inputName.getText().isEmpty()) {
                this.inputName.requestFocus();
                return;
            }
            if (this.inputCompany.getText().isEmpty()) {
                this.inputCompany.requestFocus();
                return;
            }
            if (this.inputAddress.getText().isEmpty()) {
                this.inputAddress.requestFocus();
                return;
            }
            if (this.inputTaxId.getText().isEmpty()) {
                this.inputTaxId.requestFocus();
                return;
            }
            if (this.inputBusinessYear.getText().isEmpty()) {
                this.inputBusinessYear.requestFocus();
                return;
            }
            if (this.inputCurrency.getText().isEmpty()) {
                this.inputCurrency.requestFocus();
                return;
            }
        }
    }
}

