/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import chrriis.dj.swingsuite.JComboButton;
import chrriis.dj.swingsuite.JWidePopupComboBox;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.calculation.plugins.AbstractEurPlugin;
import de.uwemock.eur.calculation.plugins.EurPlugin;
import de.uwemock.eur.calculation.plugins.PlainHTMLPlugin;
import de.uwemock.eur.calculation.plugins.PluginLoader;
import de.uwemock.eur.calculation.plugins.PluginsListListener;
import de.uwemock.eur.calculation.plugins.XMLPlugin;
import de.uwemock.eur.calculation.plugins.gui.PluginListRenderer;
import de.uwemock.eur.calculation.plugins.gui.RemotePluginSelectionPanel;
import de.uwemock.eur.calculation.plugins.gui.XMLPluginEditPanel;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.DataProvider;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.actions.ActionImportPlugins;
import de.uwemock.guitools.AbstractSimpleAssistantPanel;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.MoveListItemAction;
import de.uwemock.guitools.MutableListModel;
import de.uwemock.guitools.StandardDialog;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class CalculationPluginEditor
extends AbstractSimpleAssistantPanel
implements PluginsListListener {
    private Frame parent;
    private AccountList accountList;
    private ArrayList<AbstractEurPlugin> pluginList;
    private JList pluginListDisplay;
    private JComboButton newButton;
    private JButton editButton;
    private JButton removeButton;
    private JButton convertXMLtoHTMLButton;
    private JButton loadFromInternetButton;
    private JWidePopupComboBox pluginListSelection;
    private JButton addSelectedPluginButton;
    private JButton importPluginButton;
    private boolean isFinished = false;
    private boolean dataHasChanged = false;
    private static final URL sourceUrl;

    static {
        URL tempUrl = null;
        try {
            tempUrl = new URL("http://dl.dropbox.com/u/2628626/jesplugins/plugins.xml");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        sourceUrl = tempUrl;
    }

    public CalculationPluginEditor(Frame parent, AccountList accountList, Collection<AbstractEurPlugin> pluginList) {
        this.parent = parent;
        this.accountList = accountList;
        if (pluginList != null) {
            this.pluginList = new ArrayList();
            for (AbstractEurPlugin p : pluginList) {
                this.pluginList.add(p.getCopy());
            }
        } else {
            this.pluginList = new ArrayList();
        }
        this.pluginListDisplay = new JList(new MutableListModel(this.pluginList));
        this.pluginListDisplay.setSelectionMode(0);
        this.pluginListDisplay.setBorder(BorderFactory.createEtchedBorder());
        this.pluginListDisplay.setCellRenderer(new PluginListRenderer());
        AbstractAction newHTMLPLuginAction = new AbstractAction(TextPool.getString("buttonNewHTMLPlugin")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PlainHTMLPluginDialog d = new PlainHTMLPluginDialog();
                d.setVisible(true);
                if (d.getPlugin() != null) {
                    ((MutableListModel)CalculationPluginEditor.this.pluginListDisplay.getModel()).addElement(d.getPlugin());
                    CalculationPluginEditor.this.enableButtons();
                    CalculationPluginEditor.this.dataHasChanged = true;
                }
            }
        };
        AbstractAction newXMLPLuginAction = new AbstractAction(TextPool.getString("buttonNewXMLPlugin")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XMLPluginEditPanel panel = new XMLPluginEditPanel(CalculationPluginEditor.this.parent, CalculationPluginEditor.this.accountList, TextPool.getString("labelPluginUnnamed"));
                StandardDialog dialog = new StandardDialog(CalculationPluginEditor.this.parent, TextPool.getString("titleXMLPluginEdit"), panel);
                dialog.setVisible(true);
                if (panel.getPlugin() != null) {
                    ((MutableListModel)CalculationPluginEditor.this.pluginListDisplay.getModel()).addElement(panel.getPlugin());
                    CalculationPluginEditor.this.enableButtons();
                    CalculationPluginEditor.this.dataHasChanged = true;
                }
            }
        };
        JPopupMenu buttonpopup = new JPopupMenu();
        buttonpopup.add(newXMLPLuginAction);
        buttonpopup.add(newHTMLPLuginAction);
        this.newButton = new JComboButton(TextPool.getString("buttonNew"), true);
        this.newButton.setArrowPopupMenu(buttonpopup);
        this.newButton.addActionListener(newXMLPLuginAction);
        this.editButton = new JButton(new AbstractAction(TextPool.getString("buttonEdit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                EurPlugin plugin = (EurPlugin)CalculationPluginEditor.this.pluginListDisplay.getSelectedValue();
                if (plugin != null) {
                    EurPlugin result = null;
                    if (plugin instanceof PlainHTMLPlugin) {
                        PlainHTMLPluginDialog d = new PlainHTMLPluginDialog((PlainHTMLPlugin)plugin);
                        d.setVisible(true);
                        result = d.getPlugin();
                    }
                    if (plugin instanceof XMLPlugin) {
                        XMLPluginEditPanel panel = new XMLPluginEditPanel(CalculationPluginEditor.this.parent, CalculationPluginEditor.this.accountList, (XMLPlugin)plugin);
                        StandardDialog dialog = new StandardDialog(CalculationPluginEditor.this.parent, TextPool.getString("titleXMLPluginEdit"), panel);
                        dialog.setVisible(true);
                        result = panel.getPlugin();
                    }
                    if (result != null) {
                        int index = CalculationPluginEditor.this.pluginListDisplay.getSelectedIndex();
                        MutableListModel m = (MutableListModel)CalculationPluginEditor.this.pluginListDisplay.getModel();
                        m.removeElementAt(index);
                        m.insertElementAt(result, index);
                        CalculationPluginEditor.this.dataHasChanged = true;
                    }
                }
            }
        });
        this.removeButton = new JButton(new AbstractAction(TextPool.getString("buttonRemove")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int index = CalculationPluginEditor.this.pluginListDisplay.getSelectedIndex();
                if (index >= 0) {
                    ((MutableListModel)CalculationPluginEditor.this.pluginListDisplay.getModel()).removeElementAt(index);
                    CalculationPluginEditor.this.enableButtons();
                    CalculationPluginEditor.this.dataHasChanged = true;
                }
            }
        });
        this.convertXMLtoHTMLButton = new JButton(new AbstractAction(TextPool.getString("buttonConvertXMLtoHTMLPlugin")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EurPlugin plugin = (EurPlugin)CalculationPluginEditor.this.pluginListDisplay.getSelectedValue();
                if (plugin != null) {
                    PlainHTMLPlugin result = null;
                    if (plugin instanceof XMLPlugin) {
                        result = new PlainHTMLPlugin(String.valueOf(plugin.getPluginTitle()) + TextPool.getString("pluginTitleConvertedFromXML"), plugin.getPluginContents());
                    }
                    if (result != null) {
                        int index = CalculationPluginEditor.this.pluginListDisplay.getSelectedIndex();
                        MutableListModel m = (MutableListModel)CalculationPluginEditor.this.pluginListDisplay.getModel();
                        m.insertElementAt(result, index + 1);
                        CalculationPluginEditor.this.dataHasChanged = true;
                    }
                }
            }
        });
        this.loadFromInternetButton = new JButton(new AbstractAction(TextPool.getString("buttonLoadPluginsFromInternet")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemotePluginSelectionPanel panel;
                try {
                    panel = new RemotePluginSelectionPanel(CalculationPluginEditor.this.parent, sourceUrl);
                }
                catch (FileNotFoundException ex) {
                    return;
                }
                StandardDialog dialog = new StandardDialog(CalculationPluginEditor.this.parent, TextPool.getString("titleRemotePlugins"), panel);
                dialog.setVisible(true);
                List<EurPlugin> result = panel.getSelectedPlugins();
                if (result != null) {
                    MutableListModel m = (MutableListModel)CalculationPluginEditor.this.pluginListDisplay.getModel();
                    for (EurPlugin plugin : result) {
                        m.addElement(plugin);
                    }
                    CalculationPluginEditor.this.dataHasChanged = true;
                }
            }
        });
        JButton moveUpButton = new JButton(new MoveListItemAction(this.pluginListDisplay, MoveListItemAction.MOVE_UP, TextPool.getString("buttonMoveUp")));
        JButton moveDownButton = new JButton(new MoveListItemAction(this.pluginListDisplay, MoveListItemAction.MOVE_DOWN, TextPool.getString("buttonMoveDown")));
        this.pluginListDisplay.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CalculationPluginEditor.this.enableButtons();
            }
        });
        JPanel buttonPanel = new JPanel(new GridLayout(7, 1, 5, 5));
        buttonPanel.add(this.loadFromInternetButton);
        buttonPanel.add(this.newButton);
        buttonPanel.add(this.editButton);
        buttonPanel.add(this.removeButton);
        buttonPanel.add(this.convertXMLtoHTMLButton);
        buttonPanel.add(moveUpButton);
        buttonPanel.add(moveDownButton);
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add("North", buttonPanel);
        GridBagLayout gbl = new GridBagLayout();
        JPanel topPanel = new JPanel(gbl);
        this.pluginListSelection = new JWidePopupComboBox(DataProvider.pluginCollection.toArray());
        this.addSelectedPluginButton = new JButton(new AbstractAction(TextPool.getString("buttonAddNoDots")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PluginLoader pluginToAdd = (PluginLoader)CalculationPluginEditor.this.pluginListSelection.getSelectedItem();
                if (pluginToAdd == null) {
                    return;
                }
                ((MutableListModel)CalculationPluginEditor.this.pluginListDisplay.getModel()).addElement(pluginToAdd.getPlugin());
                CalculationPluginEditor.this.enableButtons();
                CalculationPluginEditor.this.dataHasChanged = true;
            }
        });
        this.importPluginButton = new JButton(new ActionImportPlugins(this.parent));
        GuiTools.addComponent(topPanel, gbl, this.pluginListSelection, 0, 0, 1, 1, 1.0, 1.0);
        GuiTools.addComponent(topPanel, gbl, this.addSelectedPluginButton, 1, 0, 1, 1, 0.0, 1.0);
        GuiTools.addComponent(topPanel, gbl, this.importPluginButton, 2, 0, 1, 1, 0.0, 1.0);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add("Center", new JScrollPane(this.pluginListDisplay));
        centerPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleAllPlugins")));
        this.setLayout(new BorderLayout(10, 10));
        this.add("Center", centerPanel);
        this.add("East", rightPanel);
        this.add("North", topPanel);
        DataCenter.getInstance().addPluginsListListener(this);
        this.enableButtons();
    }

    private void enableButtons() {
        int sel = this.pluginListDisplay.getSelectedIndex();
        this.editButton.setEnabled(sel >= 0);
        this.removeButton.setEnabled(sel >= 0);
        this.convertXMLtoHTMLButton.setEnabled(sel >= 0 && this.pluginListDisplay.getSelectedValue() instanceof XMLPlugin);
        this.loadFromInternetButton.setEnabled(sourceUrl != null);
    }

    public ArrayList<AbstractEurPlugin> getPluginList() {
        return this.pluginList;
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleSettingsPlugins");
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void setFinished(boolean finished) {
        this.isFinished = finished;
    }

    @Override
    public void saveDialogData() {
        DataCenter.getInstance().setPluginList(this.pluginList);
        if (this.dataHasChanged) {
            DataCenter.getInstance().setDataChanged();
        }
    }

    @Override
    public String getInformationText() {
        return TextPool.getString("informationPluginList");
    }

    @Override
    public boolean mayBeCancelled() {
        if (this.dataHasChanged) {
            int res = JOptionPane.showConfirmDialog(this.parent, TextPool.getString("msgUnsavedData"), TextPool.getString("titleDialogClosing"), 0);
            return res == 0;
        }
        return true;
    }

    @Override
    public void dispose() {
        DataCenter.getInstance().removePluginsListListener(this);
    }

    @Override
    public void pluginsListHasChanged(List<AbstractEurPlugin> plugins) {
        this.pluginList = new ArrayList();
        for (AbstractEurPlugin p : plugins) {
            this.pluginList.add(p.getCopy());
        }
        this.pluginListDisplay.setModel(new MutableListModel(this.pluginList));
    }

    class PlainHTMLPluginDialog
    extends JDialog {
        private JTextField pluginTitleInput;
        private RSyntaxTextArea pluginContents;
        private EurPlugin plugin;

        public PlainHTMLPluginDialog() {
            super(CalculationPluginEditor.this.parent, TextPool.getString("titleNewTax"));
            this.pluginTitleInput = new JTextField(40);
            this.pluginContents = new RSyntaxTextArea();
            this.plugin = null;
            this.setModal(true);
            this.pluginContents.setSyntaxEditingStyle("text/html");
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new BorderLayout(10, 10));
            topPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("labelPluginTitle")));
            topPanel.add("Center", this.pluginTitleInput);
            JPanel buttonPanel = new JPanel(new FlowLayout(1));
            buttonPanel.add(new JButton(new AbstractAction(TextPool.getString("buttonOk")){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PlainHTMLPluginDialog.this.plugin = new PlainHTMLPlugin(PlainHTMLPluginDialog.this.pluginTitleInput.getText(), new StringBuffer(PlainHTMLPluginDialog.this.pluginContents.getText()));
                    PlainHTMLPluginDialog.this.dispose();
                }
            }));
            buttonPanel.add(new JButton(new AbstractAction(TextPool.getString("buttonCancel")){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PlainHTMLPluginDialog.this.dispose();
                }
            }));
            JPanel centerPanel = new JPanel(new BorderLayout(10, 10));
            centerPanel.add("Center", new RTextScrollPane(this.pluginContents){

                @Override
                public Dimension getMinimumSize() {
                    return new Dimension(400, 300);
                }

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(400, 300);
                }
            });
            centerPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("labelPluginContents")));
            this.setLayout(new BorderLayout());
            this.add("North", topPanel);
            this.add("Center", centerPanel);
            this.add("South", buttonPanel);
            this.pack();
            this.setLocationRelativeTo(CalculationPluginEditor.this);
        }

        public PlainHTMLPluginDialog(PlainHTMLPlugin plugin) {
            this();
            this.pluginTitleInput.setText(plugin.getPluginTitle());
            this.pluginContents.setText(plugin.getPluginContents().toString());
            this.pack();
            this.setLocationRelativeTo(calculationPluginEditor);
        }

        public EurPlugin getPlugin() {
            return this.plugin;
        }
    }
}

