/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.GuiTools;
import java.awt.BorderLayout;
import java.awt.Desktop;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class BrowserSettingsPanel
extends AbstractStandardDialogPanel
implements ActionListener {
    private JRadioButton useDesktopBrowserButton;
    private JRadioButton useOtherBrowserButton;
    private ButtonGroup group;
    private JTextField otherBrowserPathInput;
    private JButton searchOtherBrowserButton;

    public BrowserSettingsPanel() {
        this.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleSettingsBrowser")));
        this.useDesktopBrowserButton = new JRadioButton(TextPool.getString("buttonUseDesktopBrowser"));
        this.useDesktopBrowserButton.addActionListener(this);
        this.useOtherBrowserButton = new JRadioButton(TextPool.getString("buttonUseOtherBrowser"));
        this.useOtherBrowserButton.addActionListener(this);
        this.group = new ButtonGroup();
        this.group.add(this.useDesktopBrowserButton);
        this.group.add(this.useOtherBrowserButton);
        this.otherBrowserPathInput = new JTextField(40);
        this.searchOtherBrowserButton = GuiTools.getBrowseButton(this, this.otherBrowserPathInput, null, null, TextPool.getString("buttonBrowse"));
        JPanel otherBrowserPanel = new JPanel(new BorderLayout(10, 0));
        otherBrowserPanel.add("West", Box.createHorizontalGlue());
        otherBrowserPanel.add("Center", this.otherBrowserPathInput);
        otherBrowserPanel.add("East", this.searchOtherBrowserButton);
        this.setLayout(new GridLayout(3, 1, 0, 10));
        this.add(this.useDesktopBrowserButton);
        this.add(this.useOtherBrowserButton);
        this.add(otherBrowserPanel);
    }

    @Override
    public void dialogOpens() {
        this.otherBrowserPathInput.setText(SettingsManager.getInstance().getBrowserPath());
        this.group.setSelected(this.useDesktopBrowserButton.getModel(), SettingsManager.getInstance().doUseDesktopBrowser());
        this.group.setSelected(this.useOtherBrowserButton.getModel(), !SettingsManager.getInstance().doUseDesktopBrowser());
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            this.useDesktopBrowserButton.setEnabled(false);
            this.group.setSelected(this.useDesktopBrowserButton.getModel(), false);
            this.useOtherBrowserButton.setEnabled(true);
            this.group.setSelected(this.useOtherBrowserButton.getModel(), true);
        }
        this.setComponentStates();
    }

    private void setComponentStates() {
        this.otherBrowserPathInput.setEnabled(this.useOtherBrowserButton.isSelected());
        this.searchOtherBrowserButton.setEnabled(this.useOtherBrowserButton.isSelected());
    }

    @Override
    public void saveDialogData() {
        SettingsManager.getInstance().setUseDesktopBrowser(this.useDesktopBrowserButton.isSelected());
        SettingsManager.getInstance().setBrowserPath(this.otherBrowserPathInput.getText());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setComponentStates();
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleSettingsBrowser");
    }
}

