/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.GuiTools;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class AutoSaveSettingsPanel
extends AbstractStandardDialogPanel {
    private JSpinner autoSaveMinutesInput = new JSpinner();
    private JRadioButton autoSaveModeRealSave = new JRadioButton(TextPool.getString("labelSettingsAutoSaveModeRealSave"));
    private JRadioButton autoSaveModeRecoveryOnly = new JRadioButton(TextPool.getString("labelSettingsAutoSaveModeRecoveryOnly"));

    public AutoSaveSettingsPanel() {
        this.autoSaveMinutesInput.setModel(new SpinnerNumberModel(5, 0, 90, 1));
        ButtonGroup autoSaveButtons = new ButtonGroup();
        autoSaveButtons.add(this.autoSaveModeRealSave);
        autoSaveButtons.add(this.autoSaveModeRecoveryOnly);
        GridBagLayout gbl = new GridBagLayout();
        JPanel innerPanel = new JPanel(gbl);
        GuiTools.addComponent(innerPanel, gbl, new JLabel(TextPool.getString("labelSettingsAutoSaveMinutes1")), 0, 0, 1, 1, 0.0, 1.0);
        GuiTools.addComponent(innerPanel, gbl, this.autoSaveMinutesInput, 1, 0, 1, 1, 0.0, 1.0);
        GuiTools.addComponent(innerPanel, gbl, new JLabel(TextPool.getString("labelSettingsAutoSaveMinutes2")), 2, 0, 1, 1, 0.0, 1.0);
        GuiTools.addComponent(innerPanel, gbl, this.autoSaveModeRealSave, 0, 1, 3, 1, 0.0, 1.0);
        GuiTools.addComponent(innerPanel, gbl, this.autoSaveModeRecoveryOnly, 0, 2, 3, 1, 0.0, 1.0);
        this.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleSettingsAutoSave")));
        this.setLayout(new FlowLayout(0));
        this.add(innerPanel);
    }

    @Override
    public void dialogOpens() {
        this.autoSaveMinutesInput.getModel().setValue(SettingsManager.getInstance().getAutoSaveDelay());
        this.autoSaveModeRealSave.setSelected(SettingsManager.getInstance().getAutoSaveMode() == SettingsManager.AutoSaveMode.REAL_SAVE);
        this.autoSaveModeRecoveryOnly.setSelected(SettingsManager.getInstance().getAutoSaveMode() == SettingsManager.AutoSaveMode.RECOVERY_ONLY);
    }

    @Override
    public void saveDialogData() {
        SettingsManager.getInstance().setAutoSaveDelay((Integer)this.autoSaveMinutesInput.getModel().getValue());
        if (this.autoSaveModeRealSave.isSelected()) {
            SettingsManager.getInstance().setAutoSaveMode(SettingsManager.AutoSaveMode.REAL_SAVE);
        }
        if (this.autoSaveModeRecoveryOnly.isSelected()) {
            SettingsManager.getInstance().setAutoSaveMode(SettingsManager.AutoSaveMode.RECOVERY_ONLY);
        }
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleSettingsAutoSave");
    }
}

