/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;

public class AttachmentSettingsPanel
extends AbstractStandardDialogPanel {
    private final String[] sizeList = new String[]{"0.5", "1.0", "1.5", "2.0", "2.5", "3.0", "3.5", "4.0", "4.5", "5.0", "5.5", "6.0", "6.5", "7.0", "7.5", "8.0", "8.5", "9.0", "9.5", "10.0", "10.5", "11.0", "11.5", "12.0", "12.5", "13.0", "13.5", "14.0", "14.5", "15.0", "15.5", "16.0"};
    private JCheckBox allowAttachments = new JCheckBox(TextPool.getString("labelSettingsAllowAttachments"));
    private JSpinner attachmentWarningSizeInput;

    public AttachmentSettingsPanel() {
        this.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleAttachments")));
        SpinnerListModel model = new SpinnerListModel(this.sizeList);
        this.attachmentWarningSizeInput = new JSpinner(model){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width *= 2;
                return size;
            }
        };
        JPanel innerPanel = new JPanel(new FlowLayout(0));
        innerPanel.add(new JLabel(TextPool.getString("labelSettingsAttachmentWarningSize")));
        innerPanel.add(Box.createHorizontalStrut(6));
        innerPanel.add(this.attachmentWarningSizeInput);
        innerPanel.add(Box.createHorizontalStrut(2));
        innerPanel.add(new JLabel(TextPool.getString("labelSettingsAttachmentWarningSizeMegabytes")));
        GridLayout box = new GridLayout(2, 1);
        this.setLayout(box);
        this.add(this.allowAttachments);
        this.add((Component)innerPanel, "Center");
        this.allowAttachments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AttachmentSettingsPanel.this.enableControls();
            }
        });
    }

    private void enableControls() {
        this.attachmentWarningSizeInput.setEnabled(this.allowAttachments.isSelected());
    }

    @Override
    public void dialogOpens() {
        this.allowAttachments.setSelected(SettingsManager.getInstance().attachmentsAllowed());
        int sizeIndex = SettingsManager.getInstance().getAttachmentWarningSize() / 1024 / 512 - 1;
        this.attachmentWarningSizeInput.getModel().setValue(this.sizeList[sizeIndex]);
        this.enableControls();
    }

    @Override
    public void saveDialogData() {
        SettingsManager.getInstance().setAttachmentsAllowed(this.allowAttachments.isSelected());
        int warningSize = 0x100000;
        Object selectedItem = this.attachmentWarningSizeInput.getModel().getValue();
        int i = 0;
        while (i < this.sizeList.length) {
            if (selectedItem.equals(this.sizeList[i])) {
                warningSize = (512 + i * 512) * 1024;
            }
            ++i;
        }
        SettingsManager.getInstance().setAttachmentWarningSize(warningSize);
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleAttachments");
    }
}

