/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.accounts.gui.AccountListBox;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AccountMultiSelectionPanel
extends AbstractStandardDialogPanel {
    private AccountListBox accountSelection;
    private Action okAction;
    private Account[] selectedAccounts = null;
    private JCheckBox allAccounts = new JCheckBox(TextPool.getString("labelAllAccounts"));

    public AccountMultiSelectionPanel(JFrame parent) {
        AccountList accountList = DataCenter.getInstance().getAccountList();
        this.accountSelection = new AccountListBox(accountList);
        this.accountSelection.setVisibleRowCount(10);
        this.allAccounts.setSelected(true);
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.accountSelection));
        this.add("South", this.allAccounts);
        this.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleAccountSelectionDialog")));
        this.allAccounts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AccountMultiSelectionPanel.this.enableListBox();
                AccountMultiSelectionPanel.this.enableOkAction();
            }
        });
        this.accountSelection.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AccountMultiSelectionPanel.this.enableOkAction();
            }
        });
    }

    @Override
    public void dialogOpens() {
        this.enableListBox();
        this.enableOkAction();
    }

    private void enableListBox() {
        this.accountSelection.setEnabled(!this.allAccounts.isSelected());
    }

    private void enableOkAction() {
        int numSelected = this.accountSelection.getSelectedAccounts().length;
        this.okAction.setEnabled(numSelected > 0 || this.allAccounts.isSelected());
    }

    @Override
    public void saveDialogData() {
        this.selectedAccounts = this.accountSelection.getSelectedAccounts();
        if (this.selectedAccounts.length == 0 || this.allAccounts.isSelected()) {
            this.selectedAccounts = null;
        }
    }

    public Account[] getSelectedAccounts() {
        if (this.allAccounts.isSelected()) {
            return null;
        }
        return this.selectedAccounts;
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleAccountSelectionDialog");
    }

    @Override
    public void setOkAction(Action okAction) {
        this.okAction = okAction;
    }
}

