/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui;

import chrriis.dj.swingsuite.JWidePopupComboBox;
import chrriis.dj.swingsuite.SwingSuiteUtilities;
import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.accounts.gui.AccountComboBox;
import de.uwemock.eur.accounts.gui.AccountTableModel;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.DataProvider;
import de.uwemock.eur.depreciation.DecliningBalanceDepreciationStrategy;
import de.uwemock.eur.depreciation.DefaultDepreciationStrategy;
import de.uwemock.eur.depreciation.ExtraDepreciation;
import de.uwemock.eur.depreciation.PoolDepreciationStrategy;
import de.uwemock.eur.gui.AccountListListener;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.actions.ActionAccountsList;
import de.uwemock.eur.gui.actions.ActionCorrectAccountList;
import de.uwemock.eur.gui.actions.ActionImportAccountSettings;
import de.uwemock.eur.receipt.DepreciationPool;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.guitools.AbstractSimpleAssistantPanel;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.StandardDialog;
import de.uwemock.guitools.validators.IntegerValidator;
import de.uwemock.guitools.validators.ValidatorHook;
import de.uwemock.settings.SettingsCluster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class AccountListEditor
extends AbstractSimpleAssistantPanel
implements AccountListListener {
    private Frame parent;
    private AccountList accountList;
    private JScrollPane accountListDisplayScroller;
    private JTable accountListDisplay;
    private JButton addButton;
    private JButton removeButton;
    private JButton displayButton;
    private JWidePopupComboBox accountListSelection;
    private JButton applySelectedAccountListButton;
    private JButton supplementAccountListButton;
    private JButton importAccountListButton;
    private boolean isFinished = false;
    private boolean listHasChanged = false;
    private Collection<Integer> accountsUsed;
    private Action okAction = null;
    private String[] accountTypes = new String[]{TextPool.getString("accountTypeSpending"), TextPool.getString("accountTypeIncome"), TextPool.getString("accountTypeSpendingTax"), TextPool.getString("accountTypeIncomeTax")};
    private int[] accountTypeValues = new int[]{1, 2, 5, 6};
    private HashMap<SettingsCluster, Integer> changeDefaultAccoutTo = new HashMap();

    public AccountListEditor(Frame parent, AccountList accountList) {
        this.parent = parent;
        if (accountList != null) {
            this.accountList = new AccountList();
            for (Account a : accountList) {
                this.accountList.add((Account)a.clone());
            }
        } else {
            this.accountList = new AccountList();
        }
        this.accountsUsed = this.getUsedAccounts();
        this.accountListDisplay = new JTable(){

            @Override
            public TableCellEditor getCellEditor(int row, int col) {
                JComboBox box;
                TableCellEditor editor = super.getCellEditor(row, col);
                if (col == 2 && (box = (JComboBox)editor.getTableCellEditorComponent(this, null, true, row, col)) != null) {
                    int type = ((Account)AccountListEditor.this.accountList.get(row)).getAccountType();
                    int i = 0;
                    while (i < AccountListEditor.this.accountTypeValues.length) {
                        if (type == AccountListEditor.this.accountTypeValues[i]) {
                            box.setSelectedIndex(i);
                            break;
                        }
                        ++i;
                    }
                }
                return editor;
            }
        };
        this.accountListDisplayScroller = new JScrollPane(this.accountListDisplay);
        this.setNewAccountList(this.accountList, this.accountsUsed);
        DataCenter.getInstance().addAccountListListener(this);
        this.addButton = new JButton(new AbstractAction(TextPool.getString("buttonAdd")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AccountDialogPanel d = new AccountDialogPanel();
                StandardDialog sd = new StandardDialog(AccountListEditor.this.parent, TextPool.getString("titleNewAccount"), d);
                sd.setVisible(true);
                if (d.getAccount() != null) {
                    ((AccountTableModel)AccountListEditor.this.accountListDisplay.getModel()).addItem(d.getAccount());
                }
            }
        });
        this.removeButton = new JButton(new AbstractAction(TextPool.getString("buttonRemove")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AccountListEditor.this.removeSelectedAccount();
            }
        });
        this.displayButton = new JButton(new ActionAccountsList(this.accountList));
        this.displayButton.setText(TextPool.getString("buttonDisplayPrintAccountsList"));
        this.accountListDisplay.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AccountListEditor.this.enableButtons();
            }
        });
        this.accountListDisplay.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AccountListEditor.this.enableButtons();
            }
        });
        JPanel buttonPanel = new JPanel(new GridLayout(4, 1, 5, 5));
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.removeButton);
        buttonPanel.add(this.displayButton);
        boolean unassignedAccountFound = false;
        for (Account a : this.accountList) {
            if ((a.getAccountType() & 3) != 0) continue;
            unassignedAccountFound = true;
            break;
        }
        if (unassignedAccountFound) {
            buttonPanel.add(new JButton(new ActionCorrectAccountList(this, this.accountList, (AccountTableModel)this.accountListDisplay.getModel())));
        }
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add("North", buttonPanel);
        GridBagLayout gbl = new GridBagLayout();
        JPanel topPanel = new JPanel(gbl);
        this.accountListSelection = new JWidePopupComboBox(DataProvider.accountListCollection.toArray());
        this.applySelectedAccountListButton = new JButton(new AbstractAction(TextPool.getString("buttonApply")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AccountList newAccountList = (AccountList)AccountListEditor.this.accountListSelection.getSelectedItem();
                if (newAccountList == null) {
                    return;
                }
                int res = JOptionPane.showConfirmDialog(AccountListEditor.this, TextPool.getString("msgApplyAccountList"), TextPool.getString("titleApplyAccountList"), 0);
                if (res == 0) {
                    AccountListEditor.this.accountList = newAccountList;
                    ((AccountTableModel)AccountListEditor.this.accountListDisplay.getModel()).setAccountList(newAccountList, AccountListEditor.this.accountsUsed);
                    AccountListEditor.this.enableButtons();
                    newAccountList.setDefaultAccounts();
                }
            }
        });
        this.supplementAccountListButton = new JButton(new AbstractAction(TextPool.getString("buttonSupplement")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AccountList newAccountList = (AccountList)AccountListEditor.this.accountListSelection.getSelectedItem();
                if (newAccountList == null) {
                    return;
                }
                int res = JOptionPane.showConfirmDialog(AccountListEditor.this, TextPool.getString("msgSupplementAccountList"), TextPool.getString("titleSupplementAccountList"), 0);
                if (res == 0) {
                    for (Account account : newAccountList) {
                        if (AccountListEditor.this.accountList.getByAccountNumber(account.getAccountNumber()) != null) continue;
                        AccountListEditor.this.accountList.add(account);
                    }
                    Collections.sort(AccountListEditor.this.accountList);
                    ((AccountTableModel)AccountListEditor.this.accountListDisplay.getModel()).fireTableDataChanged();
                    AccountListEditor.this.enableButtons();
                    AccountListEditor.this.listHasChanged = true;
                }
            }
        });
        this.importAccountListButton = new JButton(new ActionImportAccountSettings(this.parent));
        GuiTools.addComponent(topPanel, gbl, this.accountListSelection, 0, 0, 1, 1, 1.0, 1.0);
        GuiTools.addComponent(topPanel, gbl, this.accountsUsed.size() > 0 ? this.supplementAccountListButton : this.applySelectedAccountListButton, 1, 0, 1, 1, 0.0, 1.0);
        GuiTools.addComponent(topPanel, gbl, this.importAccountListButton, 2, 0, 1, 1, 0.0, 1.0);
        this.setLayout(new BorderLayout(10, 10));
        this.add("Center", this.accountListDisplayScroller);
        this.add("East", rightPanel);
        this.add("North", topPanel);
        this.listHasChanged = false;
        this.enableButtons();
    }

    private void setNewAccountList(AccountList list, Collection<Integer> accountsUsed) {
        this.listHasChanged = true;
        this.accountList = list;
        this.accountsUsed = accountsUsed;
        AccountTableModel model = new AccountTableModel(this.accountList, this.accountsUsed);
        this.accountListDisplay.setModel(model);
        JComboBox<String> typeSelector = new JComboBox<String>(this.accountTypes);
        TableColumn typeColumn = this.accountListDisplay.getColumnModel().getColumn(2);
        typeColumn.setCellEditor(new DefaultCellEditor(typeSelector));
        typeColumn.setCellRenderer(new TableCellRenderer(){
            private JLabel label = new JLabel();
            private DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Account a = (Account)AccountListEditor.this.accountList.get(row);
                switch (a.getAccountType()) {
                    case 2: {
                        this.label.setText(TextPool.getString("accountTypeIncome"));
                        break;
                    }
                    case 1: {
                        this.label.setText(TextPool.getString("accountTypeSpending"));
                        break;
                    }
                    case 6: {
                        this.label.setText(TextPool.getString("accountTypeIncomeTax"));
                        break;
                    }
                    case 5: {
                        this.label.setText(TextPool.getString("accountTypeSpendingTax"));
                        break;
                    }
                    case 4: {
                        this.label.setText(TextPool.getString("accountTypeTax"));
                    }
                }
                this.label.setOpaque(true);
                this.label.setForeground(this.dtcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column).getForeground());
                this.label.setBackground(this.dtcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column).getBackground());
                return this.label;
            }
        });
        SwingSuiteUtilities.autoFitTableColumns(this.accountListDisplay, Integer.MAX_VALUE);
    }

    private void removeSelectedAccount() {
        int index = this.accountListDisplay.getSelectedRow();
        if (index < 0) {
            return;
        }
        AccountTableModel model = (AccountTableModel)this.accountListDisplay.getModel();
        Account accountToDelete = model.getAccount(index);
        SettingsCluster[] clusterList = new SettingsCluster[]{DefaultDepreciationStrategy.getSettingsCluster(), DecliningBalanceDepreciationStrategy.getSettingsCluster(), PoolDepreciationStrategy.getSettingsCluster(), ExtraDepreciation.getSettingsCluster()};
        String[] titlesList = new String[]{TextPool.getString("titleDepreciationLinear"), TextPool.getString("titleDepreciationDeclining"), TextPool.getString("titleDepreciationPool"), TextPool.getString("titleDepreciationExtra")};
        int i = 0;
        while (i < clusterList.length) {
            int defaultAccountNumber;
            SettingsCluster cluster = clusterList[i];
            String title = titlesList[i];
            Number defaultAccount = (Number)cluster.getSettingValue("defaultAccount");
            if (defaultAccount != null && (defaultAccountNumber = defaultAccount.intValue()) == accountToDelete.getAccountNumber()) {
                AccountList tempAccountList = (AccountList)this.accountList.clone();
                Iterator iterator = tempAccountList.iterator();
                while (iterator.hasNext()) {
                    if (((Account)iterator.next()).getAccountNumber() != defaultAccountNumber) continue;
                    iterator.remove();
                }
                AccountComboBox accountSelection = new AccountComboBox(tempAccountList);
                String message = String.format(TextPool.getString("msgDeletingDefaultAccountFor"), title);
                JPanel displayPanel = new JPanel(new BorderLayout(0, 10));
                displayPanel.add((Component)new JLabel(message), "North");
                displayPanel.add((Component)accountSelection, "South");
                JOptionPane.showMessageDialog(this, displayPanel, TextPool.getString("titleDeletingDefaultAccountFor"), 2);
                if (accountSelection.getSelectedAccount() != null) {
                    this.changeDefaultAccoutTo.put(cluster, accountSelection.getSelectedAccountNumber());
                } else {
                    return;
                }
            }
            ++i;
        }
        model.removeItem(index);
        this.enableButtons();
    }

    private void enableButtons() {
        int sel = this.accountListDisplay.getSelectedRow();
        Account account = ((AccountTableModel)this.accountListDisplay.getModel()).getAccount(sel);
        this.removeButton.setEnabled(sel >= 0 && account != null && !this.isAccountUsed(account));
        if (this.okAction != null) {
            this.okAction.setEnabled(this.accountListDisplay.getModel().getRowCount() > 0);
        }
        this.importAccountListButton.setEnabled(this.accountsUsed.size() == 0);
    }

    public AccountList getAccountList() {
        return this.accountList;
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleDataAccounts");
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void setFinished(boolean finished) {
        this.isFinished = finished;
    }

    @Override
    public void setNextAction(Action okAction) {
        this.okAction = okAction;
    }

    @Override
    public void saveDialogData() {
        if (this.listHasChanged || ((AccountTableModel)this.accountListDisplay.getModel()).hasChanged()) {
            DataCenter.getInstance().setAccountList(this.accountList);
            for (Map.Entry<SettingsCluster, Integer> entry : this.changeDefaultAccoutTo.entrySet()) {
                SettingsCluster cluster = entry.getKey();
                Integer accountNumber = entry.getValue();
                cluster.setSettingValue("defaultAccount", accountNumber);
            }
            Integer currentYear = DataCenter.getInstance().getBusinessYear();
            List<Integer> poolYears = PoolManager.getInstance().getContainedYears();
            if (poolYears.contains(currentYear)) {
                DepreciationPool currentPool = PoolManager.getInstance().getCurrentDepreciationPool();
                int newDefaultAccount = ((Number)PoolDepreciationStrategy.getSettingsCluster().getSettingValue("defaultAccount")).intValue();
                currentPool.setAccount(newDefaultAccount);
            }
            DataCenter.getInstance().setDataChanged();
        }
    }

    @Override
    public boolean mayBeCancelled() {
        if (this.listHasChanged || ((AccountTableModel)this.accountListDisplay.getModel()).hasChanged()) {
            int res = JOptionPane.showConfirmDialog(this.parent, TextPool.getString("msgUnsavedData"), TextPool.getString("titleDialogClosing"), 0);
            return res == 0;
        }
        return true;
    }

    @Override
    public String getInformationText() {
        return TextPool.getString("informationAccountList");
    }

    @Override
    public void dispose() {
        DataCenter.getInstance().removeAccountListListener(this);
    }

    @Override
    public void accountListHasChanged(AccountList accountList) {
        if (accountList != null) {
            this.accountList = new AccountList();
            for (Account a : accountList) {
                this.accountList.add((Account)a.clone());
            }
        } else {
            this.accountList = new AccountList();
        }
        this.accountsUsed = this.getUsedAccounts();
        this.setNewAccountList(this.accountList, this.accountsUsed);
        this.enableButtons();
    }

    private Collection<Integer> getUsedAccounts() {
        Collection<Integer> usedAccounts = ReceiptGroupManager.getInstance().getAllAccounts();
        usedAccounts.addAll(PoolManager.getInstance().getAllAccounts());
        return usedAccounts;
    }

    private boolean isAccountUsed(int accountNumber) {
        if (this.accountsUsed == null) {
            return true;
        }
        return this.accountsUsed.contains(accountNumber);
    }

    private boolean isAccountUsed(Account account) {
        return this.isAccountUsed(account.getAccountNumber());
    }

    class AccountDialogPanel
    extends AbstractStandardDialogPanel
    implements DocumentListener {
        private JTextField accountNumber = new JTextField(40);
        private JTextField accountDescription = new JTextField(40);
        private JComboBox accountType;
        private Action okAction;
        private Account account;

        public AccountDialogPanel() {
            this.accountType = new JComboBox<String>(AccountListEditor.this.accountTypes);
            this.account = null;
            this.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleNewAccount")));
            GridBagLayout gbl = new GridBagLayout();
            this.setLayout(gbl);
            GuiTools.addComponent(this, gbl, new JLabel(TextPool.getString("labelAccountNumber")), 0, 0, 1, 1, 1.0, 1.0);
            GuiTools.addComponent(this, gbl, new JLabel(TextPool.getString("labelDescription")), 0, 1, 1, 1, 1.0, 1.0);
            GuiTools.addComponent(this, gbl, new JLabel(TextPool.getString("labelAccountType")), 0, 2, 1, 1, 1.0, 1.0);
            GuiTools.addComponent(this, gbl, this.accountNumber, 1, 0, 1, 1, 1.0, 1.0);
            GuiTools.addComponent(this, gbl, this.accountDescription, 1, 1, 1, 1, 1.0, 1.0);
            GuiTools.addComponent(this, gbl, this.accountType, 1, 2, 1, 1, 1.0, 1.0);
            this.accountNumber.getDocument().addDocumentListener(this);
            this.accountDescription.getDocument().addDocumentListener(this);
            new ValidatorHook(this.accountNumber, new IntegerValidator(2));
        }

        private void enableButtons() {
            int number = -1;
            try {
                number = Integer.parseInt(this.accountNumber.getText());
            }
            catch (NumberFormatException e) {
                this.okAction.setEnabled(false);
                return;
            }
            if (number <= 0) {
                this.okAction.setEnabled(false);
                return;
            }
            if (AccountListEditor.this.accountList.getByAccountNumber(number) != null) {
                this.okAction.setEnabled(false);
                return;
            }
            if (this.accountDescription.getText().isEmpty()) {
                this.okAction.setEnabled(false);
                return;
            }
            this.okAction.setEnabled(true);
        }

        public Account getAccount() {
            return this.account;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.enableButtons();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.enableButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.enableButtons();
        }

        @Override
        public void dialogOpens() {
            this.enableButtons();
        }

        @Override
        public void saveDialogData() {
            int type = 2;
            String typeText = this.accountType.getSelectedItem().toString();
            int i = 0;
            while (i < AccountListEditor.this.accountTypes.length) {
                if (typeText.equals(AccountListEditor.this.accountTypes[i])) {
                    type = AccountListEditor.this.accountTypeValues[i];
                    break;
                }
                ++i;
            }
            this.account = new Account(Integer.parseInt(this.accountNumber.getText()), this.accountDescription.getText(), true, type);
        }

        @Override
        public String getTitle() {
            return TextPool.getString("titleNewAccount");
        }

        @Override
        public void setOkAction(Action okAction) {
            this.okAction = okAction;
        }
    }
}

