/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation.gui;

import de.uwemock.eur.depreciation.DepreciationRecord;
import de.uwemock.eur.depreciation.PoolDepreciationStrategy;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.tools.Numbers;
import java.math.BigDecimal;
import javax.swing.table.DefaultTableModel;

public class PoolDepreciationTableModel
extends DefaultTableModel {
    private static final String[] COLUMNS_POOL_DEPRECIATION = TextPool.getArray("COLUMNS_POOL_DEPRECIATION");
    private PoolDepreciationStrategy strategy;
    private int currentYear;

    public PoolDepreciationTableModel(int currentYear, PoolDepreciationStrategy strategy) {
        this.strategy = strategy;
        this.currentYear = currentYear;
    }

    @Override
    public int getColumnCount() {
        return COLUMNS_POOL_DEPRECIATION.length;
    }

    @Override
    public int getRowCount() {
        if (this.strategy != null) {
            return this.strategy.getNumYears();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DepreciationRecord dr = this.strategy.getDepreciationRecord(rowIndex);
        switch (columnIndex) {
            case 0: {
                return dr.getYear();
            }
            case 1: {
                return dr.getPercentAmount();
            }
            case 2: {
                return dr.getPercentTax();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        assert (columnIndex > 0) : "Changing column 0 in DepreciationTableModel";
        BigDecimal newValue = null;
        if (aValue == null || "".equals(aValue.toString())) {
            return;
        }
        try {
            if (aValue instanceof BigDecimal) {
                newValue = (BigDecimal)aValue;
            }
            if (aValue instanceof String) {
                newValue = new BigDecimal(((String)aValue).replace(",", "."));
            }
            if (aValue instanceof Double) {
                newValue = new BigDecimal(((Double)aValue).intValue());
            }
        }
        catch (Exception e) {
            return;
        }
        if (newValue != null && !Numbers.isNegative(newValue)) {
            DepreciationRecord dr = this.strategy.getDepreciationRecord(rowIndex);
            BigDecimal oldValue = null;
            if (columnIndex == 1) {
                oldValue = dr.getPercentAmount();
                dr.setPercentAmount(newValue);
            }
            if (columnIndex == 2) {
                oldValue = dr.getPercentTax();
                dr.setPercentTax(newValue);
            }
            this.strategy.calculateLastYear();
            DepreciationRecord drLast = this.strategy.getDepreciationRecord(this.strategy.getNumYears() - 1);
            if (columnIndex == 1 && Numbers.isNegative(drLast.getPercentAmount())) {
                dr.setPercentAmount(oldValue);
                this.strategy.calculateLastYear();
            }
            if (columnIndex == 2 && Numbers.isNegative(drLast.getPercentTax())) {
                dr.setPercentTax(oldValue);
                this.strategy.calculateLastYear();
            }
        }
        this.dataChanged();
    }

    public DepreciationRecord getItemAt(int rowIndex) {
        return this.strategy.getDepreciationRecord(rowIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNS_POOL_DEPRECIATION[columnIndex];
    }

    public void dataChanged() {
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0 || rowIndex >= this.strategy.getNumYears() - 1) {
            return false;
        }
        return this.strategy.getDepreciationRecord(rowIndex).getYear() >= this.currentYear;
    }
}

