/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation.gui;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.gui.AccountComboBox;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.ExtraDepreciation;
import de.uwemock.eur.depreciation.PoolDepreciationStrategy;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.DepreciationPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class PoolDepreciationEditPanel
extends AbstractStandardDialogPanel {
    private int currentYear;
    private PoolDepreciationStrategy strategy;
    private JSpinner depreciationYears;
    private AccountComboBox accountInput;
    private AbstractReceipt receipt;

    public PoolDepreciationEditPanel(int currentYear, AbstractReceipt receipt) {
        this.currentYear = currentYear;
        this.receipt = receipt;
        this.strategy = (PoolDepreciationStrategy)this.receipt.getDepreciationStrategy();
        this.createComponentTree();
        this.doLayout();
    }

    private void createComponentTree() {
        this.depreciationYears = new JSpinner(new SpinnerNumberModel(this.strategy.getNumYears(), this.currentYear - this.strategy.getStartYear() + 1, 50, 1));
        JPanel yearsPanel = new JPanel(new BorderLayout());
        yearsPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleDepreciationYears")));
        yearsPanel.add((Component)new JLabel(TextPool.getString("labelDepreciationYears1")), "West");
        yearsPanel.add((Component)this.depreciationYears, "Center");
        yearsPanel.add((Component)new JLabel(TextPool.getString("labelDepreciationYears2")), "East");
        this.accountInput = new AccountComboBox(DataCenter.getInstance().getAccountList());
        int defaultAccount = (Integer)ExtraDepreciation.getSettingsCluster().getSettingValue("defaultAccount");
        this.accountInput.setSelectedAccount(defaultAccount);
        Collection<Integer> receiptAccounts = this.receipt.accountNumbersAddedTo();
        for (Integer i : receiptAccounts) {
            this.accountInput.setSelectedAccount(i);
        }
        JPanel accountPanel = new JPanel(new BorderLayout());
        accountPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleAccountSelectionDialog")));
        accountPanel.add((Component)this.accountInput, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)accountPanel, "North");
        this.add((Component)yearsPanel, "South");
    }

    public DepreciationStrategy getDepreciationStrategy() {
        return this.strategy;
    }

    @Override
    public void saveDialogData() {
        int years = (Integer)this.depreciationYears.getValue();
        Account account = this.accountInput.getSelectedAccount();
        PoolDepreciationStrategy newStrategy = new PoolDepreciationStrategy(this.receipt.getDepreciationStrategy().getStartYear(), years, this.receipt);
        this.receipt.setDepreciationStrategy(newStrategy);
        ((DepreciationPool)this.receipt).setAccount(account.getAccountNumber());
        this.receipt.setChanged();
        this.receipt.notifyObservers();
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleEditDepreciation");
    }
}

