/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation.gui;

import de.uwemock.eur.depreciation.ExtraDepreciation;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.tools.Numbers;
import java.math.BigDecimal;
import javax.swing.table.AbstractTableModel;

public class ExtraDepreciationTableModel
extends AbstractTableModel {
    private static final String[] COLUMNS_EXTRA_DEPRECIATION = TextPool.getArray("COLUMNS_EXTRA_DEPRECIATION");
    private ExtraDepreciation extraDepreciation;
    private int currentYear;
    private boolean editable = false;

    public ExtraDepreciationTableModel(ExtraDepreciation extraDepreciation, int currentYear) {
        this.extraDepreciation = extraDepreciation;
        this.currentYear = currentYear;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this.extraDepreciation != null) {
            return this.extraDepreciation.getNumYears();
        }
        return 0;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNS_EXTRA_DEPRECIATION[columnIndex];
    }

    @Override
    public Object getValueAt(int y, int x) {
        int year = this.extraDepreciation.getStartYear() + y;
        if (x == 0) {
            return year;
        }
        return this.extraDepreciation.getPercentForYear(year);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        assert (columnIndex > 0) : "Changing column 0 in ExtraDepreciationTableModel";
        BigDecimal newValue = null;
        if (aValue == null || "".equals(aValue.toString())) {
            return;
        }
        try {
            if (aValue instanceof BigDecimal) {
                newValue = (BigDecimal)aValue;
            }
            if (aValue instanceof String) {
                newValue = new BigDecimal(((String)aValue).replace(",", "."));
            }
            if (aValue instanceof Double) {
                newValue = new BigDecimal(((Double)aValue).intValue());
            }
        }
        catch (Exception e) {
            return;
        }
        if (newValue != null && !Numbers.isNegative(newValue)) {
            BigDecimal oldValue;
            int year = this.extraDepreciation.getStartYear() + rowIndex;
            BigDecimal maxPercentage = (BigDecimal)ExtraDepreciation.getSettingsCluster().getSettingValue("maxValue");
            BigDecimal currentTotal = this.extraDepreciation.getTotalPercent();
            BigDecimal newTotal = currentTotal.subtract(oldValue = this.extraDepreciation.getPercentForYear(year)).add(newValue);
            if (newTotal.compareTo(maxPercentage) <= 0) {
                this.extraDepreciation.setPercentForYear(year, newValue);
                this.dataChanged();
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        return this.editable || this.extraDepreciation.getStartYear() + rowIndex >= this.currentYear;
    }

    void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void dataChanged() {
        this.fireTableDataChanged();
    }
}

