/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation.gui;

import de.uwemock.eur.accounts.gui.AccountComboBox;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.ExtraDepreciation;
import de.uwemock.eur.depreciation.gui.ExtraDepreciationTableModel;
import de.uwemock.eur.gui.PercentCellRenderer;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.TableColumnsSizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ExtraDepreciationEditPanel
extends AbstractStandardDialogPanel
implements TableModelListener {
    private ExtraDepreciation extraDepreciation;
    private JLabel infoLabel = new JLabel();
    private AccountComboBox accountInput;
    private JCheckBox recalculationInput = new JCheckBox(TextPool.getString("labelExtraDepreciationRecalculation"));
    private JCheckBox allowChangesInput = new JCheckBox(TextPool.getString("labelExtraDepreciationAllowChanges"));
    private JSpinner depreciationYears;
    private ExtraDepreciationTableModel tableModel;
    private boolean editAllowed;

    public ExtraDepreciationEditPanel(ExtraDepreciation extraDepreciation, int currentYear) {
        this(extraDepreciation, currentYear, true);
    }

    public ExtraDepreciationEditPanel(ExtraDepreciation extraDepreciation, int currentYear, boolean editAllowed) {
        this.extraDepreciation = extraDepreciation.getCopy();
        this.editAllowed = editAllowed;
        this.accountInput = new AccountComboBox(DataCenter.getInstance().getAccountList());
        int defaultAccount = (Integer)ExtraDepreciation.getSettingsCluster().getSettingValue("defaultAccount");
        this.accountInput.setSelectedAccount(defaultAccount);
        this.accountInput.setSelectedAccount(this.extraDepreciation.getAccount());
        JPanel accountPanel = new JPanel(new BorderLayout());
        accountPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleAccountSelectionDialog")));
        accountPanel.add((Component)this.accountInput, "West");
        this.tableModel = new ExtraDepreciationTableModel(this.extraDepreciation, currentYear);
        JTable table = new JTable(this.tableModel){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }
        };
        table.getModel().addTableModelListener(this);
        table.getColumnModel().getColumn(1).setCellRenderer(new PercentCellRenderer());
        JScrollPane scrollPane = new JScrollPane(table);
        TableColumnsSizer tcs = new TableColumnsSizer();
        table.setPreferredScrollableViewportSize(tcs.getPreferredScrollableViewportSize(table, 10));
        this.depreciationYears = new JSpinner(new SpinnerNumberModel(this.extraDepreciation.getNumYears(), 1, 99, 1));
        this.depreciationYears.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int newNumYears = ((Number)ExtraDepreciationEditPanel.this.depreciationYears.getModel().getValue()).intValue();
                ExtraDepreciationEditPanel.this.extraDepreciation.setNumYears(newNumYears);
                ExtraDepreciationEditPanel.this.tableModel.fireTableDataChanged();
            }
        });
        JPanel yearsPanel = new JPanel(new FlowLayout(0));
        yearsPanel.add(new JLabel(TextPool.getString("labelDepreciationYears")));
        yearsPanel.add(this.depreciationYears);
        JPanel recalcPanel = new JPanel(new FlowLayout(0));
        recalcPanel.add(this.recalculationInput);
        this.recalculationInput.setSelected(this.extraDepreciation.doRecalculate());
        this.recalculationInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExtraDepreciationEditPanel.this.extraDepreciation.setRecalculate(ExtraDepreciationEditPanel.this.recalculationInput.isSelected());
            }
        });
        JPanel allowChangesPanel = new JPanel(new FlowLayout(0));
        allowChangesPanel.add(this.allowChangesInput);
        this.allowChangesInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                boolean allow = ExtraDepreciationEditPanel.this.allowChangesInput.isSelected();
                ExtraDepreciationEditPanel.this.tableModel.setEditable(allow);
                if (allow) {
                    JOptionPane.showMessageDialog(ExtraDepreciationEditPanel.this, TextPool.getString("msgAllowExtraDepreciationChanges"), TextPool.getString("titleInformation"), 2);
                }
            }
        });
        JPanel settingsSouthPanel = new JPanel();
        BoxLayout bl = new BoxLayout(settingsSouthPanel, 3);
        settingsSouthPanel.setLayout(bl);
        settingsSouthPanel.add(yearsPanel);
        settingsSouthPanel.add(recalcPanel);
        settingsSouthPanel.add(allowChangesPanel);
        JPanel settingsPanel = new JPanel(new BorderLayout());
        settingsPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleDepreciationStrategy")));
        settingsPanel.add((Component)scrollPane, "Center");
        settingsPanel.add((Component)settingsSouthPanel, "South");
        JPanel infoPanel = new JPanel(new BorderLayout());
        infoPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleInformation")));
        infoPanel.add((Component)this.infoLabel, "Center");
        this.setLayout(new BoxLayout(this, 1));
        this.add(accountPanel);
        this.add(settingsPanel);
        this.add(infoPanel);
        this.doLayout();
        this.tableChanged(null);
        if (!this.editAllowed) {
            GuiTools.setAllComponentsEnabled(this, false);
        }
    }

    @Override
    public void saveDialogData() {
        if (!this.editAllowed) {
            return;
        }
        this.extraDepreciation.setAccount(this.accountInput.getSelectedAccountNumber());
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleExtraDeprecitaion");
    }

    @Override
    public void tableChanged(TableModelEvent arg0) {
        BigDecimal percent = this.extraDepreciation.getTotalPercent();
        this.infoLabel.setText(String.valueOf(TextPool.getString("labelExtraDepreciationTotalPercent")) + percent.toPlainString() + "%");
    }

    public ExtraDepreciation getExtraDepreciation() {
        return this.extraDepreciation;
    }
}

