/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation.gui;

import de.uwemock.eur.depreciation.DepreciationInfoRecord;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.gui.TextPool;
import javax.swing.table.AbstractTableModel;

public class DepreciationStrategyCalculationTableModel
extends AbstractTableModel {
    private static String[] COLUMNS_DEPRECIATION_CALCULATION_TABLE = TextPool.getArray("COLUMNS_DEPRECIATION_CALCULATION_TABLE");
    private DepreciationStrategy strategy;

    public DepreciationStrategyCalculationTableModel(DepreciationStrategy strategy) {
        this.strategy = strategy;
    }

    public void setDepreciationStrategy(DepreciationStrategy strategy) {
        this.strategy = strategy;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return COLUMNS_DEPRECIATION_CALCULATION_TABLE.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNS_DEPRECIATION_CALCULATION_TABLE[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.strategy.getNumYears() + 1;
    }

    @Override
    public Object getValueAt(int y, int x) {
        int targetYear = this.strategy.getStartYear() + y;
        DepreciationInfoRecord info = this.strategy.getInfoRecord(targetYear);
        switch (x) {
            case 0: {
                return targetYear;
            }
            case 1: {
                return info.getAmountStartOfYear();
            }
            case 2: {
                return info.getDepreciation();
            }
            case 3: {
                return info.getExtraDepreciation();
            }
            case 4: {
                return info.getAmountEndOfYear();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int y, int x) {
        return false;
    }
}

