/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation.gui;

import de.uwemock.datetools.Date;
import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.AbstractDepreciationStrategy;
import de.uwemock.eur.depreciation.DecliningBalanceDepreciationStrategy;
import de.uwemock.eur.depreciation.DefaultDepreciationStrategy;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.Payment;
import java.awt.Frame;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import javax.swing.JOptionPane;

public class DepreciationFactory {
    public static DepreciationStrategy createDepreciationStrategy(Frame parent, AbstractReceipt receipt, int type, int numYears, Date date, int businessYear) {
        Collection<Integer> receiptAccountNumbers;
        Integer a;
        Account account = null;
        AbstractDepreciationStrategy strategy = null;
        if (type == 0) {
            strategy = new DefaultDepreciationStrategy(businessYear, numYears, receipt);
            a = (Integer)DefaultDepreciationStrategy.getSettingsCluster().getSettingValue("defaultAccount");
            account = DataCenter.getInstance().getAccountList().getByAccountNumber(a);
        }
        if (type == 1) {
            strategy = new DecliningBalanceDepreciationStrategy(businessYear, numYears, new BigDecimal(250.0 / (double)numYears).setScale(1, RoundingMode.DOWN), businessYear + numYears, receipt);
            a = (Integer)DefaultDepreciationStrategy.getSettingsCluster().getSettingValue("defaultAccount");
            account = DataCenter.getInstance().getAccountList().getByAccountNumber(a);
        }
        if (!(account == null || (receiptAccountNumbers = receipt.accountNumbersAddedTo()).size() == 1 && receiptAccountNumbers.contains(account.getAccountNumber()))) {
            StringBuilder receiptAccounts = new StringBuilder();
            for (Integer a2 : receiptAccountNumbers) {
                Account accountFromList = DataCenter.getInstance().getAccountList().getByAccountNumber(a2);
                if (accountFromList != null) {
                    receiptAccounts.append(accountFromList.toString());
                } else {
                    receiptAccounts.append(TextPool.getString("labelAccountUnknown"));
                }
                receiptAccounts.append('\n');
            }
            String defaultAccount = account.toString();
            String message = String.format(TextPool.getString("msgSetDepreciationDefaultAccount"), receiptAccounts.toString(), defaultAccount);
            int res = JOptionPane.showConfirmDialog(parent, message, TextPool.getString("titleAddDepreciation"), 0);
            if (res == 0) {
                Collection payments = (Collection)receipt.getReceiptInfo(15);
                for (Payment payment : payments) {
                    payment.setAccount(account.getAccountNumber());
                }
            }
        }
        if (date != null) {
            strategy.setOriginalReceiptDate(date);
        }
        return strategy;
    }
}

