/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation.gui;

import com.toedter.calendar.JDateChooser;
import de.uwemock.datetools.Date;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class DepreciationCreationPanel
extends AbstractStandardDialogPanel {
    private JComboBox type = new JComboBox<String>(TextPool.getArray("DEPRECIATION_TYPES"));
    private JSpinner years = new JSpinner(new SpinnerNumberModel(5, 2, 99, 1));
    private JCheckBox useDate = new JCheckBox(TextPool.getString("labelDepreciationDateInPreviousYear"));
    private JDateChooser dateInput = new JDateChooser();
    private int numYears = 0;
    private int depreciationType = -1;

    public DepreciationCreationPanel(Date receiptDate) {
        JPanel upperPanel = new JPanel(new GridLayout(2, 2, 10, 10));
        upperPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleGeneral")));
        upperPanel.add(new JLabel(TextPool.getString("labelDepreciationType")));
        upperPanel.add(this.type);
        upperPanel.add(new JLabel(TextPool.getString("labelDepreciationYears")));
        upperPanel.add(this.years);
        JPanel datePanel = new JPanel(new BorderLayout(4, 0));
        datePanel.add("West", new JLabel(TextPool.getString("labelDatePurchased")));
        datePanel.add("Center", this.dateInput);
        JPanel useDatePanel = new JPanel(new FlowLayout(0));
        useDatePanel.add(this.useDate);
        JPanel lowerPanel = new JPanel();
        lowerPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleDatePurchased")));
        lowerPanel.setLayout(new BoxLayout(lowerPanel, 1));
        lowerPanel.add(useDatePanel);
        lowerPanel.add(datePanel);
        this.setLayout(new BorderLayout());
        this.add("North", upperPanel);
        this.add("South", lowerPanel);
        this.useDate.setSelected(false);
        this.dateInput.setEnabled(false);
        this.dateInput.setCalendar(receiptDate.toJavaCalendar());
        this.dateInput.setDateFormatString(SettingsManager.getInstance().getDateFormat().getFormatString());
        this.useDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DepreciationCreationPanel.this.dateInput.setEnabled(DepreciationCreationPanel.this.useDate.isSelected());
            }
        });
    }

    public int getNumYears() {
        return this.numYears;
    }

    public void setNumYears(int numYears) {
        this.years.setValue(numYears);
    }

    public int getDepreciationType() {
        return this.depreciationType;
    }

    public void setDepreciationType(int depreciationType) {
        this.type.setSelectedIndex(depreciationType);
    }

    public Date getDate() {
        if (this.useDate.isSelected()) {
            return Date.getDate(this.dateInput.getCalendar());
        }
        return null;
    }

    public void setDate(Date date) {
        if (date != null) {
            this.useDate.setSelected(true);
            this.dateInput.setEnabled(true);
            this.dateInput.setDate(date.toJavaCalendar().getTime());
        }
    }

    @Override
    public void saveDialogData() {
        this.numYears = ((Number)this.years.getModel().getValue()).intValue();
        this.depreciationType = this.type.getSelectedIndex();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleAddDepreciation");
    }
}

