/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation.gui;

import chrriis.dj.swingsuite.SwingSuiteUtilities;
import com.toedter.calendar.JDateChooser;
import de.uwemock.datetools.Date;
import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.depreciation.DecliningBalanceDepreciationStrategy;
import de.uwemock.eur.depreciation.DefaultDepreciationStrategy;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.ExtraDepreciation;
import de.uwemock.eur.depreciation.gui.AbstractDepreciationEditor;
import de.uwemock.eur.depreciation.gui.DepreciationStrategyCalculationTableModel;
import de.uwemock.eur.depreciation.gui.ExtraDepreciationEditPanel;
import de.uwemock.eur.gui.MoneyCellRenderer;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.PushUpPanel;
import de.uwemock.tools.Numbers;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

public class DepreciationAssistant
extends AbstractStandardDialogPanel
implements Observer {
    private DepreciationStrategy[] testStrategies;
    private DepreciationStrategy currentStrategy;
    private ExtraDepreciation extraDepreciation;
    private int currentYear;
    private AbstractReceipt receipt;
    private JComboBox strategyTypeInput = new JComboBox<String>(TextPool.getArray("DEPRECIATION_TYPES"));
    private JCheckBox useExtraDepreciation = new JCheckBox(TextPool.getString("labelUseExtraDepreciation"));
    private JTabbedPane depreciationSettings = new JTabbedPane();
    private JPanel panelRightTop;
    private JPanel settingsPanel = new JPanel(new CardLayout());
    private JPanel extraDepreciationPanel = new JPanel(new CardLayout());
    private JDateChooser purchaseDateInput = new JDateChooser();
    private ExtraDepreciationEditPanel editorExtraDepreciation;
    private AbstractDepreciationEditor[] editorDepreciation;
    private JTable calculationTable;
    private DepreciationStrategyCalculationTableModel tableModel;
    private boolean editAllowed;

    public DepreciationAssistant(DepreciationStrategy currentStrategy, int currentYear, AbstractReceipt receipt) {
        this(currentStrategy, currentYear, receipt, true);
    }

    public DepreciationAssistant(DepreciationStrategy currentStrategy, int currentYear, AbstractReceipt receipt, boolean editAllowed) {
        this.editAllowed = editAllowed;
        this.currentStrategy = currentStrategy;
        this.currentYear = currentYear;
        this.receipt = receipt;
        this.setupStrategies();
        this.createComponentTree();
        this.connectListeners();
        SwingSuiteUtilities.autoFitTableColumns(this.calculationTable, Integer.MAX_VALUE);
        if (this.currentYear > this.currentStrategy.getStartYear()) {
            this.strategyTypeInput.setEnabled(false);
        }
        if (this.currentStrategy.hasExtraDepreciation()) {
            ExtraDepreciation e = this.currentStrategy.getExtraDepreciation();
            int year = this.currentStrategy.getStartYear();
            while (year < this.currentYear) {
                if (Numbers.isPositive(e.getPercentForYear(year))) {
                    this.useExtraDepreciation.setEnabled(false);
                }
                ++year;
            }
        }
        if (!editAllowed) {
            GuiTools.setAllComponentsEnabled(this.panelRightTop, false);
            GuiTools.setAllComponentsEnabled(this.settingsPanel, false);
            GuiTools.setAllComponentsEnabled(this.extraDepreciationPanel, false);
        }
    }

    private void setupStrategies() {
        int startYear = this.currentStrategy.getStartYear();
        int numYears = this.currentStrategy.getNumYears();
        Date originalReceiptDate = this.currentStrategy.getOriginalReceiptDate();
        BigDecimal percent = new BigDecimal(250).setScale(2).divide(new BigDecimal(numYears), RoundingMode.DOWN);
        int startYearLinear = startYear + numYears - Constants.ONEHUNDRED.divide(percent, RoundingMode.DOWN).intValue() + 1;
        if (startYearLinear > startYear + numYears) {
            startYearLinear = startYear + numYears;
        }
        this.testStrategies = new DepreciationStrategy[2];
        this.testStrategies[0] = new DefaultDepreciationStrategy(startYear, numYears, this.receipt, originalReceiptDate);
        BigDecimal decliningPercent = percent;
        BigDecimal decliningMaxPercent = (BigDecimal)DecliningBalanceDepreciationStrategy.getSettingsCluster().getSetting("maxValue").getCurrentValue();
        if (Numbers.isNegative(decliningMaxPercent.subtract(decliningPercent))) {
            decliningPercent = decliningMaxPercent;
        }
        this.testStrategies[1] = new DecliningBalanceDepreciationStrategy(startYear, numYears, decliningPercent, startYearLinear, this.receipt);
        if (this.currentStrategy instanceof DefaultDepreciationStrategy) {
            this.testStrategies[0] = this.currentStrategy;
        }
        if (this.currentStrategy instanceof DecliningBalanceDepreciationStrategy) {
            this.testStrategies[1] = this.currentStrategy;
        }
        this.editorDepreciation = new AbstractDepreciationEditor[this.testStrategies.length];
        int i = 0;
        while (i < this.testStrategies.length) {
            this.editorDepreciation[i] = this.testStrategies[i].getDepreciationEditor(this.currentYear, this.receipt);
            this.testStrategies[i] = this.editorDepreciation[i].getDepreciationStrategy();
            if (this.currentStrategy.getClass().equals(this.testStrategies[i].getClass())) {
                this.currentStrategy = this.testStrategies[i];
            }
            ++i;
        }
        if (this.currentStrategy.hasExtraDepreciation()) {
            this.editorExtraDepreciation = new ExtraDepreciationEditPanel(this.currentStrategy.getExtraDepreciation(), this.currentYear);
            DepreciationStrategy[] depreciationStrategyArray = this.testStrategies;
            int n = this.testStrategies.length;
            int n2 = 0;
            while (n2 < n) {
                DepreciationStrategy strategy = depreciationStrategyArray[n2];
                strategy.setExtraDepreciation(this.editorExtraDepreciation.getExtraDepreciation());
                ++n2;
            }
        } else {
            this.editorExtraDepreciation = new ExtraDepreciationEditPanel(new ExtraDepreciation(this.currentStrategy.getStartYear()), this.currentYear);
        }
        this.extraDepreciation = this.editorExtraDepreciation.getExtraDepreciation();
        this.extraDepreciation.addObserver(this);
    }

    private void createComponentTree() {
        JPanel panelLeft = new JPanel(new BorderLayout(0, 10));
        panelLeft.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleDepreciationCalculation")));
        this.tableModel = new DepreciationStrategyCalculationTableModel(this.currentStrategy);
        this.calculationTable = new JTable(this.tableModel);
        int i = 1;
        while (i < 5) {
            this.calculationTable.getColumnModel().getColumn(i).setCellRenderer(new MoneyCellRenderer());
            ++i;
        }
        this.calculationTable.getSelectionModel().setSelectionMode(0);
        panelLeft.add((Component)new JScrollPane(this.calculationTable), "Center");
        JPanel panelRight = new JPanel(new BorderLayout(10, 10));
        JPanel purchaseDatePanel = new JPanel(new BorderLayout(10, 0));
        purchaseDatePanel.add("West", new JLabel(TextPool.getString("labelDatePurchased")));
        purchaseDatePanel.add("Center", this.purchaseDateInput);
        this.panelRightTop = new JPanel();
        this.panelRightTop.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleGeneral")));
        this.panelRightTop.setLayout(new GridLayout(3, 1, 0, 4));
        this.panelRightTop.add(purchaseDatePanel);
        this.panelRightTop.add(this.strategyTypeInput);
        this.panelRightTop.add(this.useExtraDepreciation);
        panelRight.add((Component)this.panelRightTop, "North");
        panelRight.add((Component)this.depreciationSettings, "South");
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)new JSplitPane(1, panelLeft, panelRight), "Center");
        int i2 = 0;
        while (i2 < this.editorDepreciation.length) {
            PushUpPanel p = new PushUpPanel(this.editorDepreciation[i2]);
            this.settingsPanel.add((Component)p, Integer.toString(i2));
            ++i2;
        }
        this.extraDepreciationPanel.add((Component)new JPanel(), "0");
        PushUpPanel p = new PushUpPanel(this.editorExtraDepreciation.getComponent());
        this.extraDepreciationPanel.add((Component)p, "1");
        this.depreciationSettings.insertTab(TextPool.getString("titleDepreciation"), null, this.settingsPanel, null, 0);
        this.depreciationSettings.insertTab(TextPool.getString("titleExtraDeprecitaion"), null, this.extraDepreciationPanel, null, 1);
        int i3 = 0;
        while (i3 < this.testStrategies.length) {
            if (this.testStrategies[i3].getClass().equals(this.currentStrategy.getClass())) {
                this.strategyTypeInput.setSelectedIndex(i3);
                this.setSettingsPanel(Integer.toString(i3));
                if (this.testStrategies[i3] instanceof Observable) {
                    Observable observable = (Observable)((Object)this.testStrategies[i3]);
                    observable.addObserver(this);
                    if (this.editorDepreciation[i3] instanceof Observer) {
                        Observer observer = (Observer)((Object)this.editorDepreciation[i3]);
                        observable.addObserver(observer);
                    }
                }
            }
            ++i3;
        }
        this.useExtraDepreciation.setSelected(this.currentStrategy.hasExtraDepreciation());
        if (this.currentStrategy.hasExtraDepreciation()) {
            this.setExtraDepreciationPanel("1");
        }
        this.purchaseDateInput.setCalendar(this.currentStrategy.getOriginalReceiptDate().toJavaCalendar());
        this.purchaseDateInput.setDateFormatString(SettingsManager.getInstance().getDateFormat().getFormatString());
    }

    private void connectListeners() {
        this.useExtraDepreciation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                boolean useExtraDepreciation = DepreciationAssistant.this.useExtraDepreciation.isSelected();
                DepreciationAssistant.this.setExtraDepreciationPanel(useExtraDepreciation ? "1" : "0");
                DepreciationStrategy[] depreciationStrategyArray = DepreciationAssistant.this.testStrategies;
                int n = depreciationStrategyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DepreciationStrategy ds = depreciationStrategyArray[n2];
                    ds.setExtraDepreciation(useExtraDepreciation ? DepreciationAssistant.this.extraDepreciation : null);
                    ++n2;
                }
            }
        });
        this.strategyTypeInput.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                int item = DepreciationAssistant.this.strategyTypeInput.getSelectedIndex();
                DepreciationStrategy selectedStrategy = DepreciationAssistant.this.testStrategies[item];
                AbstractDepreciationEditor selectedStrategyEditor = DepreciationAssistant.this.editorDepreciation[item];
                DepreciationAssistant.this.setSettingsPanel(Integer.toString(item));
                DepreciationStrategy[] depreciationStrategyArray = DepreciationAssistant.this.testStrategies;
                int n = depreciationStrategyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DepreciationStrategy ds = depreciationStrategyArray[n2];
                    if (ds instanceof Observable) {
                        Observable observable = (Observable)((Object)ds);
                        observable.deleteObserver(DepreciationAssistant.this);
                        AbstractDepreciationEditor[] abstractDepreciationEditorArray = DepreciationAssistant.this.editorDepreciation;
                        int n3 = abstractDepreciationEditorArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            AbstractDepreciationEditor editor = abstractDepreciationEditorArray[n4];
                            if (editor instanceof Observer) {
                                observable.deleteObserver((Observer)((Object)editor));
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                if (selectedStrategy instanceof Observable) {
                    Observable observable = (Observable)((Object)selectedStrategy);
                    observable.addObserver(DepreciationAssistant.this);
                    if (selectedStrategyEditor instanceof Observer) {
                        observable.addObserver((Observer)((Object)selectedStrategyEditor));
                    }
                }
                DepreciationAssistant.this.tableModel.setDepreciationStrategy(selectedStrategy);
            }
        });
        this.purchaseDateInput.getDateEditor().addPropertyChangeListener("date", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Date newDate = Date.getDate(DepreciationAssistant.this.purchaseDateInput.getCalendar());
                DepreciationStrategy[] depreciationStrategyArray = DepreciationAssistant.this.testStrategies;
                int n = depreciationStrategyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DepreciationStrategy ds = depreciationStrategyArray[n2];
                    ds.setOriginalReceiptDate(newDate);
                    ++n2;
                }
                DepreciationAssistant.this.enableStrategyTypeSelection();
            }
        });
    }

    private void enableStrategyTypeSelection() {
        this.strategyTypeInput.setEnabled(this.currentStrategy.getStartYear() == this.currentYear);
    }

    private void setSettingsPanel(String title) {
        CardLayout cl = (CardLayout)this.settingsPanel.getLayout();
        cl.show(this.settingsPanel, title);
    }

    private void setExtraDepreciationPanel(String title) {
        CardLayout cl = (CardLayout)this.extraDepreciationPanel.getLayout();
        cl.show(this.extraDepreciationPanel, title);
    }

    @Override
    public void dialogOpens() {
    }

    @Override
    public void saveDialogData() {
        if (!this.editAllowed) {
            return;
        }
        Object[] objectArray = this.testStrategies;
        int n = this.testStrategies.length;
        int n2 = 0;
        while (n2 < n) {
            DepreciationStrategy ds = objectArray[n2];
            if (ds instanceof Observable) {
                Observable o = (Observable)((Object)ds);
                o.deleteObserver(this);
            }
            ++n2;
        }
        objectArray = this.editorDepreciation;
        n = this.editorDepreciation.length;
        n2 = 0;
        while (n2 < n) {
            Object editor = objectArray[n2];
            ((AbstractStandardDialogPanel)editor).saveDialogData();
            ++n2;
        }
        this.editorExtraDepreciation.saveDialogData();
        int item = this.strategyTypeInput.getSelectedIndex();
        this.receipt.setDepreciationStrategy(this.testStrategies[item]);
        this.receipt.notifyObservers();
    }

    @Override
    public String getTitle() {
        return "Assistent";
    }

    private void updateCalculation() {
        this.tableModel.fireTableDataChanged();
        SwingSuiteUtilities.autoFitTableColumns(this.calculationTable, Integer.MAX_VALUE);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateCalculation();
    }

    @Override
    public void dispose() {
        DepreciationStrategy[] depreciationStrategyArray = this.testStrategies;
        int n = this.testStrategies.length;
        int n2 = 0;
        while (n2 < n) {
            DepreciationStrategy ds = depreciationStrategyArray[n2];
            if (ds.hasExtraDepreciation()) {
                ds.getExtraDepreciation().deleteObserver(this);
            }
            if (ds instanceof Observable) {
                Observable observable = (Observable)((Object)ds);
                observable.deleteObserver(this);
            }
            ++n2;
        }
        if (this.currentStrategy instanceof Observable) {
            Observable observable = (Observable)((Object)this.currentStrategy);
            observable.deleteObserver(this);
        }
    }
}

