/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation.gui;

import de.uwemock.eur.depreciation.DefaultDepreciationStrategy;
import de.uwemock.eur.depreciation.DepreciationRecord;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.tools.Numbers;
import java.math.BigDecimal;
import javax.swing.table.DefaultTableModel;

public class DefaultDepreciationTableModel
extends DefaultTableModel {
    private static String[] COLUMNS_DEFAULT_DEPRECIATION = TextPool.getArray("COLUMNS_DEFAULT_DEPRECIATION");
    private DefaultDepreciationStrategy strategy;
    private int currentYear;

    public DefaultDepreciationTableModel(int currentYear, DefaultDepreciationStrategy strategy) {
        this.strategy = strategy;
        this.currentYear = currentYear;
    }

    @Override
    public int getColumnCount() {
        return COLUMNS_DEFAULT_DEPRECIATION.length;
    }

    @Override
    public int getRowCount() {
        if (this.strategy != null) {
            return this.strategy.getNumYears() + 1;
        }
        return 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DepreciationRecord dr = this.strategy.getDepreciationRecord(rowIndex);
        switch (columnIndex) {
            case 0: {
                return dr.getYear();
            }
            case 1: {
                return dr.getMonths();
            }
            case 2: {
                return dr.getPercentAmount();
            }
            case 3: {
                return dr.getPercentTax();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        assert (columnIndex > 0) : "Changing column 0 in DepreciationTableModel";
        BigDecimal newValue = null;
        if (aValue == null || "".equals(aValue.toString())) {
            return;
        }
        try {
            if (aValue instanceof BigDecimal) {
                newValue = (BigDecimal)aValue;
            }
            if (aValue instanceof String) {
                newValue = new BigDecimal(((String)aValue).replace(",", "."));
            }
            if (aValue instanceof Double) {
                newValue = new BigDecimal(((Double)aValue).intValue());
            }
        }
        catch (Exception e) {
            return;
        }
        if (newValue != null && !Numbers.isNegative(newValue)) {
            BigDecimal oldValue = null;
            if (columnIndex == 2) {
                oldValue = this.strategy.getPercentAmount(this.strategy.getStartYear() + rowIndex);
                this.strategy.setPercentAmount(this.strategy.getStartYear() + rowIndex, newValue);
            }
            if (columnIndex == 3) {
                oldValue = this.strategy.getPercentTax(this.strategy.getStartYear() + rowIndex);
                this.strategy.setPercentTax(this.strategy.getStartYear() + rowIndex, newValue);
            }
            this.strategy.calculateLastYear();
            DepreciationRecord drLast = this.strategy.getDepreciationRecord(this.strategy.getNumYears() - 1);
            if (columnIndex == 2 && Numbers.isNegative(drLast.getPercentAmount())) {
                this.strategy.setPercentAmount(this.strategy.getStartYear() + rowIndex, oldValue);
                this.strategy.calculateLastYear();
            }
            if (columnIndex == 3 && Numbers.isNegative(drLast.getPercentTax())) {
                this.strategy.setPercentTax(this.strategy.getStartYear() + rowIndex, oldValue);
                this.strategy.calculateLastYear();
            }
        }
        this.dataChanged();
    }

    public DepreciationRecord getItemAt(int rowIndex) {
        return this.strategy.getDepreciationRecord(rowIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNS_DEFAULT_DEPRECIATION[columnIndex];
    }

    public void dataChanged() {
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex <= 1 || rowIndex >= this.strategy.getNumYears() - 1) {
            return false;
        }
        return this.strategy.getDepreciationRecord(rowIndex).getYear() >= this.currentYear;
    }
}

