/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation.gui;

import de.uwemock.eur.depreciation.DefaultDepreciationStrategy;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.gui.AbstractDepreciationEditor;
import de.uwemock.eur.depreciation.gui.DefaultDepreciationTableModel;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.guitools.TableColumnsSizer;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultDepreciationEditPanel
extends AbstractDepreciationEditor
implements Observer {
    private int currentYear;
    private DefaultDepreciationStrategy strategy;
    private JTable depreciationTable;
    private JButton buttonAmountLinear;

    public DefaultDepreciationEditPanel(int currentYear, DepreciationStrategy strategy, AbstractReceipt receipt) {
        this.currentYear = currentYear;
        this.strategy = strategy != null ? (DefaultDepreciationStrategy)strategy.getCopy() : new DefaultDepreciationStrategy(receipt.getDate().getYear(), 5, receipt);
        this.createComponentTree();
        this.doLayout();
        this.buttonAmountLinear.setEnabled(this.strategy.getStartYear() == this.currentYear);
    }

    private void createComponentTree() {
        this.setupNumYearsSpinner(this.currentYear, this.strategy);
        this.numYearsInput.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int newNumYears = ((Number)DefaultDepreciationEditPanel.this.numYearsInput.getModel().getValue()).intValue();
                while (newNumYears > DefaultDepreciationEditPanel.this.strategy.getNumYears()) {
                    DefaultDepreciationEditPanel.this.strategy.addDepreciationRecord();
                }
                while (newNumYears < DefaultDepreciationEditPanel.this.strategy.getNumYears()) {
                    DefaultDepreciationEditPanel.this.strategy.removeLastDepreciationRecord();
                }
                ((DefaultDepreciationTableModel)DefaultDepreciationEditPanel.this.depreciationTable.getModel()).fireTableDataChanged();
            }
        });
        this.buttonAmountLinear = new JButton(new AbstractAction(TextPool.getString("buttonDepreciationMakeAmountLinear")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultDepreciationEditPanel.this.strategy.setupDefaultAmountDepreciation();
                ((DefaultDepreciationTableModel)DefaultDepreciationEditPanel.this.depreciationTable.getModel()).fireTableDataChanged();
            }
        });
        this.enableAmountLinearButton();
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleDepreciationStrategy")));
        this.depreciationTable = new JTable(new DefaultDepreciationTableModel(this.currentYear, this.strategy));
        tablePanel.add("Center", new JScrollPane(this.depreciationTable));
        TableColumnsSizer tcs = new TableColumnsSizer();
        this.depreciationTable.setPreferredScrollableViewportSize(tcs.getPreferredScrollableViewportSize(this.depreciationTable, 10));
        JPanel yearPanel = new JPanel(new FlowLayout(0, 0, 10));
        yearPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleDepreciationYears")));
        yearPanel.add(new JLabel(TextPool.getString("labelDepreciationYears1")));
        yearPanel.add(this.numYearsInput);
        yearPanel.add(new JLabel(TextPool.getString("labelDepreciationYears2")));
        JPanel buttonPanel = new JPanel(new GridLayout(1, 1, 0, 10));
        buttonPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleDepreciationButtons")));
        buttonPanel.add(this.buttonAmountLinear);
        this.setLayout(new BorderLayout(0, 10));
        this.add("North", yearPanel);
        this.add("Center", tablePanel);
        this.add("South", buttonPanel);
    }

    private void enableAmountLinearButton() {
        this.buttonAmountLinear.setEnabled(this.currentYear == this.strategy.getStartYear());
    }

    @Override
    public DepreciationStrategy getDepreciationStrategy() {
        return this.strategy;
    }

    @Override
    public void update(Observable o, Object arg) {
        DefaultDepreciationTableModel model = (DefaultDepreciationTableModel)this.depreciationTable.getModel();
        model.fireTableDataChanged();
        this.enableAmountLinearButton();
    }
}

